# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class Service(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Service - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'status': 'str',
            'domains': 'list[str]',
            'service_types': 'list[ServiceType]',
            'gateways': 'list[Gateway]',
            'dns': 'Dns',
            'vpn': 'Vpn',
            'carrier': 'Carrier',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'status': 'status',
            'domains': 'domains',
            'service_types': 'serviceTypes',
            'gateways': 'gateways',
            'dns': 'dns',
            'vpn': 'vpn',
            'carrier': 'carrier',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._status = None
        self._domains = None
        self._service_types = None
        self._gateways = None
        self._dns = None
        self._vpn = None
        self._carrier = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this Service.
        The globally unique identifier for the object.

        :return: The id of this Service.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Service.
        The globally unique identifier for the object.

        :param id: The id of this Service.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Service.


        :return: The name of this Service.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Service.


        :param name: The name of this Service.
        :type: str
        """
        
        self._name = name

    @property
    def status(self):
        """
        Gets the status of this Service.


        :return: The status of this Service.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this Service.


        :param status: The status of this Service.
        :type: str
        """
        
        self._status = status

    @property
    def domains(self):
        """
        Gets the domains of this Service.
        An inbound carrier specific domain (i.e. lb.domain.com)

        :return: The domains of this Service.
        :rtype: list[str]
        """
        return self._domains

    @domains.setter
    def domains(self, domains):
        """
        Sets the domains of this Service.
        An inbound carrier specific domain (i.e. lb.domain.com)

        :param domains: The domains of this Service.
        :type: list[str]
        """
        
        self._domains = domains

    @property
    def service_types(self):
        """
        Gets the service_types of this Service.


        :return: The service_types of this Service.
        :rtype: list[ServiceType]
        """
        return self._service_types

    @service_types.setter
    def service_types(self, service_types):
        """
        Sets the service_types of this Service.


        :param service_types: The service_types of this Service.
        :type: list[ServiceType]
        """
        
        self._service_types = service_types

    @property
    def gateways(self):
        """
        Gets the gateways of this Service.


        :return: The gateways of this Service.
        :rtype: list[Gateway]
        """
        return self._gateways

    @gateways.setter
    def gateways(self, gateways):
        """
        Sets the gateways of this Service.


        :param gateways: The gateways of this Service.
        :type: list[Gateway]
        """
        
        self._gateways = gateways

    @property
    def dns(self):
        """
        Gets the dns of this Service.


        :return: The dns of this Service.
        :rtype: Dns
        """
        return self._dns

    @dns.setter
    def dns(self, dns):
        """
        Sets the dns of this Service.


        :param dns: The dns of this Service.
        :type: Dns
        """
        
        self._dns = dns

    @property
    def vpn(self):
        """
        Gets the vpn of this Service.


        :return: The vpn of this Service.
        :rtype: Vpn
        """
        return self._vpn

    @vpn.setter
    def vpn(self, vpn):
        """
        Sets the vpn of this Service.


        :param vpn: The vpn of this Service.
        :type: Vpn
        """
        
        self._vpn = vpn

    @property
    def carrier(self):
        """
        Gets the carrier of this Service.


        :return: The carrier of this Service.
        :rtype: Carrier
        """
        return self._carrier

    @carrier.setter
    def carrier(self, carrier):
        """
        Sets the carrier of this Service.


        :param carrier: The carrier of this Service.
        :type: Carrier
        """
        
        self._carrier = carrier

    @property
    def self_uri(self):
        """
        Gets the self_uri of this Service.
        The URI for this object

        :return: The self_uri of this Service.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this Service.
        The URI for this object

        :param self_uri: The self_uri of this Service.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

