# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class ServiceType(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ServiceType - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'type': 'str',
            'parameters': 'dict(str, str)',
            'codecs': 'list[str]',
            'strip': 'str',
            'calling_party_id': 'str',
            'call_history': 'str',
            'prefix': 'str'
        }

        self.attribute_map = {
            'type': 'type',
            'parameters': 'parameters',
            'codecs': 'codecs',
            'strip': 'strip',
            'calling_party_id': 'callingPartyId',
            'call_history': 'callHistory',
            'prefix': 'prefix'
        }

        self._type = None
        self._parameters = None
        self._codecs = None
        self._strip = None
        self._calling_party_id = None
        self._call_history = None
        self._prefix = None

    @property
    def type(self):
        """
        Gets the type of this ServiceType.


        :return: The type of this ServiceType.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this ServiceType.


        :param type: The type of this ServiceType.
        :type: str
        """
        
        self._type = type

    @property
    def parameters(self):
        """
        Gets the parameters of this ServiceType.


        :return: The parameters of this ServiceType.
        :rtype: dict(str, str)
        """
        return self._parameters

    @parameters.setter
    def parameters(self, parameters):
        """
        Sets the parameters of this ServiceType.


        :param parameters: The parameters of this ServiceType.
        :type: dict(str, str)
        """
        
        self._parameters = parameters

    @property
    def codecs(self):
        """
        Gets the codecs of this ServiceType.


        :return: The codecs of this ServiceType.
        :rtype: list[str]
        """
        return self._codecs

    @codecs.setter
    def codecs(self, codecs):
        """
        Sets the codecs of this ServiceType.


        :param codecs: The codecs of this ServiceType.
        :type: list[str]
        """
        
        self._codecs = codecs

    @property
    def strip(self):
        """
        Gets the strip of this ServiceType.
        Prefix striping is a mechanism to remove digits from the beginning of a phone number before sending a call out to a carrier, such as international exit codes. This must be configurable on a per carrier basis as all carriers act differently.

        :return: The strip of this ServiceType.
        :rtype: str
        """
        return self._strip

    @strip.setter
    def strip(self, strip):
        """
        Sets the strip of this ServiceType.
        Prefix striping is a mechanism to remove digits from the beginning of a phone number before sending a call out to a carrier, such as international exit codes. This must be configurable on a per carrier basis as all carriers act differently.

        :param strip: The strip of this ServiceType.
        :type: str
        """
        
        self._strip = strip

    @property
    def calling_party_id(self):
        """
        Gets the calling_party_id of this ServiceType.


        :return: The calling_party_id of this ServiceType.
        :rtype: str
        """
        return self._calling_party_id

    @calling_party_id.setter
    def calling_party_id(self, calling_party_id):
        """
        Sets the calling_party_id of this ServiceType.


        :param calling_party_id: The calling_party_id of this ServiceType.
        :type: str
        """
        
        self._calling_party_id = calling_party_id

    @property
    def call_history(self):
        """
        Gets the call_history of this ServiceType.


        :return: The call_history of this ServiceType.
        :rtype: str
        """
        return self._call_history

    @call_history.setter
    def call_history(self, call_history):
        """
        Sets the call_history of this ServiceType.


        :param call_history: The call_history of this ServiceType.
        :type: str
        """
        
        self._call_history = call_history

    @property
    def prefix(self):
        """
        Gets the prefix of this ServiceType.


        :return: The prefix of this ServiceType.
        :rtype: str
        """
        return self._prefix

    @prefix.setter
    def prefix(self, prefix):
        """
        Sets the prefix of this ServiceType.


        :param prefix: The prefix of this ServiceType.
        :type: str
        """
        
        self._prefix = prefix

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

