# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class SignatureDocumentInfo(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        SignatureDocumentInfo - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'org': 'Organization',
            'user': 'User',
            'return_url': 'str',
            'template': 'DocusignTemplateMapping'
        }

        self.attribute_map = {
            'org': 'org',
            'user': 'user',
            'return_url': 'returnUrl',
            'template': 'template'
        }

        self._org = None
        self._user = None
        self._return_url = None
        self._template = None

    @property
    def org(self):
        """
        Gets the org of this SignatureDocumentInfo.


        :return: The org of this SignatureDocumentInfo.
        :rtype: Organization
        """
        return self._org

    @org.setter
    def org(self, org):
        """
        Sets the org of this SignatureDocumentInfo.


        :param org: The org of this SignatureDocumentInfo.
        :type: Organization
        """
        
        self._org = org

    @property
    def user(self):
        """
        Gets the user of this SignatureDocumentInfo.


        :return: The user of this SignatureDocumentInfo.
        :rtype: User
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this SignatureDocumentInfo.


        :param user: The user of this SignatureDocumentInfo.
        :type: User
        """
        
        self._user = user

    @property
    def return_url(self):
        """
        Gets the return_url of this SignatureDocumentInfo.


        :return: The return_url of this SignatureDocumentInfo.
        :rtype: str
        """
        return self._return_url

    @return_url.setter
    def return_url(self, return_url):
        """
        Sets the return_url of this SignatureDocumentInfo.


        :param return_url: The return_url of this SignatureDocumentInfo.
        :type: str
        """
        
        self._return_url = return_url

    @property
    def template(self):
        """
        Gets the template of this SignatureDocumentInfo.
        Template ID alias for the ESignature template you would like to retrieve.

        :return: The template of this SignatureDocumentInfo.
        :rtype: DocusignTemplateMapping
        """
        return self._template

    @template.setter
    def template(self, template):
        """
        Sets the template of this SignatureDocumentInfo.
        Template ID alias for the ESignature template you would like to retrieve.

        :param template: The template of this SignatureDocumentInfo.
        :type: DocusignTemplateMapping
        """
        
        self._template = template

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

