# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class SocialAccount(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        SocialAccount - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'enabled': 'bool',
            'authorized': 'bool',
            'social_hub': 'str',
            'access_token': 'str',
            'access_token_secret': 'str',
            'twitter_id': 'str',
            'streaming_enabled': 'bool',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'enabled': 'enabled',
            'authorized': 'authorized',
            'social_hub': 'socialHub',
            'access_token': 'access_token',
            'access_token_secret': 'access_token_secret',
            'twitter_id': 'twitterId',
            'streaming_enabled': 'streamingEnabled',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._date_created = None
        self._date_modified = None
        self._enabled = False
        self._authorized = False
        self._social_hub = None
        self._access_token = None
        self._access_token_secret = None
        self._twitter_id = None
        self._streaming_enabled = False
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this SocialAccount.
        The globally unique identifier for the object.

        :return: The id of this SocialAccount.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this SocialAccount.
        The globally unique identifier for the object.

        :param id: The id of this SocialAccount.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this SocialAccount.


        :return: The name of this SocialAccount.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this SocialAccount.


        :param name: The name of this SocialAccount.
        :type: str
        """
        
        self._name = name

    @property
    def date_created(self):
        """
        Gets the date_created of this SocialAccount.
        Creation date for the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The date_created of this SocialAccount.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created):
        """
        Sets the date_created of this SocialAccount.
        Creation date for the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param date_created: The date_created of this SocialAccount.
        :type: datetime
        """
        
        self._date_created = date_created

    @property
    def date_modified(self):
        """
        Gets the date_modified of this SocialAccount.
        Date the entity was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The date_modified of this SocialAccount.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified):
        """
        Sets the date_modified of this SocialAccount.
        Date the entity was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param date_modified: The date_modified of this SocialAccount.
        :type: datetime
        """
        
        self._date_modified = date_modified

    @property
    def enabled(self):
        """
        Gets the enabled of this SocialAccount.
        Indicates if this Social Account is available for selection by other entities

        :return: The enabled of this SocialAccount.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this SocialAccount.
        Indicates if this Social Account is available for selection by other entities

        :param enabled: The enabled of this SocialAccount.
        :type: bool
        """
        
        self._enabled = enabled

    @property
    def authorized(self):
        """
        Gets the authorized of this SocialAccount.
        True when successfully completing the third-party authorization process

        :return: The authorized of this SocialAccount.
        :rtype: bool
        """
        return self._authorized

    @authorized.setter
    def authorized(self, authorized):
        """
        Sets the authorized of this SocialAccount.
        True when successfully completing the third-party authorization process

        :param authorized: The authorized of this SocialAccount.
        :type: bool
        """
        
        self._authorized = authorized

    @property
    def social_hub(self):
        """
        Gets the social_hub of this SocialAccount.
        Which third party Social Media Hub this account will be communicating through

        :return: The social_hub of this SocialAccount.
        :rtype: str
        """
        return self._social_hub

    @social_hub.setter
    def social_hub(self, social_hub):
        """
        Sets the social_hub of this SocialAccount.
        Which third party Social Media Hub this account will be communicating through

        :param social_hub: The social_hub of this SocialAccount.
        :type: str
        """
        
        self._social_hub = social_hub

    @property
    def access_token(self):
        """
        Gets the access_token of this SocialAccount.
        Credential provided through the Social Hub's authorization process

        :return: The access_token of this SocialAccount.
        :rtype: str
        """
        return self._access_token

    @access_token.setter
    def access_token(self, access_token):
        """
        Sets the access_token of this SocialAccount.
        Credential provided through the Social Hub's authorization process

        :param access_token: The access_token of this SocialAccount.
        :type: str
        """
        
        self._access_token = access_token

    @property
    def access_token_secret(self):
        """
        Gets the access_token_secret of this SocialAccount.
        Credential provided through the Social Hub's authorization process

        :return: The access_token_secret of this SocialAccount.
        :rtype: str
        """
        return self._access_token_secret

    @access_token_secret.setter
    def access_token_secret(self, access_token_secret):
        """
        Sets the access_token_secret of this SocialAccount.
        Credential provided through the Social Hub's authorization process

        :param access_token_secret: The access_token_secret of this SocialAccount.
        :type: str
        """
        
        self._access_token_secret = access_token_secret

    @property
    def twitter_id(self):
        """
        Gets the twitter_id of this SocialAccount.
        The account ID as provided by Twitter during the authorization process

        :return: The twitter_id of this SocialAccount.
        :rtype: str
        """
        return self._twitter_id

    @twitter_id.setter
    def twitter_id(self, twitter_id):
        """
        Sets the twitter_id of this SocialAccount.
        The account ID as provided by Twitter during the authorization process

        :param twitter_id: The twitter_id of this SocialAccount.
        :type: str
        """
        
        self._twitter_id = twitter_id

    @property
    def streaming_enabled(self):
        """
        Gets the streaming_enabled of this SocialAccount.
        Indicates if a stream should be opened on behalf of the indicated Social Hub account

        :return: The streaming_enabled of this SocialAccount.
        :rtype: bool
        """
        return self._streaming_enabled

    @streaming_enabled.setter
    def streaming_enabled(self, streaming_enabled):
        """
        Sets the streaming_enabled of this SocialAccount.
        Indicates if a stream should be opened on behalf of the indicated Social Hub account

        :param streaming_enabled: The streaming_enabled of this SocialAccount.
        :type: bool
        """
        
        self._streaming_enabled = streaming_enabled

    @property
    def self_uri(self):
        """
        Gets the self_uri of this SocialAccount.
        The URI for this object

        :return: The self_uri of this SocialAccount.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this SocialAccount.
        The URI for this object

        :param self_uri: The self_uri of this SocialAccount.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

