# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class SocializeEntityFilter(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        SocializeEntityFilter - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'field_name': 'str',
            'operator': 'str',
            'field_value': 'str'
        }

        self.attribute_map = {
            'field_name': 'fieldName',
            'operator': 'operator',
            'field_value': 'fieldValue'
        }

        self._field_name = None
        self._operator = None
        self._field_value = None

    @property
    def field_name(self):
        """
        Gets the field_name of this SocializeEntityFilter.
        The fieldName the filter will be applied to.

        :return: The field_name of this SocializeEntityFilter.
        :rtype: str
        """
        return self._field_name

    @field_name.setter
    def field_name(self, field_name):
        """
        Sets the field_name of this SocializeEntityFilter.
        The fieldName the filter will be applied to.

        :param field_name: The field_name of this SocializeEntityFilter.
        :type: str
        """
        
        self._field_name = field_name

    @property
    def operator(self):
        """
        Gets the operator of this SocializeEntityFilter.
        The operator to apply when filtering.

        :return: The operator of this SocializeEntityFilter.
        :rtype: str
        """
        return self._operator

    @operator.setter
    def operator(self, operator):
        """
        Sets the operator of this SocializeEntityFilter.
        The operator to apply when filtering.

        :param operator: The operator of this SocializeEntityFilter.
        :type: str
        """
        allowed_values = ["EQ", "NEG_EQ", "CONTAINS", "NEG_CONTAINS", "STARTS_WITH", "NEG_STARTS_WITH", "ENDS_WITH", "NEG_ENDS_WITH", "BT", "GT", "LT", "GE", "LE", "IN"]
        if operator not in allowed_values:
            raise ValueError(
                "Invalid value for `operator`, must be one of {0}"
                .format(allowed_values)
            )

        self._operator = operator

    @property
    def field_value(self):
        """
        Gets the field_value of this SocializeEntityFilter.
        The value to filter on.

        :return: The field_value of this SocializeEntityFilter.
        :rtype: str
        """
        return self._field_value

    @field_value.setter
    def field_value(self, field_value):
        """
        Sets the field_value of this SocializeEntityFilter.
        The value to filter on.

        :param field_value: The field_value of this SocializeEntityFilter.
        :type: str
        """
        
        self._field_value = field_value

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

