# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class SocializeFilterRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        SocializeFilterRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'filters': 'list[SocializeEntityFilter]',
            'page_size': 'int',
            'page_number': 'int',
            'sort_by': 'str',
            'sort_order': 'str'
        }

        self.attribute_map = {
            'filters': 'filters',
            'page_size': 'pageSize',
            'page_number': 'pageNumber',
            'sort_by': 'sortBy',
            'sort_order': 'sortOrder'
        }

        self._filters = None
        self._page_size = None
        self._page_number = None
        self._sort_by = None
        self._sort_order = None

    @property
    def filters(self):
        """
        Gets the filters of this SocializeFilterRequest.
        The list of filters used to narrow the return.

        :return: The filters of this SocializeFilterRequest.
        :rtype: list[SocializeEntityFilter]
        """
        return self._filters

    @filters.setter
    def filters(self, filters):
        """
        Sets the filters of this SocializeFilterRequest.
        The list of filters used to narrow the return.

        :param filters: The filters of this SocializeFilterRequest.
        :type: list[SocializeEntityFilter]
        """
        
        self._filters = filters

    @property
    def page_size(self):
        """
        Gets the page_size of this SocializeFilterRequest.


        :return: The page_size of this SocializeFilterRequest.
        :rtype: int
        """
        return self._page_size

    @page_size.setter
    def page_size(self, page_size):
        """
        Sets the page_size of this SocializeFilterRequest.


        :param page_size: The page_size of this SocializeFilterRequest.
        :type: int
        """
        
        self._page_size = page_size

    @property
    def page_number(self):
        """
        Gets the page_number of this SocializeFilterRequest.


        :return: The page_number of this SocializeFilterRequest.
        :rtype: int
        """
        return self._page_number

    @page_number.setter
    def page_number(self, page_number):
        """
        Sets the page_number of this SocializeFilterRequest.


        :param page_number: The page_number of this SocializeFilterRequest.
        :type: int
        """
        
        self._page_number = page_number

    @property
    def sort_by(self):
        """
        Gets the sort_by of this SocializeFilterRequest.


        :return: The sort_by of this SocializeFilterRequest.
        :rtype: str
        """
        return self._sort_by

    @sort_by.setter
    def sort_by(self, sort_by):
        """
        Sets the sort_by of this SocializeFilterRequest.


        :param sort_by: The sort_by of this SocializeFilterRequest.
        :type: str
        """
        
        self._sort_by = sort_by

    @property
    def sort_order(self):
        """
        Gets the sort_order of this SocializeFilterRequest.


        :return: The sort_order of this SocializeFilterRequest.
        :rtype: str
        """
        return self._sort_order

    @sort_order.setter
    def sort_order(self, sort_order):
        """
        Sets the sort_order of this SocializeFilterRequest.


        :param sort_order: The sort_order of this SocializeFilterRequest.
        :type: str
        """
        allowed_values = ["ascending", "descending"]
        if sort_order not in allowed_values:
            raise ValueError(
                "Invalid value for `sort_order`, must be one of {0}"
                .format(allowed_values)
            )

        self._sort_order = sort_order

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

