# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class SpreadsheetTransform(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        SpreadsheetTransform - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'rest_endpoint': 'TransformEndpoint',
            'filename_transforms': 'list[BasicTransform]',
            'tags': 'list[TagModel]',
            'sheet_name_transforms': 'list[IndexedTransform]',
            'sheets': 'list[SheetTransform]',
            'client_transform_model': 'ClientSpreadsheetTransform',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'rest_endpoint': 'restEndpoint',
            'filename_transforms': 'filenameTransforms',
            'tags': 'tags',
            'sheet_name_transforms': 'sheetNameTransforms',
            'sheets': 'sheets',
            'client_transform_model': 'clientTransformModel',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._rest_endpoint = None
        self._filename_transforms = None
        self._tags = None
        self._sheet_name_transforms = None
        self._sheets = None
        self._client_transform_model = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this SpreadsheetTransform.
        The globally unique identifier for the object.

        :return: The id of this SpreadsheetTransform.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this SpreadsheetTransform.
        The globally unique identifier for the object.

        :param id: The id of this SpreadsheetTransform.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this SpreadsheetTransform.


        :return: The name of this SpreadsheetTransform.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this SpreadsheetTransform.


        :param name: The name of this SpreadsheetTransform.
        :type: str
        """
        
        self._name = name

    @property
    def rest_endpoint(self):
        """
        Gets the rest_endpoint of this SpreadsheetTransform.


        :return: The rest_endpoint of this SpreadsheetTransform.
        :rtype: TransformEndpoint
        """
        return self._rest_endpoint

    @rest_endpoint.setter
    def rest_endpoint(self, rest_endpoint):
        """
        Sets the rest_endpoint of this SpreadsheetTransform.


        :param rest_endpoint: The rest_endpoint of this SpreadsheetTransform.
        :type: TransformEndpoint
        """
        
        self._rest_endpoint = rest_endpoint

    @property
    def filename_transforms(self):
        """
        Gets the filename_transforms of this SpreadsheetTransform.


        :return: The filename_transforms of this SpreadsheetTransform.
        :rtype: list[BasicTransform]
        """
        return self._filename_transforms

    @filename_transforms.setter
    def filename_transforms(self, filename_transforms):
        """
        Sets the filename_transforms of this SpreadsheetTransform.


        :param filename_transforms: The filename_transforms of this SpreadsheetTransform.
        :type: list[BasicTransform]
        """
        
        self._filename_transforms = filename_transforms

    @property
    def tags(self):
        """
        Gets the tags of this SpreadsheetTransform.


        :return: The tags of this SpreadsheetTransform.
        :rtype: list[TagModel]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this SpreadsheetTransform.


        :param tags: The tags of this SpreadsheetTransform.
        :type: list[TagModel]
        """
        
        self._tags = tags

    @property
    def sheet_name_transforms(self):
        """
        Gets the sheet_name_transforms of this SpreadsheetTransform.


        :return: The sheet_name_transforms of this SpreadsheetTransform.
        :rtype: list[IndexedTransform]
        """
        return self._sheet_name_transforms

    @sheet_name_transforms.setter
    def sheet_name_transforms(self, sheet_name_transforms):
        """
        Sets the sheet_name_transforms of this SpreadsheetTransform.


        :param sheet_name_transforms: The sheet_name_transforms of this SpreadsheetTransform.
        :type: list[IndexedTransform]
        """
        
        self._sheet_name_transforms = sheet_name_transforms

    @property
    def sheets(self):
        """
        Gets the sheets of this SpreadsheetTransform.


        :return: The sheets of this SpreadsheetTransform.
        :rtype: list[SheetTransform]
        """
        return self._sheets

    @sheets.setter
    def sheets(self, sheets):
        """
        Sets the sheets of this SpreadsheetTransform.


        :param sheets: The sheets of this SpreadsheetTransform.
        :type: list[SheetTransform]
        """
        
        self._sheets = sheets

    @property
    def client_transform_model(self):
        """
        Gets the client_transform_model of this SpreadsheetTransform.


        :return: The client_transform_model of this SpreadsheetTransform.
        :rtype: ClientSpreadsheetTransform
        """
        return self._client_transform_model

    @client_transform_model.setter
    def client_transform_model(self, client_transform_model):
        """
        Sets the client_transform_model of this SpreadsheetTransform.


        :param client_transform_model: The client_transform_model of this SpreadsheetTransform.
        :type: ClientSpreadsheetTransform
        """
        
        self._client_transform_model = client_transform_model

    @property
    def self_uri(self):
        """
        Gets the self_uri of this SpreadsheetTransform.
        The URI for this object

        :return: The self_uri of this SpreadsheetTransform.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this SpreadsheetTransform.
        The URI for this object

        :param self_uri: The self_uri of this SpreadsheetTransform.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

