# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class SubDataItem(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        SubDataItem - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'type': 'str',
            'value': 'str',
            'prompt': 'str',
            'display_value': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'type': 'type',
            'value': 'value',
            'prompt': 'prompt',
            'display_value': 'displayValue'
        }

        self._id = None
        self._type = None
        self._value = None
        self._prompt = None
        self._display_value = None

    @property
    def id(self):
        """
        Gets the id of this SubDataItem.
        The id of this element

        :return: The id of this SubDataItem.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this SubDataItem.
        The id of this element

        :param id: The id of this SubDataItem.
        :type: str
        """
        
        self._id = id

    @property
    def type(self):
        """
        Gets the type of this SubDataItem.
        The 'type' of the element, this may be a system value, EG 'STRING' or a user defined type

        :return: The type of this SubDataItem.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this SubDataItem.
        The 'type' of the element, this may be a system value, EG 'STRING' or a user defined type

        :param type: The type of this SubDataItem.
        :type: str
        """
        
        self._type = type

    @property
    def value(self):
        """
        Gets the value of this SubDataItem.
        The value of the element itself - This may be a simple value or more complex serialized data.

        :return: The value of this SubDataItem.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this SubDataItem.
        The value of the element itself - This may be a simple value or more complex serialized data.

        :param value: The value of this SubDataItem.
        :type: str
        """
        
        self._value = value

    @property
    def prompt(self):
        """
        Gets the prompt of this SubDataItem.
        The prompt displayed to the user that this data item was set from.

        :return: The prompt of this SubDataItem.
        :rtype: str
        """
        return self._prompt

    @prompt.setter
    def prompt(self, prompt):
        """
        Sets the prompt of this SubDataItem.
        The prompt displayed to the user that this data item was set from.

        :param prompt: The prompt of this SubDataItem.
        :type: str
        """
        
        self._prompt = prompt

    @property
    def display_value(self):
        """
        Gets the display_value of this SubDataItem.
        The display value that was offered to the user (as opposed to the actual value used internally

        :return: The display_value of this SubDataItem.
        :rtype: str
        """
        return self._display_value

    @display_value.setter
    def display_value(self, display_value):
        """
        Sets the display_value of this SubDataItem.
        The display value that was offered to the user (as opposed to the actual value used internally

        :param display_value: The display_value of this SubDataItem.
        :type: str
        """
        
        self._display_value = display_value

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

