# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class TableTransform(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        TableTransform - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'header_row': 'int',
            'first_data': 'int',
            'header_replaces': 'list[IndexedTransform]',
            'columns': 'list[IndexedTransform]',
            'unpivots': 'list[UnpivotColumns]',
            'collapses': 'list[ColumnCollapse]'
        }

        self.attribute_map = {
            'header_row': 'headerRow',
            'first_data': 'firstData',
            'header_replaces': 'headerReplaces',
            'columns': 'columns',
            'unpivots': 'unpivots',
            'collapses': 'collapses'
        }

        self._header_row = None
        self._first_data = None
        self._header_replaces = None
        self._columns = None
        self._unpivots = None
        self._collapses = None

    @property
    def header_row(self):
        """
        Gets the header_row of this TableTransform.


        :return: The header_row of this TableTransform.
        :rtype: int
        """
        return self._header_row

    @header_row.setter
    def header_row(self, header_row):
        """
        Sets the header_row of this TableTransform.


        :param header_row: The header_row of this TableTransform.
        :type: int
        """
        
        self._header_row = header_row

    @property
    def first_data(self):
        """
        Gets the first_data of this TableTransform.


        :return: The first_data of this TableTransform.
        :rtype: int
        """
        return self._first_data

    @first_data.setter
    def first_data(self, first_data):
        """
        Sets the first_data of this TableTransform.


        :param first_data: The first_data of this TableTransform.
        :type: int
        """
        
        self._first_data = first_data

    @property
    def header_replaces(self):
        """
        Gets the header_replaces of this TableTransform.


        :return: The header_replaces of this TableTransform.
        :rtype: list[IndexedTransform]
        """
        return self._header_replaces

    @header_replaces.setter
    def header_replaces(self, header_replaces):
        """
        Sets the header_replaces of this TableTransform.


        :param header_replaces: The header_replaces of this TableTransform.
        :type: list[IndexedTransform]
        """
        
        self._header_replaces = header_replaces

    @property
    def columns(self):
        """
        Gets the columns of this TableTransform.


        :return: The columns of this TableTransform.
        :rtype: list[IndexedTransform]
        """
        return self._columns

    @columns.setter
    def columns(self, columns):
        """
        Sets the columns of this TableTransform.


        :param columns: The columns of this TableTransform.
        :type: list[IndexedTransform]
        """
        
        self._columns = columns

    @property
    def unpivots(self):
        """
        Gets the unpivots of this TableTransform.


        :return: The unpivots of this TableTransform.
        :rtype: list[UnpivotColumns]
        """
        return self._unpivots

    @unpivots.setter
    def unpivots(self, unpivots):
        """
        Sets the unpivots of this TableTransform.


        :param unpivots: The unpivots of this TableTransform.
        :type: list[UnpivotColumns]
        """
        
        self._unpivots = unpivots

    @property
    def collapses(self):
        """
        Gets the collapses of this TableTransform.


        :return: The collapses of this TableTransform.
        :rtype: list[ColumnCollapse]
        """
        return self._collapses

    @collapses.setter
    def collapses(self, collapses):
        """
        Sets the collapses of this TableTransform.


        :param collapses: The collapses of this TableTransform.
        :type: list[ColumnCollapse]
        """
        
        self._collapses = collapses

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

