# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class TextTableTransform(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        TextTableTransform - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'rest_endpoint': 'TransformEndpoint',
            'filename_transforms': 'list[BasicTransform]',
            'tags': 'list[TagModel]',
            'comment_symbol': 'str',
            'delimiter': 'str',
            'table': 'TableTransform',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'rest_endpoint': 'restEndpoint',
            'filename_transforms': 'filenameTransforms',
            'tags': 'tags',
            'comment_symbol': 'commentSymbol',
            'delimiter': 'delimiter',
            'table': 'table',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._rest_endpoint = None
        self._filename_transforms = None
        self._tags = None
        self._comment_symbol = None
        self._delimiter = None
        self._table = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this TextTableTransform.
        The globally unique identifier for the object.

        :return: The id of this TextTableTransform.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this TextTableTransform.
        The globally unique identifier for the object.

        :param id: The id of this TextTableTransform.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this TextTableTransform.


        :return: The name of this TextTableTransform.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this TextTableTransform.


        :param name: The name of this TextTableTransform.
        :type: str
        """
        
        self._name = name

    @property
    def rest_endpoint(self):
        """
        Gets the rest_endpoint of this TextTableTransform.


        :return: The rest_endpoint of this TextTableTransform.
        :rtype: TransformEndpoint
        """
        return self._rest_endpoint

    @rest_endpoint.setter
    def rest_endpoint(self, rest_endpoint):
        """
        Sets the rest_endpoint of this TextTableTransform.


        :param rest_endpoint: The rest_endpoint of this TextTableTransform.
        :type: TransformEndpoint
        """
        
        self._rest_endpoint = rest_endpoint

    @property
    def filename_transforms(self):
        """
        Gets the filename_transforms of this TextTableTransform.


        :return: The filename_transforms of this TextTableTransform.
        :rtype: list[BasicTransform]
        """
        return self._filename_transforms

    @filename_transforms.setter
    def filename_transforms(self, filename_transforms):
        """
        Sets the filename_transforms of this TextTableTransform.


        :param filename_transforms: The filename_transforms of this TextTableTransform.
        :type: list[BasicTransform]
        """
        
        self._filename_transforms = filename_transforms

    @property
    def tags(self):
        """
        Gets the tags of this TextTableTransform.


        :return: The tags of this TextTableTransform.
        :rtype: list[TagModel]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this TextTableTransform.


        :param tags: The tags of this TextTableTransform.
        :type: list[TagModel]
        """
        
        self._tags = tags

    @property
    def comment_symbol(self):
        """
        Gets the comment_symbol of this TextTableTransform.


        :return: The comment_symbol of this TextTableTransform.
        :rtype: str
        """
        return self._comment_symbol

    @comment_symbol.setter
    def comment_symbol(self, comment_symbol):
        """
        Sets the comment_symbol of this TextTableTransform.


        :param comment_symbol: The comment_symbol of this TextTableTransform.
        :type: str
        """
        
        self._comment_symbol = comment_symbol

    @property
    def delimiter(self):
        """
        Gets the delimiter of this TextTableTransform.


        :return: The delimiter of this TextTableTransform.
        :rtype: str
        """
        return self._delimiter

    @delimiter.setter
    def delimiter(self, delimiter):
        """
        Sets the delimiter of this TextTableTransform.


        :param delimiter: The delimiter of this TextTableTransform.
        :type: str
        """
        
        self._delimiter = delimiter

    @property
    def table(self):
        """
        Gets the table of this TextTableTransform.


        :return: The table of this TextTableTransform.
        :rtype: TableTransform
        """
        return self._table

    @table.setter
    def table(self, table):
        """
        Sets the table of this TextTableTransform.


        :param table: The table of this TextTableTransform.
        :type: TableTransform
        """
        
        self._table = table

    @property
    def self_uri(self):
        """
        Gets the self_uri of this TextTableTransform.
        The URI for this object

        :return: The self_uri of this TextTableTransform.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this TextTableTransform.
        The URI for this object

        :param self_uri: The self_uri of this TextTableTransform.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

