# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class ThirdPartySubscription(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ThirdPartySubscription - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'notes': 'str',
            'contract_effective_date': 'datetime',
            'version': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'notes': 'notes',
            'contract_effective_date': 'contractEffectiveDate',
            'version': 'version',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._notes = None
        self._contract_effective_date = None
        self._version = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this ThirdPartySubscription.
        The globally unique identifier for the object.

        :return: The id of this ThirdPartySubscription.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ThirdPartySubscription.
        The globally unique identifier for the object.

        :param id: The id of this ThirdPartySubscription.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this ThirdPartySubscription.


        :return: The name of this ThirdPartySubscription.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ThirdPartySubscription.


        :param name: The name of this ThirdPartySubscription.
        :type: str
        """
        
        self._name = name

    @property
    def notes(self):
        """
        Gets the notes of this ThirdPartySubscription.


        :return: The notes of this ThirdPartySubscription.
        :rtype: str
        """
        return self._notes

    @notes.setter
    def notes(self, notes):
        """
        Sets the notes of this ThirdPartySubscription.


        :param notes: The notes of this ThirdPartySubscription.
        :type: str
        """
        
        self._notes = notes

    @property
    def contract_effective_date(self):
        """
        Gets the contract_effective_date of this ThirdPartySubscription.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The contract_effective_date of this ThirdPartySubscription.
        :rtype: datetime
        """
        return self._contract_effective_date

    @contract_effective_date.setter
    def contract_effective_date(self, contract_effective_date):
        """
        Sets the contract_effective_date of this ThirdPartySubscription.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param contract_effective_date: The contract_effective_date of this ThirdPartySubscription.
        :type: datetime
        """
        
        self._contract_effective_date = contract_effective_date

    @property
    def version(self):
        """
        Gets the version of this ThirdPartySubscription.


        :return: The version of this ThirdPartySubscription.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this ThirdPartySubscription.


        :param version: The version of this ThirdPartySubscription.
        :type: str
        """
        
        self._version = version

    @property
    def self_uri(self):
        """
        Gets the self_uri of this ThirdPartySubscription.
        The URI for this object

        :return: The self_uri of this ThirdPartySubscription.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this ThirdPartySubscription.
        The URI for this object

        :param self_uri: The self_uri of this ThirdPartySubscription.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

