# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class Trace(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Trace - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'topic': 'str',
            'timestamp': 'datetime',
            'level': 'str',
            'message': 'str',
            'details': 'object',
            'timestamp_string': 'str',
            'details_string': 'str'
        }

        self.attribute_map = {
            'topic': 'topic',
            'timestamp': 'timestamp',
            'level': 'level',
            'message': 'message',
            'details': 'details',
            'timestamp_string': 'timestampString',
            'details_string': 'detailsString'
        }

        self._topic = None
        self._timestamp = None
        self._level = None
        self._message = None
        self._details = None
        self._timestamp_string = None
        self._details_string = None

    @property
    def topic(self):
        """
        Gets the topic of this Trace.


        :return: The topic of this Trace.
        :rtype: str
        """
        return self._topic

    @topic.setter
    def topic(self, topic):
        """
        Sets the topic of this Trace.


        :param topic: The topic of this Trace.
        :type: str
        """
        
        self._topic = topic

    @property
    def timestamp(self):
        """
        Gets the timestamp of this Trace.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The timestamp of this Trace.
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """
        Sets the timestamp of this Trace.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param timestamp: The timestamp of this Trace.
        :type: datetime
        """
        
        self._timestamp = timestamp

    @property
    def level(self):
        """
        Gets the level of this Trace.


        :return: The level of this Trace.
        :rtype: str
        """
        return self._level

    @level.setter
    def level(self, level):
        """
        Sets the level of this Trace.


        :param level: The level of this Trace.
        :type: str
        """
        allowed_values = ["ERROR", "WARN", "INFO", "DEBUG"]
        if level not in allowed_values:
            raise ValueError(
                "Invalid value for `level`, must be one of {0}"
                .format(allowed_values)
            )

        self._level = level

    @property
    def message(self):
        """
        Gets the message of this Trace.


        :return: The message of this Trace.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this Trace.


        :param message: The message of this Trace.
        :type: str
        """
        
        self._message = message

    @property
    def details(self):
        """
        Gets the details of this Trace.


        :return: The details of this Trace.
        :rtype: object
        """
        return self._details

    @details.setter
    def details(self, details):
        """
        Sets the details of this Trace.


        :param details: The details of this Trace.
        :type: object
        """
        
        self._details = details

    @property
    def timestamp_string(self):
        """
        Gets the timestamp_string of this Trace.


        :return: The timestamp_string of this Trace.
        :rtype: str
        """
        return self._timestamp_string

    @timestamp_string.setter
    def timestamp_string(self, timestamp_string):
        """
        Sets the timestamp_string of this Trace.


        :param timestamp_string: The timestamp_string of this Trace.
        :type: str
        """
        
        self._timestamp_string = timestamp_string

    @property
    def details_string(self):
        """
        Gets the details_string of this Trace.


        :return: The details_string of this Trace.
        :rtype: str
        """
        return self._details_string

    @details_string.setter
    def details_string(self, details_string):
        """
        Sets the details_string of this Trace.


        :param details_string: The details_string of this Trace.
        :type: str
        """
        
        self._details_string = details_string

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

