# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class TransformEndpoint(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        TransformEndpoint - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'swagger_url': 'str',
            'route': 'str',
            'entity': 'str',
            'api_function': 'str',
            'ready': 'bool',
            'active': 'bool',
            'batch_size': 'int',
            'parallelism': 'int',
            'update_progress_every': 'int',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'swagger_url': 'swaggerUrl',
            'route': 'route',
            'entity': 'entity',
            'api_function': 'apiFunction',
            'ready': 'ready',
            'active': 'active',
            'batch_size': 'batchSize',
            'parallelism': 'parallelism',
            'update_progress_every': 'updateProgressEvery',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._swagger_url = None
        self._route = None
        self._entity = None
        self._api_function = None
        self._ready = False
        self._active = False
        self._batch_size = None
        self._parallelism = None
        self._update_progress_every = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this TransformEndpoint.
        The globally unique identifier for the object.

        :return: The id of this TransformEndpoint.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this TransformEndpoint.
        The globally unique identifier for the object.

        :param id: The id of this TransformEndpoint.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this TransformEndpoint.


        :return: The name of this TransformEndpoint.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this TransformEndpoint.


        :param name: The name of this TransformEndpoint.
        :type: str
        """
        
        self._name = name

    @property
    def swagger_url(self):
        """
        Gets the swagger_url of this TransformEndpoint.
        The Url to the swagger documentation of the endpoint where parsed entities will be posted

        :return: The swagger_url of this TransformEndpoint.
        :rtype: str
        """
        return self._swagger_url

    @swagger_url.setter
    def swagger_url(self, swagger_url):
        """
        Sets the swagger_url of this TransformEndpoint.
        The Url to the swagger documentation of the endpoint where parsed entities will be posted

        :param swagger_url: The swagger_url of this TransformEndpoint.
        :type: str
        """
        
        self._swagger_url = swagger_url

    @property
    def route(self):
        """
        Gets the route of this TransformEndpoint.
        The swagger route to use

        :return: The route of this TransformEndpoint.
        :rtype: str
        """
        return self._route

    @route.setter
    def route(self, route):
        """
        Sets the route of this TransformEndpoint.
        The swagger route to use

        :param route: The route of this TransformEndpoint.
        :type: str
        """
        
        self._route = route

    @property
    def entity(self):
        """
        Gets the entity of this TransformEndpoint.
        The entity type being posted

        :return: The entity of this TransformEndpoint.
        :rtype: str
        """
        return self._entity

    @entity.setter
    def entity(self, entity):
        """
        Sets the entity of this TransformEndpoint.
        The entity type being posted

        :param entity: The entity of this TransformEndpoint.
        :type: str
        """
        
        self._entity = entity

    @property
    def api_function(self):
        """
        Gets the api_function of this TransformEndpoint.
        The swagger function being called

        :return: The api_function of this TransformEndpoint.
        :rtype: str
        """
        return self._api_function

    @api_function.setter
    def api_function(self, api_function):
        """
        Sets the api_function of this TransformEndpoint.
        The swagger function being called

        :param api_function: The api_function of this TransformEndpoint.
        :type: str
        """
        
        self._api_function = api_function

    @property
    def ready(self):
        """
        Gets the ready of this TransformEndpoint.
        Whether this TransformEndpoint has been configured to work (security groups, permissions, etc)

        :return: The ready of this TransformEndpoint.
        :rtype: bool
        """
        return self._ready

    @ready.setter
    def ready(self, ready):
        """
        Sets the ready of this TransformEndpoint.
        Whether this TransformEndpoint has been configured to work (security groups, permissions, etc)

        :param ready: The ready of this TransformEndpoint.
        :type: bool
        """
        
        self._ready = ready

    @property
    def active(self):
        """
        Gets the active of this TransformEndpoint.
        Whether this TransformEndpoint is currently active and accepting transformation operations

        :return: The active of this TransformEndpoint.
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """
        Sets the active of this TransformEndpoint.
        Whether this TransformEndpoint is currently active and accepting transformation operations

        :param active: The active of this TransformEndpoint.
        :type: bool
        """
        
        self._active = active

    @property
    def batch_size(self):
        """
        Gets the batch_size of this TransformEndpoint.
        The number of entities to send in an array for batch POSTs, or 0 for unbatched POSTs

        :return: The batch_size of this TransformEndpoint.
        :rtype: int
        """
        return self._batch_size

    @batch_size.setter
    def batch_size(self, batch_size):
        """
        Sets the batch_size of this TransformEndpoint.
        The number of entities to send in an array for batch POSTs, or 0 for unbatched POSTs

        :param batch_size: The batch_size of this TransformEndpoint.
        :type: int
        """
        
        self._batch_size = batch_size

    @property
    def parallelism(self):
        """
        Gets the parallelism of this TransformEndpoint.
        The number of parallel POSTs to allow at once

        :return: The parallelism of this TransformEndpoint.
        :rtype: int
        """
        return self._parallelism

    @parallelism.setter
    def parallelism(self, parallelism):
        """
        Sets the parallelism of this TransformEndpoint.
        The number of parallel POSTs to allow at once

        :param parallelism: The parallelism of this TransformEndpoint.
        :type: int
        """
        
        self._parallelism = parallelism

    @property
    def update_progress_every(self):
        """
        Gets the update_progress_every of this TransformEndpoint.
        The swagger route to use

        :return: The update_progress_every of this TransformEndpoint.
        :rtype: int
        """
        return self._update_progress_every

    @update_progress_every.setter
    def update_progress_every(self, update_progress_every):
        """
        Sets the update_progress_every of this TransformEndpoint.
        The swagger route to use

        :param update_progress_every: The update_progress_every of this TransformEndpoint.
        :type: int
        """
        
        self._update_progress_every = update_progress_every

    @property
    def self_uri(self):
        """
        Gets the self_uri of this TransformEndpoint.
        The URI for this object

        :return: The self_uri of this TransformEndpoint.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this TransformEndpoint.
        The URI for this object

        :param self_uri: The self_uri of this TransformEndpoint.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

