# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class TwitterExpression(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        TwitterExpression - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'is_dispositioned': 'bool',
            'is_noise': 'bool',
            'gistener': 'Gistener',
            'tweet_id': 'str',
            'text': 'str',
            'tweet_created': 'datetime',
            'is_reply': 'bool',
            'is_retweet': 'bool',
            'retweet_parent_id': 'str',
            'retweet_count': 'int',
            'is_quoted_tweet': 'bool',
            'quoted_parent_id': 'str',
            'user_id': 'str',
            'user_name': 'str',
            'user_screen_name': 'str',
            'user_tweet_count': 'int',
            'user_followers_count': 'int',
            'group_tags': 'list[GroupTag]',
            'routed': 'bool',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'is_dispositioned': 'isDispositioned',
            'is_noise': 'isNoise',
            'gistener': 'gistener',
            'tweet_id': 'tweetId',
            'text': 'text',
            'tweet_created': 'tweetCreated',
            'is_reply': 'isReply',
            'is_retweet': 'isRetweet',
            'retweet_parent_id': 'retweetParentId',
            'retweet_count': 'retweetCount',
            'is_quoted_tweet': 'isQuotedTweet',
            'quoted_parent_id': 'quotedParentId',
            'user_id': 'userId',
            'user_name': 'userName',
            'user_screen_name': 'userScreenName',
            'user_tweet_count': 'userTweetCount',
            'user_followers_count': 'userFollowersCount',
            'group_tags': 'groupTags',
            'routed': 'routed',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._date_created = None
        self._date_modified = None
        self._is_dispositioned = False
        self._is_noise = False
        self._gistener = None
        self._tweet_id = None
        self._text = None
        self._tweet_created = None
        self._is_reply = False
        self._is_retweet = False
        self._retweet_parent_id = None
        self._retweet_count = None
        self._is_quoted_tweet = False
        self._quoted_parent_id = None
        self._user_id = None
        self._user_name = None
        self._user_screen_name = None
        self._user_tweet_count = None
        self._user_followers_count = None
        self._group_tags = None
        self._routed = False
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this TwitterExpression.
        The globally unique identifier for the object.

        :return: The id of this TwitterExpression.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this TwitterExpression.
        The globally unique identifier for the object.

        :param id: The id of this TwitterExpression.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this TwitterExpression.


        :return: The name of this TwitterExpression.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this TwitterExpression.


        :param name: The name of this TwitterExpression.
        :type: str
        """
        
        self._name = name

    @property
    def date_created(self):
        """
        Gets the date_created of this TwitterExpression.
        Creation date for the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The date_created of this TwitterExpression.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created):
        """
        Sets the date_created of this TwitterExpression.
        Creation date for the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param date_created: The date_created of this TwitterExpression.
        :type: datetime
        """
        
        self._date_created = date_created

    @property
    def date_modified(self):
        """
        Gets the date_modified of this TwitterExpression.
        Date the entity was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The date_modified of this TwitterExpression.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified):
        """
        Sets the date_modified of this TwitterExpression.
        Date the entity was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param date_modified: The date_modified of this TwitterExpression.
        :type: datetime
        """
        
        self._date_modified = date_modified

    @property
    def is_dispositioned(self):
        """
        Gets the is_dispositioned of this TwitterExpression.
        True once the expression has been dispositioned by an agent through the ACD process

        :return: The is_dispositioned of this TwitterExpression.
        :rtype: bool
        """
        return self._is_dispositioned

    @is_dispositioned.setter
    def is_dispositioned(self, is_dispositioned):
        """
        Sets the is_dispositioned of this TwitterExpression.
        True once the expression has been dispositioned by an agent through the ACD process

        :param is_dispositioned: The is_dispositioned of this TwitterExpression.
        :type: bool
        """
        
        self._is_dispositioned = is_dispositioned

    @property
    def is_noise(self):
        """
        Gets the is_noise of this TwitterExpression.
        Indicates if a user/agent found this expression to be undesirable

        :return: The is_noise of this TwitterExpression.
        :rtype: bool
        """
        return self._is_noise

    @is_noise.setter
    def is_noise(self, is_noise):
        """
        Sets the is_noise of this TwitterExpression.
        Indicates if a user/agent found this expression to be undesirable

        :param is_noise: The is_noise of this TwitterExpression.
        :type: bool
        """
        
        self._is_noise = is_noise

    @property
    def gistener(self):
        """
        Gets the gistener of this TwitterExpression.
        The Gistener that generated this expression

        :return: The gistener of this TwitterExpression.
        :rtype: Gistener
        """
        return self._gistener

    @gistener.setter
    def gistener(self, gistener):
        """
        Sets the gistener of this TwitterExpression.
        The Gistener that generated this expression

        :param gistener: The gistener of this TwitterExpression.
        :type: Gistener
        """
        
        self._gistener = gistener

    @property
    def tweet_id(self):
        """
        Gets the tweet_id of this TwitterExpression.
        Twitter: the tweet's unique id

        :return: The tweet_id of this TwitterExpression.
        :rtype: str
        """
        return self._tweet_id

    @tweet_id.setter
    def tweet_id(self, tweet_id):
        """
        Sets the tweet_id of this TwitterExpression.
        Twitter: the tweet's unique id

        :param tweet_id: The tweet_id of this TwitterExpression.
        :type: str
        """
        
        self._tweet_id = tweet_id

    @property
    def text(self):
        """
        Gets the text of this TwitterExpression.
        Twitter: the tweets full text

        :return: The text of this TwitterExpression.
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """
        Sets the text of this TwitterExpression.
        Twitter: the tweets full text

        :param text: The text of this TwitterExpression.
        :type: str
        """
        
        self._text = text

    @property
    def tweet_created(self):
        """
        Gets the tweet_created of this TwitterExpression.
        Twitter: the date the tweet was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The tweet_created of this TwitterExpression.
        :rtype: datetime
        """
        return self._tweet_created

    @tweet_created.setter
    def tweet_created(self, tweet_created):
        """
        Sets the tweet_created of this TwitterExpression.
        Twitter: the date the tweet was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param tweet_created: The tweet_created of this TwitterExpression.
        :type: datetime
        """
        
        self._tweet_created = tweet_created

    @property
    def is_reply(self):
        """
        Gets the is_reply of this TwitterExpression.
        Twitter: indicates this tweet as a reply to another tweet

        :return: The is_reply of this TwitterExpression.
        :rtype: bool
        """
        return self._is_reply

    @is_reply.setter
    def is_reply(self, is_reply):
        """
        Sets the is_reply of this TwitterExpression.
        Twitter: indicates this tweet as a reply to another tweet

        :param is_reply: The is_reply of this TwitterExpression.
        :type: bool
        """
        
        self._is_reply = is_reply

    @property
    def is_retweet(self):
        """
        Gets the is_retweet of this TwitterExpression.
        Twitter: indicates this tweet as a 'retweet' of another tweet

        :return: The is_retweet of this TwitterExpression.
        :rtype: bool
        """
        return self._is_retweet

    @is_retweet.setter
    def is_retweet(self, is_retweet):
        """
        Sets the is_retweet of this TwitterExpression.
        Twitter: indicates this tweet as a 'retweet' of another tweet

        :param is_retweet: The is_retweet of this TwitterExpression.
        :type: bool
        """
        
        self._is_retweet = is_retweet

    @property
    def retweet_parent_id(self):
        """
        Gets the retweet_parent_id of this TwitterExpression.
        Twitter: when the expression is a retweet, this is Twitter's id of the original tweet

        :return: The retweet_parent_id of this TwitterExpression.
        :rtype: str
        """
        return self._retweet_parent_id

    @retweet_parent_id.setter
    def retweet_parent_id(self, retweet_parent_id):
        """
        Sets the retweet_parent_id of this TwitterExpression.
        Twitter: when the expression is a retweet, this is Twitter's id of the original tweet

        :param retweet_parent_id: The retweet_parent_id of this TwitterExpression.
        :type: str
        """
        
        self._retweet_parent_id = retweet_parent_id

    @property
    def retweet_count(self):
        """
        Gets the retweet_count of this TwitterExpression.
        Twitter: the number of times the parent tweet was retweeted - at the time this expression was created

        :return: The retweet_count of this TwitterExpression.
        :rtype: int
        """
        return self._retweet_count

    @retweet_count.setter
    def retweet_count(self, retweet_count):
        """
        Sets the retweet_count of this TwitterExpression.
        Twitter: the number of times the parent tweet was retweeted - at the time this expression was created

        :param retweet_count: The retweet_count of this TwitterExpression.
        :type: int
        """
        
        self._retweet_count = retweet_count

    @property
    def is_quoted_tweet(self):
        """
        Gets the is_quoted_tweet of this TwitterExpression.
        Twitter: indicates this expression as a quoted tweet (a tweet with an addendum as the primary text)

        :return: The is_quoted_tweet of this TwitterExpression.
        :rtype: bool
        """
        return self._is_quoted_tweet

    @is_quoted_tweet.setter
    def is_quoted_tweet(self, is_quoted_tweet):
        """
        Sets the is_quoted_tweet of this TwitterExpression.
        Twitter: indicates this expression as a quoted tweet (a tweet with an addendum as the primary text)

        :param is_quoted_tweet: The is_quoted_tweet of this TwitterExpression.
        :type: bool
        """
        
        self._is_quoted_tweet = is_quoted_tweet

    @property
    def quoted_parent_id(self):
        """
        Gets the quoted_parent_id of this TwitterExpression.
        Twitter: when the expression is a quoted tweet, this is Twitter's id of the original tweet (may not be immediately functional)

        :return: The quoted_parent_id of this TwitterExpression.
        :rtype: str
        """
        return self._quoted_parent_id

    @quoted_parent_id.setter
    def quoted_parent_id(self, quoted_parent_id):
        """
        Sets the quoted_parent_id of this TwitterExpression.
        Twitter: when the expression is a quoted tweet, this is Twitter's id of the original tweet (may not be immediately functional)

        :param quoted_parent_id: The quoted_parent_id of this TwitterExpression.
        :type: str
        """
        
        self._quoted_parent_id = quoted_parent_id

    @property
    def user_id(self):
        """
        Gets the user_id of this TwitterExpression.
        Twitter: the expressing user's Twitter id

        :return: The user_id of this TwitterExpression.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """
        Sets the user_id of this TwitterExpression.
        Twitter: the expressing user's Twitter id

        :param user_id: The user_id of this TwitterExpression.
        :type: str
        """
        
        self._user_id = user_id

    @property
    def user_name(self):
        """
        Gets the user_name of this TwitterExpression.
        Twitter: the user's account name for the core service

        :return: The user_name of this TwitterExpression.
        :rtype: str
        """
        return self._user_name

    @user_name.setter
    def user_name(self, user_name):
        """
        Sets the user_name of this TwitterExpression.
        Twitter: the user's account name for the core service

        :param user_name: The user_name of this TwitterExpression.
        :type: str
        """
        
        self._user_name = user_name

    @property
    def user_screen_name(self):
        """
        Gets the user_screen_name of this TwitterExpression.
        Twitter: the user's custom 'branding' name (allowed to change over time)

        :return: The user_screen_name of this TwitterExpression.
        :rtype: str
        """
        return self._user_screen_name

    @user_screen_name.setter
    def user_screen_name(self, user_screen_name):
        """
        Sets the user_screen_name of this TwitterExpression.
        Twitter: the user's custom 'branding' name (allowed to change over time)

        :param user_screen_name: The user_screen_name of this TwitterExpression.
        :type: str
        """
        
        self._user_screen_name = user_screen_name

    @property
    def user_tweet_count(self):
        """
        Gets the user_tweet_count of this TwitterExpression.
        Twitter: the number of times this user has tweeted (includes all forms of expression replies/quotes/retweets)

        :return: The user_tweet_count of this TwitterExpression.
        :rtype: int
        """
        return self._user_tweet_count

    @user_tweet_count.setter
    def user_tweet_count(self, user_tweet_count):
        """
        Sets the user_tweet_count of this TwitterExpression.
        Twitter: the number of times this user has tweeted (includes all forms of expression replies/quotes/retweets)

        :param user_tweet_count: The user_tweet_count of this TwitterExpression.
        :type: int
        """
        
        self._user_tweet_count = user_tweet_count

    @property
    def user_followers_count(self):
        """
        Gets the user_followers_count of this TwitterExpression.
        Twitter: the number of followers this user has at the time of this expression

        :return: The user_followers_count of this TwitterExpression.
        :rtype: int
        """
        return self._user_followers_count

    @user_followers_count.setter
    def user_followers_count(self, user_followers_count):
        """
        Sets the user_followers_count of this TwitterExpression.
        Twitter: the number of followers this user has at the time of this expression

        :param user_followers_count: The user_followers_count of this TwitterExpression.
        :type: int
        """
        
        self._user_followers_count = user_followers_count

    @property
    def group_tags(self):
        """
        Gets the group_tags of this TwitterExpression.
        The Group Tags applied by the generating Gistener

        :return: The group_tags of this TwitterExpression.
        :rtype: list[GroupTag]
        """
        return self._group_tags

    @group_tags.setter
    def group_tags(self, group_tags):
        """
        Sets the group_tags of this TwitterExpression.
        The Group Tags applied by the generating Gistener

        :param group_tags: The group_tags of this TwitterExpression.
        :type: list[GroupTag]
        """
        
        self._group_tags = group_tags

    @property
    def routed(self):
        """
        Gets the routed of this TwitterExpression.


        :return: The routed of this TwitterExpression.
        :rtype: bool
        """
        return self._routed

    @routed.setter
    def routed(self, routed):
        """
        Sets the routed of this TwitterExpression.


        :param routed: The routed of this TwitterExpression.
        :type: bool
        """
        
        self._routed = routed

    @property
    def self_uri(self):
        """
        Gets the self_uri of this TwitterExpression.
        The URI for this object

        :return: The self_uri of this TwitterExpression.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this TwitterExpression.
        The URI for this object

        :param self_uri: The self_uri of this TwitterExpression.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

