# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class UploadProgress(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        UploadProgress - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'carrier_id': 'str',
            'schema_name': 'str',
            'status': 'str',
            'filename': 'str',
            'filetype': 'str',
            'created': 'datetime',
            'updated': 'datetime'
        }

        self.attribute_map = {
            'carrier_id': 'CarrierId',
            'schema_name': 'SchemaName',
            'status': 'Status',
            'filename': 'Filename',
            'filetype': 'Filetype',
            'created': 'Created',
            'updated': 'Updated'
        }

        self._carrier_id = None
        self._schema_name = None
        self._status = None
        self._filename = None
        self._filetype = None
        self._created = None
        self._updated = None

    @property
    def carrier_id(self):
        """
        Gets the carrier_id of this UploadProgress.
        Carrier id associated with the ratesheet that was uploaded.

        :return: The carrier_id of this UploadProgress.
        :rtype: str
        """
        return self._carrier_id

    @carrier_id.setter
    def carrier_id(self, carrier_id):
        """
        Sets the carrier_id of this UploadProgress.
        Carrier id associated with the ratesheet that was uploaded.

        :param carrier_id: The carrier_id of this UploadProgress.
        :type: str
        """
        
        self._carrier_id = carrier_id

    @property
    def schema_name(self):
        """
        Gets the schema_name of this UploadProgress.
        Human readable name for the schema that was used to parse the ratesheet.

        :return: The schema_name of this UploadProgress.
        :rtype: str
        """
        return self._schema_name

    @schema_name.setter
    def schema_name(self, schema_name):
        """
        Sets the schema_name of this UploadProgress.
        Human readable name for the schema that was used to parse the ratesheet.

        :param schema_name: The schema_name of this UploadProgress.
        :type: str
        """
        
        self._schema_name = schema_name

    @property
    def status(self):
        """
        Gets the status of this UploadProgress.
        Human readable status for progress of the ratesheet upload. This may be an error, the number of rates upload, or a completion message.

        :return: The status of this UploadProgress.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this UploadProgress.
        Human readable status for progress of the ratesheet upload. This may be an error, the number of rates upload, or a completion message.

        :param status: The status of this UploadProgress.
        :type: str
        """
        
        self._status = status

    @property
    def filename(self):
        """
        Gets the filename of this UploadProgress.
        Filename of the ratesheet that was uploaded by the user.

        :return: The filename of this UploadProgress.
        :rtype: str
        """
        return self._filename

    @filename.setter
    def filename(self, filename):
        """
        Sets the filename of this UploadProgress.
        Filename of the ratesheet that was uploaded by the user.

        :param filename: The filename of this UploadProgress.
        :type: str
        """
        
        self._filename = filename

    @property
    def filetype(self):
        """
        Gets the filetype of this UploadProgress.
        Media type of the file.

        :return: The filetype of this UploadProgress.
        :rtype: str
        """
        return self._filetype

    @filetype.setter
    def filetype(self, filetype):
        """
        Sets the filetype of this UploadProgress.
        Media type of the file.

        :param filetype: The filetype of this UploadProgress.
        :type: str
        """
        
        self._filetype = filetype

    @property
    def created(self):
        """
        Gets the created of this UploadProgress.
        Time at which the uploaded ratesheet was started to be parsed. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The created of this UploadProgress.
        :rtype: datetime
        """
        return self._created

    @created.setter
    def created(self, created):
        """
        Sets the created of this UploadProgress.
        Time at which the uploaded ratesheet was started to be parsed. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param created: The created of this UploadProgress.
        :type: datetime
        """
        
        self._created = created

    @property
    def updated(self):
        """
        Gets the updated of this UploadProgress.
        Time at which the progress of the upload was last updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The updated of this UploadProgress.
        :rtype: datetime
        """
        return self._updated

    @updated.setter
    def updated(self, updated):
        """
        Sets the updated of this UploadProgress.
        Time at which the progress of the upload was last updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param updated: The updated of this UploadProgress.
        :type: datetime
        """
        
        self._updated = updated

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

