# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class UserActionMetadata(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        UserActionMetadata - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'category': 'str',
            'deprecated': 'bool',
            'description': 'str',
            'published': 'bool',
            'tags': 'list[str]',
            'help_link': 'str',
            'requests': 'list[UserActionMetadataRequest]',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'category': 'category',
            'deprecated': 'deprecated',
            'description': 'description',
            'published': 'published',
            'tags': 'tags',
            'help_link': 'helpLink',
            'requests': 'requests',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._category = None
        self._deprecated = False
        self._description = None
        self._published = False
        self._tags = None
        self._help_link = None
        self._requests = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this UserActionMetadata.
        The globally unique identifier for the object.

        :return: The id of this UserActionMetadata.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this UserActionMetadata.
        The globally unique identifier for the object.

        :param id: The id of this UserActionMetadata.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this UserActionMetadata.


        :return: The name of this UserActionMetadata.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this UserActionMetadata.


        :param name: The name of this UserActionMetadata.
        :type: str
        """
        
        self._name = name

    @property
    def category(self):
        """
        Gets the category of this UserActionMetadata.


        :return: The category of this UserActionMetadata.
        :rtype: str
        """
        return self._category

    @category.setter
    def category(self, category):
        """
        Sets the category of this UserActionMetadata.


        :param category: The category of this UserActionMetadata.
        :type: str
        """
        
        self._category = category

    @property
    def deprecated(self):
        """
        Gets the deprecated of this UserActionMetadata.


        :return: The deprecated of this UserActionMetadata.
        :rtype: bool
        """
        return self._deprecated

    @deprecated.setter
    def deprecated(self, deprecated):
        """
        Sets the deprecated of this UserActionMetadata.


        :param deprecated: The deprecated of this UserActionMetadata.
        :type: bool
        """
        
        self._deprecated = deprecated

    @property
    def description(self):
        """
        Gets the description of this UserActionMetadata.


        :return: The description of this UserActionMetadata.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UserActionMetadata.


        :param description: The description of this UserActionMetadata.
        :type: str
        """
        
        self._description = description

    @property
    def published(self):
        """
        Gets the published of this UserActionMetadata.


        :return: The published of this UserActionMetadata.
        :rtype: bool
        """
        return self._published

    @published.setter
    def published(self, published):
        """
        Sets the published of this UserActionMetadata.


        :param published: The published of this UserActionMetadata.
        :type: bool
        """
        
        self._published = published

    @property
    def tags(self):
        """
        Gets the tags of this UserActionMetadata.


        :return: The tags of this UserActionMetadata.
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this UserActionMetadata.


        :param tags: The tags of this UserActionMetadata.
        :type: list[str]
        """
        
        self._tags = tags

    @property
    def help_link(self):
        """
        Gets the help_link of this UserActionMetadata.


        :return: The help_link of this UserActionMetadata.
        :rtype: str
        """
        return self._help_link

    @help_link.setter
    def help_link(self, help_link):
        """
        Sets the help_link of this UserActionMetadata.


        :param help_link: The help_link of this UserActionMetadata.
        :type: str
        """
        
        self._help_link = help_link

    @property
    def requests(self):
        """
        Gets the requests of this UserActionMetadata.


        :return: The requests of this UserActionMetadata.
        :rtype: list[UserActionMetadataRequest]
        """
        return self._requests

    @requests.setter
    def requests(self, requests):
        """
        Sets the requests of this UserActionMetadata.


        :param requests: The requests of this UserActionMetadata.
        :type: list[UserActionMetadataRequest]
        """
        
        self._requests = requests

    @property
    def self_uri(self):
        """
        Gets the self_uri of this UserActionMetadata.
        The URI for this object

        :return: The self_uri of this UserActionMetadata.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this UserActionMetadata.
        The URI for this object

        :param self_uri: The self_uri of this UserActionMetadata.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

