# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class UserActionMetadataRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        UserActionMetadataRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'format': 'str',
            'method': 'str',
            'input_schema_uri': 'str',
            'success_schema_uri': 'str',
            'input_schema': 'object',
            'success_schema': 'object'
        }

        self.attribute_map = {
            'format': 'format',
            'method': 'method',
            'input_schema_uri': 'inputSchemaUri',
            'success_schema_uri': 'successSchemaUri',
            'input_schema': 'inputSchema',
            'success_schema': 'successSchema'
        }

        self._format = None
        self._method = None
        self._input_schema_uri = None
        self._success_schema_uri = None
        self._input_schema = None
        self._success_schema = None

    @property
    def format(self):
        """
        Gets the format of this UserActionMetadataRequest.


        :return: The format of this UserActionMetadataRequest.
        :rtype: str
        """
        return self._format

    @format.setter
    def format(self, format):
        """
        Sets the format of this UserActionMetadataRequest.


        :param format: The format of this UserActionMetadataRequest.
        :type: str
        """
        
        self._format = format

    @property
    def method(self):
        """
        Gets the method of this UserActionMetadataRequest.


        :return: The method of this UserActionMetadataRequest.
        :rtype: str
        """
        return self._method

    @method.setter
    def method(self, method):
        """
        Sets the method of this UserActionMetadataRequest.


        :param method: The method of this UserActionMetadataRequest.
        :type: str
        """
        
        self._method = method

    @property
    def input_schema_uri(self):
        """
        Gets the input_schema_uri of this UserActionMetadataRequest.


        :return: The input_schema_uri of this UserActionMetadataRequest.
        :rtype: str
        """
        return self._input_schema_uri

    @input_schema_uri.setter
    def input_schema_uri(self, input_schema_uri):
        """
        Sets the input_schema_uri of this UserActionMetadataRequest.


        :param input_schema_uri: The input_schema_uri of this UserActionMetadataRequest.
        :type: str
        """
        
        self._input_schema_uri = input_schema_uri

    @property
    def success_schema_uri(self):
        """
        Gets the success_schema_uri of this UserActionMetadataRequest.


        :return: The success_schema_uri of this UserActionMetadataRequest.
        :rtype: str
        """
        return self._success_schema_uri

    @success_schema_uri.setter
    def success_schema_uri(self, success_schema_uri):
        """
        Sets the success_schema_uri of this UserActionMetadataRequest.


        :param success_schema_uri: The success_schema_uri of this UserActionMetadataRequest.
        :type: str
        """
        
        self._success_schema_uri = success_schema_uri

    @property
    def input_schema(self):
        """
        Gets the input_schema of this UserActionMetadataRequest.


        :return: The input_schema of this UserActionMetadataRequest.
        :rtype: object
        """
        return self._input_schema

    @input_schema.setter
    def input_schema(self, input_schema):
        """
        Sets the input_schema of this UserActionMetadataRequest.


        :param input_schema: The input_schema of this UserActionMetadataRequest.
        :type: object
        """
        
        self._input_schema = input_schema

    @property
    def success_schema(self):
        """
        Gets the success_schema of this UserActionMetadataRequest.


        :return: The success_schema of this UserActionMetadataRequest.
        :rtype: object
        """
        return self._success_schema

    @success_schema.setter
    def success_schema(self, success_schema):
        """
        Sets the success_schema of this UserActionMetadataRequest.


        :param success_schema: The success_schema of this UserActionMetadataRequest.
        :type: object
        """
        
        self._success_schema = success_schema

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

