# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class Value(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Value - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'string_items': 'list[str]',
            'integer_items': 'list[str]',
            'real_items': 'list[str]',
            'date_items': 'list[datetime]',
            'user_items': 'list[User]',
            'queue_items': 'list[Queue]',
            'data_items': 'list[SubDataItem]'
        }

        self.attribute_map = {
            'string_items': 'stringItems',
            'integer_items': 'integerItems',
            'real_items': 'realItems',
            'date_items': 'dateItems',
            'user_items': 'userItems',
            'queue_items': 'queueItems',
            'data_items': 'dataItems'
        }

        self._string_items = None
        self._integer_items = None
        self._real_items = None
        self._date_items = None
        self._user_items = None
        self._queue_items = None
        self._data_items = None

    @property
    def string_items(self):
        """
        Gets the string_items of this Value.


        :return: The string_items of this Value.
        :rtype: list[str]
        """
        return self._string_items

    @string_items.setter
    def string_items(self, string_items):
        """
        Sets the string_items of this Value.


        :param string_items: The string_items of this Value.
        :type: list[str]
        """
        
        self._string_items = string_items

    @property
    def integer_items(self):
        """
        Gets the integer_items of this Value.


        :return: The integer_items of this Value.
        :rtype: list[str]
        """
        return self._integer_items

    @integer_items.setter
    def integer_items(self, integer_items):
        """
        Sets the integer_items of this Value.


        :param integer_items: The integer_items of this Value.
        :type: list[str]
        """
        
        self._integer_items = integer_items

    @property
    def real_items(self):
        """
        Gets the real_items of this Value.


        :return: The real_items of this Value.
        :rtype: list[str]
        """
        return self._real_items

    @real_items.setter
    def real_items(self, real_items):
        """
        Sets the real_items of this Value.


        :param real_items: The real_items of this Value.
        :type: list[str]
        """
        
        self._real_items = real_items

    @property
    def date_items(self):
        """
        Gets the date_items of this Value.


        :return: The date_items of this Value.
        :rtype: list[datetime]
        """
        return self._date_items

    @date_items.setter
    def date_items(self, date_items):
        """
        Sets the date_items of this Value.


        :param date_items: The date_items of this Value.
        :type: list[datetime]
        """
        
        self._date_items = date_items

    @property
    def user_items(self):
        """
        Gets the user_items of this Value.


        :return: The user_items of this Value.
        :rtype: list[User]
        """
        return self._user_items

    @user_items.setter
    def user_items(self, user_items):
        """
        Sets the user_items of this Value.


        :param user_items: The user_items of this Value.
        :type: list[User]
        """
        
        self._user_items = user_items

    @property
    def queue_items(self):
        """
        Gets the queue_items of this Value.


        :return: The queue_items of this Value.
        :rtype: list[Queue]
        """
        return self._queue_items

    @queue_items.setter
    def queue_items(self, queue_items):
        """
        Sets the queue_items of this Value.


        :param queue_items: The queue_items of this Value.
        :type: list[Queue]
        """
        
        self._queue_items = queue_items

    @property
    def data_items(self):
        """
        Gets the data_items of this Value.


        :return: The data_items of this Value.
        :rtype: list[SubDataItem]
        """
        return self._data_items

    @data_items.setter
    def data_items(self, data_items):
        """
        Sets the data_items of this Value.


        :param data_items: The data_items of this Value.
        :type: list[SubDataItem]
        """
        
        self._data_items = data_items

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

