# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class VoiceRateExtended(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        VoiceRateExtended - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'currency': 'str',
            'amendment_id': 'str',
            'type': 'str',
            'effective_date': 'datetime',
            'group_name': 'str',
            'area_code': 'str',
            'deletion_marker': 'bool',
            'outbound_rate': 'float',
            'outbound_duration_minimum_seconds': 'int',
            'outbound_duration_increment_seconds': 'int',
            'inbound_tolled_rate': 'float',
            'inbound_tolled_duration_minimum_seconds': 'int',
            'inbound_tolled_duration_increment_seconds': 'int',
            'inbound_toll_free_rate': 'float',
            'inbound_toll_free_duration_minimum_seconds': 'int',
            'inbound_toll_free_duration_increment_seconds': 'int',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'currency': 'currency',
            'amendment_id': 'amendmentId',
            'type': 'type',
            'effective_date': 'effectiveDate',
            'group_name': 'groupName',
            'area_code': 'areaCode',
            'deletion_marker': 'deletionMarker',
            'outbound_rate': 'outboundRate',
            'outbound_duration_minimum_seconds': 'outboundDurationMinimumSeconds',
            'outbound_duration_increment_seconds': 'outboundDurationIncrementSeconds',
            'inbound_tolled_rate': 'inboundTolledRate',
            'inbound_tolled_duration_minimum_seconds': 'inboundTolledDurationMinimumSeconds',
            'inbound_tolled_duration_increment_seconds': 'inboundTolledDurationIncrementSeconds',
            'inbound_toll_free_rate': 'inboundTollFreeRate',
            'inbound_toll_free_duration_minimum_seconds': 'inboundTollFreeDurationMinimumSeconds',
            'inbound_toll_free_duration_increment_seconds': 'inboundTollFreeDurationIncrementSeconds',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._currency = None
        self._amendment_id = None
        self._type = None
        self._effective_date = None
        self._group_name = None
        self._area_code = None
        self._deletion_marker = False
        self._outbound_rate = None
        self._outbound_duration_minimum_seconds = None
        self._outbound_duration_increment_seconds = None
        self._inbound_tolled_rate = None
        self._inbound_tolled_duration_minimum_seconds = None
        self._inbound_tolled_duration_increment_seconds = None
        self._inbound_toll_free_rate = None
        self._inbound_toll_free_duration_minimum_seconds = None
        self._inbound_toll_free_duration_increment_seconds = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this VoiceRateExtended.
        The globally unique identifier for the object.

        :return: The id of this VoiceRateExtended.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this VoiceRateExtended.
        The globally unique identifier for the object.

        :param id: The id of this VoiceRateExtended.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this VoiceRateExtended.


        :return: The name of this VoiceRateExtended.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this VoiceRateExtended.


        :param name: The name of this VoiceRateExtended.
        :type: str
        """
        
        self._name = name

    @property
    def currency(self):
        """
        Gets the currency of this VoiceRateExtended.
        The ISO 4217 currency code of the voice rate.

        :return: The currency of this VoiceRateExtended.
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """
        Sets the currency of this VoiceRateExtended.
        The ISO 4217 currency code of the voice rate.

        :param currency: The currency of this VoiceRateExtended.
        :type: str
        """
        
        self._currency = currency

    @property
    def amendment_id(self):
        """
        Gets the amendment_id of this VoiceRateExtended.
        The amendment Id of the voice rate.

        :return: The amendment_id of this VoiceRateExtended.
        :rtype: str
        """
        return self._amendment_id

    @amendment_id.setter
    def amendment_id(self, amendment_id):
        """
        Sets the amendment_id of this VoiceRateExtended.
        The amendment Id of the voice rate.

        :param amendment_id: The amendment_id of this VoiceRateExtended.
        :type: str
        """
        
        self._amendment_id = amendment_id

    @property
    def type(self):
        """
        Gets the type of this VoiceRateExtended.
        The voice rate type.

        :return: The type of this VoiceRateExtended.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this VoiceRateExtended.
        The voice rate type.

        :param type: The type of this VoiceRateExtended.
        :type: str
        """
        allowed_values = ["RATE_TOLL_FREE", "RATE_TOLLED", "OUTBOUND_INTERSTATE", "OUTBOUND_INTRASTATE", "OUTBOUND_LOCAL", "EXTENDED"]
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type`, must be one of {0}"
                .format(allowed_values)
            )

        self._type = type

    @property
    def effective_date(self):
        """
        Gets the effective_date of this VoiceRateExtended.
        The effective date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The effective_date of this VoiceRateExtended.
        :rtype: datetime
        """
        return self._effective_date

    @effective_date.setter
    def effective_date(self, effective_date):
        """
        Sets the effective_date of this VoiceRateExtended.
        The effective date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param effective_date: The effective_date of this VoiceRateExtended.
        :type: datetime
        """
        
        self._effective_date = effective_date

    @property
    def group_name(self):
        """
        Gets the group_name of this VoiceRateExtended.
        The group containing this area code.

        :return: The group_name of this VoiceRateExtended.
        :rtype: str
        """
        return self._group_name

    @group_name.setter
    def group_name(self, group_name):
        """
        Sets the group_name of this VoiceRateExtended.
        The group containing this area code.

        :param group_name: The group_name of this VoiceRateExtended.
        :type: str
        """
        
        self._group_name = group_name

    @property
    def area_code(self):
        """
        Gets the area_code of this VoiceRateExtended.
        The area code.

        :return: The area_code of this VoiceRateExtended.
        :rtype: str
        """
        return self._area_code

    @area_code.setter
    def area_code(self, area_code):
        """
        Sets the area_code of this VoiceRateExtended.
        The area code.

        :param area_code: The area_code of this VoiceRateExtended.
        :type: str
        """
        
        self._area_code = area_code

    @property
    def deletion_marker(self):
        """
        Gets the deletion_marker of this VoiceRateExtended.
        The deletion marker.

        :return: The deletion_marker of this VoiceRateExtended.
        :rtype: bool
        """
        return self._deletion_marker

    @deletion_marker.setter
    def deletion_marker(self, deletion_marker):
        """
        Sets the deletion_marker of this VoiceRateExtended.
        The deletion marker.

        :param deletion_marker: The deletion_marker of this VoiceRateExtended.
        :type: bool
        """
        
        self._deletion_marker = deletion_marker

    @property
    def outbound_rate(self):
        """
        Gets the outbound_rate of this VoiceRateExtended.
        The outbound extended rate.

        :return: The outbound_rate of this VoiceRateExtended.
        :rtype: float
        """
        return self._outbound_rate

    @outbound_rate.setter
    def outbound_rate(self, outbound_rate):
        """
        Sets the outbound_rate of this VoiceRateExtended.
        The outbound extended rate.

        :param outbound_rate: The outbound_rate of this VoiceRateExtended.
        :type: float
        """
        
        self._outbound_rate = outbound_rate

    @property
    def outbound_duration_minimum_seconds(self):
        """
        Gets the outbound_duration_minimum_seconds of this VoiceRateExtended.
        The minimum duration charged in seconds.

        :return: The outbound_duration_minimum_seconds of this VoiceRateExtended.
        :rtype: int
        """
        return self._outbound_duration_minimum_seconds

    @outbound_duration_minimum_seconds.setter
    def outbound_duration_minimum_seconds(self, outbound_duration_minimum_seconds):
        """
        Sets the outbound_duration_minimum_seconds of this VoiceRateExtended.
        The minimum duration charged in seconds.

        :param outbound_duration_minimum_seconds: The outbound_duration_minimum_seconds of this VoiceRateExtended.
        :type: int
        """
        
        self._outbound_duration_minimum_seconds = outbound_duration_minimum_seconds

    @property
    def outbound_duration_increment_seconds(self):
        """
        Gets the outbound_duration_increment_seconds of this VoiceRateExtended.
        The billing duration increment in seconds.

        :return: The outbound_duration_increment_seconds of this VoiceRateExtended.
        :rtype: int
        """
        return self._outbound_duration_increment_seconds

    @outbound_duration_increment_seconds.setter
    def outbound_duration_increment_seconds(self, outbound_duration_increment_seconds):
        """
        Sets the outbound_duration_increment_seconds of this VoiceRateExtended.
        The billing duration increment in seconds.

        :param outbound_duration_increment_seconds: The outbound_duration_increment_seconds of this VoiceRateExtended.
        :type: int
        """
        
        self._outbound_duration_increment_seconds = outbound_duration_increment_seconds

    @property
    def inbound_tolled_rate(self):
        """
        Gets the inbound_tolled_rate of this VoiceRateExtended.
        The inbound tolled rate.

        :return: The inbound_tolled_rate of this VoiceRateExtended.
        :rtype: float
        """
        return self._inbound_tolled_rate

    @inbound_tolled_rate.setter
    def inbound_tolled_rate(self, inbound_tolled_rate):
        """
        Sets the inbound_tolled_rate of this VoiceRateExtended.
        The inbound tolled rate.

        :param inbound_tolled_rate: The inbound_tolled_rate of this VoiceRateExtended.
        :type: float
        """
        
        self._inbound_tolled_rate = inbound_tolled_rate

    @property
    def inbound_tolled_duration_minimum_seconds(self):
        """
        Gets the inbound_tolled_duration_minimum_seconds of this VoiceRateExtended.
        The minimum duration charged in seconds.

        :return: The inbound_tolled_duration_minimum_seconds of this VoiceRateExtended.
        :rtype: int
        """
        return self._inbound_tolled_duration_minimum_seconds

    @inbound_tolled_duration_minimum_seconds.setter
    def inbound_tolled_duration_minimum_seconds(self, inbound_tolled_duration_minimum_seconds):
        """
        Sets the inbound_tolled_duration_minimum_seconds of this VoiceRateExtended.
        The minimum duration charged in seconds.

        :param inbound_tolled_duration_minimum_seconds: The inbound_tolled_duration_minimum_seconds of this VoiceRateExtended.
        :type: int
        """
        
        self._inbound_tolled_duration_minimum_seconds = inbound_tolled_duration_minimum_seconds

    @property
    def inbound_tolled_duration_increment_seconds(self):
        """
        Gets the inbound_tolled_duration_increment_seconds of this VoiceRateExtended.
        The billing duration increment in seconds.

        :return: The inbound_tolled_duration_increment_seconds of this VoiceRateExtended.
        :rtype: int
        """
        return self._inbound_tolled_duration_increment_seconds

    @inbound_tolled_duration_increment_seconds.setter
    def inbound_tolled_duration_increment_seconds(self, inbound_tolled_duration_increment_seconds):
        """
        Sets the inbound_tolled_duration_increment_seconds of this VoiceRateExtended.
        The billing duration increment in seconds.

        :param inbound_tolled_duration_increment_seconds: The inbound_tolled_duration_increment_seconds of this VoiceRateExtended.
        :type: int
        """
        
        self._inbound_tolled_duration_increment_seconds = inbound_tolled_duration_increment_seconds

    @property
    def inbound_toll_free_rate(self):
        """
        Gets the inbound_toll_free_rate of this VoiceRateExtended.
        The inbound toll-free rate.

        :return: The inbound_toll_free_rate of this VoiceRateExtended.
        :rtype: float
        """
        return self._inbound_toll_free_rate

    @inbound_toll_free_rate.setter
    def inbound_toll_free_rate(self, inbound_toll_free_rate):
        """
        Sets the inbound_toll_free_rate of this VoiceRateExtended.
        The inbound toll-free rate.

        :param inbound_toll_free_rate: The inbound_toll_free_rate of this VoiceRateExtended.
        :type: float
        """
        
        self._inbound_toll_free_rate = inbound_toll_free_rate

    @property
    def inbound_toll_free_duration_minimum_seconds(self):
        """
        Gets the inbound_toll_free_duration_minimum_seconds of this VoiceRateExtended.
        The minimum duration charged in seconds.

        :return: The inbound_toll_free_duration_minimum_seconds of this VoiceRateExtended.
        :rtype: int
        """
        return self._inbound_toll_free_duration_minimum_seconds

    @inbound_toll_free_duration_minimum_seconds.setter
    def inbound_toll_free_duration_minimum_seconds(self, inbound_toll_free_duration_minimum_seconds):
        """
        Sets the inbound_toll_free_duration_minimum_seconds of this VoiceRateExtended.
        The minimum duration charged in seconds.

        :param inbound_toll_free_duration_minimum_seconds: The inbound_toll_free_duration_minimum_seconds of this VoiceRateExtended.
        :type: int
        """
        
        self._inbound_toll_free_duration_minimum_seconds = inbound_toll_free_duration_minimum_seconds

    @property
    def inbound_toll_free_duration_increment_seconds(self):
        """
        Gets the inbound_toll_free_duration_increment_seconds of this VoiceRateExtended.
        The billing duration increment in seconds.

        :return: The inbound_toll_free_duration_increment_seconds of this VoiceRateExtended.
        :rtype: int
        """
        return self._inbound_toll_free_duration_increment_seconds

    @inbound_toll_free_duration_increment_seconds.setter
    def inbound_toll_free_duration_increment_seconds(self, inbound_toll_free_duration_increment_seconds):
        """
        Sets the inbound_toll_free_duration_increment_seconds of this VoiceRateExtended.
        The billing duration increment in seconds.

        :param inbound_toll_free_duration_increment_seconds: The inbound_toll_free_duration_increment_seconds of this VoiceRateExtended.
        :type: int
        """
        
        self._inbound_toll_free_duration_increment_seconds = inbound_toll_free_duration_increment_seconds

    @property
    def self_uri(self):
        """
        Gets the self_uri of this VoiceRateExtended.
        The URI for this object

        :return: The self_uri of this VoiceRateExtended.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this VoiceRateExtended.
        The URI for this object

        :param self_uri: The self_uri of this VoiceRateExtended.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

