# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class VoiceRateInternational(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        VoiceRateInternational - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'currency': 'str',
            'amendment_id': 'str',
            'type': 'str',
            'effective_date': 'datetime',
            'rate': 'float',
            'duration_minimum_seconds': 'int',
            'duration_increment_seconds': 'int',
            'origin': 'str',
            'destination': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'currency': 'currency',
            'amendment_id': 'amendmentId',
            'type': 'type',
            'effective_date': 'effectiveDate',
            'rate': 'rate',
            'duration_minimum_seconds': 'durationMinimumSeconds',
            'duration_increment_seconds': 'durationIncrementSeconds',
            'origin': 'origin',
            'destination': 'destination',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._currency = None
        self._amendment_id = None
        self._type = None
        self._effective_date = None
        self._rate = None
        self._duration_minimum_seconds = None
        self._duration_increment_seconds = None
        self._origin = None
        self._destination = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this VoiceRateInternational.
        The globally unique identifier for the object.

        :return: The id of this VoiceRateInternational.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this VoiceRateInternational.
        The globally unique identifier for the object.

        :param id: The id of this VoiceRateInternational.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this VoiceRateInternational.


        :return: The name of this VoiceRateInternational.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this VoiceRateInternational.


        :param name: The name of this VoiceRateInternational.
        :type: str
        """
        
        self._name = name

    @property
    def currency(self):
        """
        Gets the currency of this VoiceRateInternational.
        The ISO 4217 currency code of the voice rate.

        :return: The currency of this VoiceRateInternational.
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """
        Sets the currency of this VoiceRateInternational.
        The ISO 4217 currency code of the voice rate.

        :param currency: The currency of this VoiceRateInternational.
        :type: str
        """
        
        self._currency = currency

    @property
    def amendment_id(self):
        """
        Gets the amendment_id of this VoiceRateInternational.
        The amendment Id of the voice rate.

        :return: The amendment_id of this VoiceRateInternational.
        :rtype: str
        """
        return self._amendment_id

    @amendment_id.setter
    def amendment_id(self, amendment_id):
        """
        Sets the amendment_id of this VoiceRateInternational.
        The amendment Id of the voice rate.

        :param amendment_id: The amendment_id of this VoiceRateInternational.
        :type: str
        """
        
        self._amendment_id = amendment_id

    @property
    def type(self):
        """
        Gets the type of this VoiceRateInternational.
        The voice rate type.

        :return: The type of this VoiceRateInternational.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this VoiceRateInternational.
        The voice rate type.

        :param type: The type of this VoiceRateInternational.
        :type: str
        """
        allowed_values = ["RATE_TOLL_FREE", "RATE_TOLLED", "OUTBOUND_INTERSTATE", "OUTBOUND_INTRASTATE", "OUTBOUND_LOCAL", "EXTENDED"]
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type`, must be one of {0}"
                .format(allowed_values)
            )

        self._type = type

    @property
    def effective_date(self):
        """
        Gets the effective_date of this VoiceRateInternational.
        The effective date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The effective_date of this VoiceRateInternational.
        :rtype: datetime
        """
        return self._effective_date

    @effective_date.setter
    def effective_date(self, effective_date):
        """
        Sets the effective_date of this VoiceRateInternational.
        The effective date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param effective_date: The effective_date of this VoiceRateInternational.
        :type: datetime
        """
        
        self._effective_date = effective_date

    @property
    def rate(self):
        """
        Gets the rate of this VoiceRateInternational.
        The rate.

        :return: The rate of this VoiceRateInternational.
        :rtype: float
        """
        return self._rate

    @rate.setter
    def rate(self, rate):
        """
        Sets the rate of this VoiceRateInternational.
        The rate.

        :param rate: The rate of this VoiceRateInternational.
        :type: float
        """
        
        self._rate = rate

    @property
    def duration_minimum_seconds(self):
        """
        Gets the duration_minimum_seconds of this VoiceRateInternational.
        The minimum duration charged in seconds.

        :return: The duration_minimum_seconds of this VoiceRateInternational.
        :rtype: int
        """
        return self._duration_minimum_seconds

    @duration_minimum_seconds.setter
    def duration_minimum_seconds(self, duration_minimum_seconds):
        """
        Sets the duration_minimum_seconds of this VoiceRateInternational.
        The minimum duration charged in seconds.

        :param duration_minimum_seconds: The duration_minimum_seconds of this VoiceRateInternational.
        :type: int
        """
        
        self._duration_minimum_seconds = duration_minimum_seconds

    @property
    def duration_increment_seconds(self):
        """
        Gets the duration_increment_seconds of this VoiceRateInternational.
        The billing duration increment in seconds.

        :return: The duration_increment_seconds of this VoiceRateInternational.
        :rtype: int
        """
        return self._duration_increment_seconds

    @duration_increment_seconds.setter
    def duration_increment_seconds(self, duration_increment_seconds):
        """
        Sets the duration_increment_seconds of this VoiceRateInternational.
        The billing duration increment in seconds.

        :param duration_increment_seconds: The duration_increment_seconds of this VoiceRateInternational.
        :type: int
        """
        
        self._duration_increment_seconds = duration_increment_seconds

    @property
    def origin(self):
        """
        Gets the origin of this VoiceRateInternational.
        The origin.

        :return: The origin of this VoiceRateInternational.
        :rtype: str
        """
        return self._origin

    @origin.setter
    def origin(self, origin):
        """
        Sets the origin of this VoiceRateInternational.
        The origin.

        :param origin: The origin of this VoiceRateInternational.
        :type: str
        """
        
        self._origin = origin

    @property
    def destination(self):
        """
        Gets the destination of this VoiceRateInternational.
        The destination.

        :return: The destination of this VoiceRateInternational.
        :rtype: str
        """
        return self._destination

    @destination.setter
    def destination(self, destination):
        """
        Sets the destination of this VoiceRateInternational.
        The destination.

        :param destination: The destination of this VoiceRateInternational.
        :type: str
        """
        
        self._destination = destination

    @property
    def self_uri(self):
        """
        Gets the self_uri of this VoiceRateInternational.
        The URI for this object

        :return: The self_uri of this VoiceRateInternational.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this VoiceRateInternational.
        The URI for this object

        :param self_uri: The self_uri of this VoiceRateInternational.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

