# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class VoiceRateUpdate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        VoiceRateUpdate - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'currency': 'str',
            'inbound_toll_free': 'VoiceRate',
            'extended': 'list[VoiceRateExtended]',
            'inbound_tolled': 'VoiceRate',
            'outbound_local': 'VoiceRate',
            'outbound_intra_state': 'VoiceRate',
            'outbound_inter_state': 'VoiceRate',
            'outbound_international': 'list[VoiceRateInternational]',
            'amendment_date': 'datetime',
            'effective_date': 'datetime',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'currency': 'currency',
            'inbound_toll_free': 'inboundTollFree',
            'extended': 'extended',
            'inbound_tolled': 'inboundTolled',
            'outbound_local': 'outboundLocal',
            'outbound_intra_state': 'outboundIntraState',
            'outbound_inter_state': 'outboundInterState',
            'outbound_international': 'outboundInternational',
            'amendment_date': 'amendmentDate',
            'effective_date': 'effectiveDate',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._currency = None
        self._inbound_toll_free = None
        self._extended = None
        self._inbound_tolled = None
        self._outbound_local = None
        self._outbound_intra_state = None
        self._outbound_inter_state = None
        self._outbound_international = None
        self._amendment_date = None
        self._effective_date = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this VoiceRateUpdate.
        The globally unique identifier for the object.

        :return: The id of this VoiceRateUpdate.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this VoiceRateUpdate.
        The globally unique identifier for the object.

        :param id: The id of this VoiceRateUpdate.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this VoiceRateUpdate.


        :return: The name of this VoiceRateUpdate.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this VoiceRateUpdate.


        :param name: The name of this VoiceRateUpdate.
        :type: str
        """
        
        self._name = name

    @property
    def currency(self):
        """
        Gets the currency of this VoiceRateUpdate.
        The ISO 4217 currency code of the voice rate.

        :return: The currency of this VoiceRateUpdate.
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """
        Sets the currency of this VoiceRateUpdate.
        The ISO 4217 currency code of the voice rate.

        :param currency: The currency of this VoiceRateUpdate.
        :type: str
        """
        
        self._currency = currency

    @property
    def inbound_toll_free(self):
        """
        Gets the inbound_toll_free of this VoiceRateUpdate.
        The inbound toll free rate.

        :return: The inbound_toll_free of this VoiceRateUpdate.
        :rtype: VoiceRate
        """
        return self._inbound_toll_free

    @inbound_toll_free.setter
    def inbound_toll_free(self, inbound_toll_free):
        """
        Sets the inbound_toll_free of this VoiceRateUpdate.
        The inbound toll free rate.

        :param inbound_toll_free: The inbound_toll_free of this VoiceRateUpdate.
        :type: VoiceRate
        """
        
        self._inbound_toll_free = inbound_toll_free

    @property
    def extended(self):
        """
        Gets the extended of this VoiceRateUpdate.
        The domestic extended rates.

        :return: The extended of this VoiceRateUpdate.
        :rtype: list[VoiceRateExtended]
        """
        return self._extended

    @extended.setter
    def extended(self, extended):
        """
        Sets the extended of this VoiceRateUpdate.
        The domestic extended rates.

        :param extended: The extended of this VoiceRateUpdate.
        :type: list[VoiceRateExtended]
        """
        
        self._extended = extended

    @property
    def inbound_tolled(self):
        """
        Gets the inbound_tolled of this VoiceRateUpdate.
        The inbound tolled rate.

        :return: The inbound_tolled of this VoiceRateUpdate.
        :rtype: VoiceRate
        """
        return self._inbound_tolled

    @inbound_tolled.setter
    def inbound_tolled(self, inbound_tolled):
        """
        Sets the inbound_tolled of this VoiceRateUpdate.
        The inbound tolled rate.

        :param inbound_tolled: The inbound_tolled of this VoiceRateUpdate.
        :type: VoiceRate
        """
        
        self._inbound_tolled = inbound_tolled

    @property
    def outbound_local(self):
        """
        Gets the outbound_local of this VoiceRateUpdate.
        The outbound local rate.

        :return: The outbound_local of this VoiceRateUpdate.
        :rtype: VoiceRate
        """
        return self._outbound_local

    @outbound_local.setter
    def outbound_local(self, outbound_local):
        """
        Sets the outbound_local of this VoiceRateUpdate.
        The outbound local rate.

        :param outbound_local: The outbound_local of this VoiceRateUpdate.
        :type: VoiceRate
        """
        
        self._outbound_local = outbound_local

    @property
    def outbound_intra_state(self):
        """
        Gets the outbound_intra_state of this VoiceRateUpdate.
        The outbound intra-state rate.

        :return: The outbound_intra_state of this VoiceRateUpdate.
        :rtype: VoiceRate
        """
        return self._outbound_intra_state

    @outbound_intra_state.setter
    def outbound_intra_state(self, outbound_intra_state):
        """
        Sets the outbound_intra_state of this VoiceRateUpdate.
        The outbound intra-state rate.

        :param outbound_intra_state: The outbound_intra_state of this VoiceRateUpdate.
        :type: VoiceRate
        """
        
        self._outbound_intra_state = outbound_intra_state

    @property
    def outbound_inter_state(self):
        """
        Gets the outbound_inter_state of this VoiceRateUpdate.
        The outbound inter-state rate.

        :return: The outbound_inter_state of this VoiceRateUpdate.
        :rtype: VoiceRate
        """
        return self._outbound_inter_state

    @outbound_inter_state.setter
    def outbound_inter_state(self, outbound_inter_state):
        """
        Sets the outbound_inter_state of this VoiceRateUpdate.
        The outbound inter-state rate.

        :param outbound_inter_state: The outbound_inter_state of this VoiceRateUpdate.
        :type: VoiceRate
        """
        
        self._outbound_inter_state = outbound_inter_state

    @property
    def outbound_international(self):
        """
        Gets the outbound_international of this VoiceRateUpdate.
        The outbound international rates.

        :return: The outbound_international of this VoiceRateUpdate.
        :rtype: list[VoiceRateInternational]
        """
        return self._outbound_international

    @outbound_international.setter
    def outbound_international(self, outbound_international):
        """
        Sets the outbound_international of this VoiceRateUpdate.
        The outbound international rates.

        :param outbound_international: The outbound_international of this VoiceRateUpdate.
        :type: list[VoiceRateInternational]
        """
        
        self._outbound_international = outbound_international

    @property
    def amendment_date(self):
        """
        Gets the amendment_date of this VoiceRateUpdate.
        The date of the rate amendment. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The amendment_date of this VoiceRateUpdate.
        :rtype: datetime
        """
        return self._amendment_date

    @amendment_date.setter
    def amendment_date(self, amendment_date):
        """
        Sets the amendment_date of this VoiceRateUpdate.
        The date of the rate amendment. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param amendment_date: The amendment_date of this VoiceRateUpdate.
        :type: datetime
        """
        
        self._amendment_date = amendment_date

    @property
    def effective_date(self):
        """
        Gets the effective_date of this VoiceRateUpdate.
        The effective date of the rate amendment. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The effective_date of this VoiceRateUpdate.
        :rtype: datetime
        """
        return self._effective_date

    @effective_date.setter
    def effective_date(self, effective_date):
        """
        Sets the effective_date of this VoiceRateUpdate.
        The effective date of the rate amendment. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param effective_date: The effective_date of this VoiceRateUpdate.
        :type: datetime
        """
        
        self._effective_date = effective_date

    @property
    def self_uri(self):
        """
        Gets the self_uri of this VoiceRateUpdate.
        The URI for this object

        :return: The self_uri of this VoiceRateUpdate.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this VoiceRateUpdate.
        The URI for this object

        :param self_uri: The self_uri of this VoiceRateUpdate.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

