# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class VoiceXmlOperation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        VoiceXmlOperation - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'type': 'str',
            'method': 'str',
            'encoding': 'str',
            'description': 'str',
            'uri': 'str',
            'inputs': 'str',
            'outputs': 'str',
            'fetch_audio': 'str',
            'timeout_ms': 'int',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'type': 'type',
            'method': 'method',
            'encoding': 'encoding',
            'description': 'description',
            'uri': 'uri',
            'inputs': 'inputs',
            'outputs': 'outputs',
            'fetch_audio': 'fetchAudio',
            'timeout_ms': 'timeoutMS',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._type = None
        self._method = None
        self._encoding = None
        self._description = None
        self._uri = None
        self._inputs = None
        self._outputs = None
        self._fetch_audio = None
        self._timeout_ms = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this VoiceXmlOperation.
        The globally unique identifier for the object.

        :return: The id of this VoiceXmlOperation.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this VoiceXmlOperation.
        The globally unique identifier for the object.

        :param id: The id of this VoiceXmlOperation.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this VoiceXmlOperation.


        :return: The name of this VoiceXmlOperation.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this VoiceXmlOperation.


        :param name: The name of this VoiceXmlOperation.
        :type: str
        """
        
        self._name = name

    @property
    def type(self):
        """
        Gets the type of this VoiceXmlOperation.


        :return: The type of this VoiceXmlOperation.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this VoiceXmlOperation.


        :param type: The type of this VoiceXmlOperation.
        :type: str
        """
        allowed_values = ["GOTO", "CALL_AND_RETURN"]
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type`, must be one of {0}"
                .format(allowed_values)
            )

        self._type = type

    @property
    def method(self):
        """
        Gets the method of this VoiceXmlOperation.


        :return: The method of this VoiceXmlOperation.
        :rtype: str
        """
        return self._method

    @method.setter
    def method(self, method):
        """
        Sets the method of this VoiceXmlOperation.


        :param method: The method of this VoiceXmlOperation.
        :type: str
        """
        allowed_values = ["GET", "PUT", "POST", "DELETE"]
        if method not in allowed_values:
            raise ValueError(
                "Invalid value for `method`, must be one of {0}"
                .format(allowed_values)
            )

        self._method = method

    @property
    def encoding(self):
        """
        Gets the encoding of this VoiceXmlOperation.


        :return: The encoding of this VoiceXmlOperation.
        :rtype: str
        """
        return self._encoding

    @encoding.setter
    def encoding(self, encoding):
        """
        Sets the encoding of this VoiceXmlOperation.


        :param encoding: The encoding of this VoiceXmlOperation.
        :type: str
        """
        allowed_values = ["MULTIPART_FORM_DATA", "FORM_URL_ENCODED", "JSON"]
        if encoding not in allowed_values:
            raise ValueError(
                "Invalid value for `encoding`, must be one of {0}"
                .format(allowed_values)
            )

        self._encoding = encoding

    @property
    def description(self):
        """
        Gets the description of this VoiceXmlOperation.


        :return: The description of this VoiceXmlOperation.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this VoiceXmlOperation.


        :param description: The description of this VoiceXmlOperation.
        :type: str
        """
        
        self._description = description

    @property
    def uri(self):
        """
        Gets the uri of this VoiceXmlOperation.


        :return: The uri of this VoiceXmlOperation.
        :rtype: str
        """
        return self._uri

    @uri.setter
    def uri(self, uri):
        """
        Sets the uri of this VoiceXmlOperation.


        :param uri: The uri of this VoiceXmlOperation.
        :type: str
        """
        
        self._uri = uri

    @property
    def inputs(self):
        """
        Gets the inputs of this VoiceXmlOperation.


        :return: The inputs of this VoiceXmlOperation.
        :rtype: str
        """
        return self._inputs

    @inputs.setter
    def inputs(self, inputs):
        """
        Sets the inputs of this VoiceXmlOperation.


        :param inputs: The inputs of this VoiceXmlOperation.
        :type: str
        """
        
        self._inputs = inputs

    @property
    def outputs(self):
        """
        Gets the outputs of this VoiceXmlOperation.


        :return: The outputs of this VoiceXmlOperation.
        :rtype: str
        """
        return self._outputs

    @outputs.setter
    def outputs(self, outputs):
        """
        Sets the outputs of this VoiceXmlOperation.


        :param outputs: The outputs of this VoiceXmlOperation.
        :type: str
        """
        
        self._outputs = outputs

    @property
    def fetch_audio(self):
        """
        Gets the fetch_audio of this VoiceXmlOperation.


        :return: The fetch_audio of this VoiceXmlOperation.
        :rtype: str
        """
        return self._fetch_audio

    @fetch_audio.setter
    def fetch_audio(self, fetch_audio):
        """
        Sets the fetch_audio of this VoiceXmlOperation.


        :param fetch_audio: The fetch_audio of this VoiceXmlOperation.
        :type: str
        """
        
        self._fetch_audio = fetch_audio

    @property
    def timeout_ms(self):
        """
        Gets the timeout_ms of this VoiceXmlOperation.


        :return: The timeout_ms of this VoiceXmlOperation.
        :rtype: int
        """
        return self._timeout_ms

    @timeout_ms.setter
    def timeout_ms(self, timeout_ms):
        """
        Sets the timeout_ms of this VoiceXmlOperation.


        :param timeout_ms: The timeout_ms of this VoiceXmlOperation.
        :type: int
        """
        
        self._timeout_ms = timeout_ms

    @property
    def self_uri(self):
        """
        Gets the self_uri of this VoiceXmlOperation.
        The URI for this object

        :return: The self_uri of this VoiceXmlOperation.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this VoiceXmlOperation.
        The URI for this object

        :param self_uri: The self_uri of this VoiceXmlOperation.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

