# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class VoicemailMessage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        VoicemailMessage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'conversation': 'Conversation',
            'read': 'bool',
            'audio_recording_duration_seconds': 'int',
            'audio_recording_size_bytes': 'int',
            'created_date': 'datetime',
            'modified_date': 'datetime',
            'caller_address': 'str',
            'caller_name': 'str',
            'caller_user': 'User',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'conversation': 'conversation',
            'read': 'read',
            'audio_recording_duration_seconds': 'audioRecordingDurationSeconds',
            'audio_recording_size_bytes': 'audioRecordingSizeBytes',
            'created_date': 'createdDate',
            'modified_date': 'modifiedDate',
            'caller_address': 'callerAddress',
            'caller_name': 'callerName',
            'caller_user': 'callerUser',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._conversation = None
        self._read = False
        self._audio_recording_duration_seconds = None
        self._audio_recording_size_bytes = None
        self._created_date = None
        self._modified_date = None
        self._caller_address = None
        self._caller_name = None
        self._caller_user = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this VoicemailMessage.
        The globally unique identifier for the object.

        :return: The id of this VoicemailMessage.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this VoicemailMessage.
        The globally unique identifier for the object.

        :param id: The id of this VoicemailMessage.
        :type: str
        """
        
        self._id = id

    @property
    def conversation(self):
        """
        Gets the conversation of this VoicemailMessage.


        :return: The conversation of this VoicemailMessage.
        :rtype: Conversation
        """
        return self._conversation

    @conversation.setter
    def conversation(self, conversation):
        """
        Sets the conversation of this VoicemailMessage.


        :param conversation: The conversation of this VoicemailMessage.
        :type: Conversation
        """
        
        self._conversation = conversation

    @property
    def read(self):
        """
        Gets the read of this VoicemailMessage.


        :return: The read of this VoicemailMessage.
        :rtype: bool
        """
        return self._read

    @read.setter
    def read(self, read):
        """
        Sets the read of this VoicemailMessage.


        :param read: The read of this VoicemailMessage.
        :type: bool
        """
        
        self._read = read

    @property
    def audio_recording_duration_seconds(self):
        """
        Gets the audio_recording_duration_seconds of this VoicemailMessage.


        :return: The audio_recording_duration_seconds of this VoicemailMessage.
        :rtype: int
        """
        return self._audio_recording_duration_seconds

    @audio_recording_duration_seconds.setter
    def audio_recording_duration_seconds(self, audio_recording_duration_seconds):
        """
        Sets the audio_recording_duration_seconds of this VoicemailMessage.


        :param audio_recording_duration_seconds: The audio_recording_duration_seconds of this VoicemailMessage.
        :type: int
        """
        
        self._audio_recording_duration_seconds = audio_recording_duration_seconds

    @property
    def audio_recording_size_bytes(self):
        """
        Gets the audio_recording_size_bytes of this VoicemailMessage.


        :return: The audio_recording_size_bytes of this VoicemailMessage.
        :rtype: int
        """
        return self._audio_recording_size_bytes

    @audio_recording_size_bytes.setter
    def audio_recording_size_bytes(self, audio_recording_size_bytes):
        """
        Sets the audio_recording_size_bytes of this VoicemailMessage.


        :param audio_recording_size_bytes: The audio_recording_size_bytes of this VoicemailMessage.
        :type: int
        """
        
        self._audio_recording_size_bytes = audio_recording_size_bytes

    @property
    def created_date(self):
        """
        Gets the created_date of this VoicemailMessage.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The created_date of this VoicemailMessage.
        :rtype: datetime
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date):
        """
        Sets the created_date of this VoicemailMessage.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param created_date: The created_date of this VoicemailMessage.
        :type: datetime
        """
        
        self._created_date = created_date

    @property
    def modified_date(self):
        """
        Gets the modified_date of this VoicemailMessage.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The modified_date of this VoicemailMessage.
        :rtype: datetime
        """
        return self._modified_date

    @modified_date.setter
    def modified_date(self, modified_date):
        """
        Sets the modified_date of this VoicemailMessage.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param modified_date: The modified_date of this VoicemailMessage.
        :type: datetime
        """
        
        self._modified_date = modified_date

    @property
    def caller_address(self):
        """
        Gets the caller_address of this VoicemailMessage.


        :return: The caller_address of this VoicemailMessage.
        :rtype: str
        """
        return self._caller_address

    @caller_address.setter
    def caller_address(self, caller_address):
        """
        Sets the caller_address of this VoicemailMessage.


        :param caller_address: The caller_address of this VoicemailMessage.
        :type: str
        """
        
        self._caller_address = caller_address

    @property
    def caller_name(self):
        """
        Gets the caller_name of this VoicemailMessage.


        :return: The caller_name of this VoicemailMessage.
        :rtype: str
        """
        return self._caller_name

    @caller_name.setter
    def caller_name(self, caller_name):
        """
        Sets the caller_name of this VoicemailMessage.


        :param caller_name: The caller_name of this VoicemailMessage.
        :type: str
        """
        
        self._caller_name = caller_name

    @property
    def caller_user(self):
        """
        Gets the caller_user of this VoicemailMessage.


        :return: The caller_user of this VoicemailMessage.
        :rtype: User
        """
        return self._caller_user

    @caller_user.setter
    def caller_user(self, caller_user):
        """
        Sets the caller_user of this VoicemailMessage.


        :param caller_user: The caller_user of this VoicemailMessage.
        :type: User
        """
        
        self._caller_user = caller_user

    @property
    def self_uri(self):
        """
        Gets the self_uri of this VoicemailMessage.
        The URI for this object

        :return: The self_uri of this VoicemailMessage.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this VoicemailMessage.
        The URI for this object

        :param self_uri: The self_uri of this VoicemailMessage.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

