# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class Waypoint(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Waypoint - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'target_scene': 'Scene',
            'rotation_y': 'float',
            'rotation_x': 'float',
            'scene_rotation_y': 'float',
            'distance': 'float',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'target_scene': 'targetScene',
            'rotation_y': 'rotationY',
            'rotation_x': 'rotationX',
            'scene_rotation_y': 'sceneRotationY',
            'distance': 'distance',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._target_scene = None
        self._rotation_y = None
        self._rotation_x = None
        self._scene_rotation_y = None
        self._distance = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this Waypoint.
        The globally unique identifier for the object.

        :return: The id of this Waypoint.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Waypoint.
        The globally unique identifier for the object.

        :param id: The id of this Waypoint.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Waypoint.


        :return: The name of this Waypoint.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Waypoint.


        :param name: The name of this Waypoint.
        :type: str
        """
        
        self._name = name

    @property
    def target_scene(self):
        """
        Gets the target_scene of this Waypoint.


        :return: The target_scene of this Waypoint.
        :rtype: Scene
        """
        return self._target_scene

    @target_scene.setter
    def target_scene(self, target_scene):
        """
        Sets the target_scene of this Waypoint.


        :param target_scene: The target_scene of this Waypoint.
        :type: Scene
        """
        
        self._target_scene = target_scene

    @property
    def rotation_y(self):
        """
        Gets the rotation_y of this Waypoint.


        :return: The rotation_y of this Waypoint.
        :rtype: float
        """
        return self._rotation_y

    @rotation_y.setter
    def rotation_y(self, rotation_y):
        """
        Sets the rotation_y of this Waypoint.


        :param rotation_y: The rotation_y of this Waypoint.
        :type: float
        """
        
        self._rotation_y = rotation_y

    @property
    def rotation_x(self):
        """
        Gets the rotation_x of this Waypoint.


        :return: The rotation_x of this Waypoint.
        :rtype: float
        """
        return self._rotation_x

    @rotation_x.setter
    def rotation_x(self, rotation_x):
        """
        Sets the rotation_x of this Waypoint.


        :param rotation_x: The rotation_x of this Waypoint.
        :type: float
        """
        
        self._rotation_x = rotation_x

    @property
    def scene_rotation_y(self):
        """
        Gets the scene_rotation_y of this Waypoint.


        :return: The scene_rotation_y of this Waypoint.
        :rtype: float
        """
        return self._scene_rotation_y

    @scene_rotation_y.setter
    def scene_rotation_y(self, scene_rotation_y):
        """
        Sets the scene_rotation_y of this Waypoint.


        :param scene_rotation_y: The scene_rotation_y of this Waypoint.
        :type: float
        """
        
        self._scene_rotation_y = scene_rotation_y

    @property
    def distance(self):
        """
        Gets the distance of this Waypoint.


        :return: The distance of this Waypoint.
        :rtype: float
        """
        return self._distance

    @distance.setter
    def distance(self, distance):
        """
        Sets the distance of this Waypoint.


        :param distance: The distance of this Waypoint.
        :type: float
        """
        
        self._distance = distance

    @property
    def self_uri(self):
        """
        Gets the self_uri of this Waypoint.
        The URI for this object

        :return: The self_uri of this Waypoint.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this Waypoint.
        The URI for this object

        :param self_uri: The self_uri of this Waypoint.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

