# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class WorkItemCache(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        WorkItemCache - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'work_item_exec_id': 'str',
            'save_time': 'datetime',
            'save_user': 'User',
            'save_comment': 'str',
            'data_items': 'list[DataItem]'
        }

        self.attribute_map = {
            'work_item_exec_id': 'workItemExecId',
            'save_time': 'saveTime',
            'save_user': 'saveUser',
            'save_comment': 'saveComment',
            'data_items': 'dataItems'
        }

        self._work_item_exec_id = None
        self._save_time = None
        self._save_user = None
        self._save_comment = None
        self._data_items = None

    @property
    def work_item_exec_id(self):
        """
        Gets the work_item_exec_id of this WorkItemCache.
        The workItem instance ID that owns this cache.

        :return: The work_item_exec_id of this WorkItemCache.
        :rtype: str
        """
        return self._work_item_exec_id

    @work_item_exec_id.setter
    def work_item_exec_id(self, work_item_exec_id):
        """
        Sets the work_item_exec_id of this WorkItemCache.
        The workItem instance ID that owns this cache.

        :param work_item_exec_id: The work_item_exec_id of this WorkItemCache.
        :type: str
        """
        
        self._work_item_exec_id = work_item_exec_id

    @property
    def save_time(self):
        """
        Gets the save_time of this WorkItemCache.
        The time that the workItem cache was last saved. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The save_time of this WorkItemCache.
        :rtype: datetime
        """
        return self._save_time

    @save_time.setter
    def save_time(self, save_time):
        """
        Sets the save_time of this WorkItemCache.
        The time that the workItem cache was last saved. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param save_time: The save_time of this WorkItemCache.
        :type: datetime
        """
        
        self._save_time = save_time

    @property
    def save_user(self):
        """
        Gets the save_user of this WorkItemCache.
        The user that last saved the workItem cache.

        :return: The save_user of this WorkItemCache.
        :rtype: User
        """
        return self._save_user

    @save_user.setter
    def save_user(self, save_user):
        """
        Sets the save_user of this WorkItemCache.
        The user that last saved the workItem cache.

        :param save_user: The save_user of this WorkItemCache.
        :type: User
        """
        
        self._save_user = save_user

    @property
    def save_comment(self):
        """
        Gets the save_comment of this WorkItemCache.
        An optional comment made during the last save

        :return: The save_comment of this WorkItemCache.
        :rtype: str
        """
        return self._save_comment

    @save_comment.setter
    def save_comment(self, save_comment):
        """
        Sets the save_comment of this WorkItemCache.
        An optional comment made during the last save

        :param save_comment: The save_comment of this WorkItemCache.
        :type: str
        """
        
        self._save_comment = save_comment

    @property
    def data_items(self):
        """
        Gets the data_items of this WorkItemCache.
        The data items that are present within the cache.

        :return: The data_items of this WorkItemCache.
        :rtype: list[DataItem]
        """
        return self._data_items

    @data_items.setter
    def data_items(self, data_items):
        """
        Sets the data_items of this WorkItemCache.
        The data items that are present within the cache.

        :param data_items: The data_items of this WorkItemCache.
        :type: list[DataItem]
        """
        
        self._data_items = data_items

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

