# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class WorkItemCommandGroup(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        WorkItemCommandGroup - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'category': 'str',
            'default_command_id': 'str',
            'commands': 'list[WorkItemCommand]'
        }

        self.attribute_map = {
            'category': 'category',
            'default_command_id': 'defaultCommandId',
            'commands': 'commands'
        }

        self._category = None
        self._default_command_id = None
        self._commands = None

    @property
    def category(self):
        """
        Gets the category of this WorkItemCommandGroup.


        :return: The category of this WorkItemCommandGroup.
        :rtype: str
        """
        return self._category

    @category.setter
    def category(self, category):
        """
        Sets the category of this WorkItemCommandGroup.


        :param category: The category of this WorkItemCommandGroup.
        :type: str
        """
        
        self._category = category

    @property
    def default_command_id(self):
        """
        Gets the default_command_id of this WorkItemCommandGroup.


        :return: The default_command_id of this WorkItemCommandGroup.
        :rtype: str
        """
        return self._default_command_id

    @default_command_id.setter
    def default_command_id(self, default_command_id):
        """
        Sets the default_command_id of this WorkItemCommandGroup.


        :param default_command_id: The default_command_id of this WorkItemCommandGroup.
        :type: str
        """
        
        self._default_command_id = default_command_id

    @property
    def commands(self):
        """
        Gets the commands of this WorkItemCommandGroup.


        :return: The commands of this WorkItemCommandGroup.
        :rtype: list[WorkItemCommand]
        """
        return self._commands

    @commands.setter
    def commands(self, commands):
        """
        Sets the commands of this WorkItemCommandGroup.


        :param commands: The commands of this WorkItemCommandGroup.
        :type: list[WorkItemCommand]
        """
        
        self._commands = commands

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

