# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class WorkItemDefinition(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        WorkItemDefinition - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'command_categories': 'list[WorkItemCommandGroup]',
            'form': 'Form'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'command_categories': 'commandCategories',
            'form': 'form'
        }

        self._id = None
        self._name = None
        self._command_categories = None
        self._form = None

    @property
    def id(self):
        """
        Gets the id of this WorkItemDefinition.
        The configuration ID for this workItem

        :return: The id of this WorkItemDefinition.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this WorkItemDefinition.
        The configuration ID for this workItem

        :param id: The id of this WorkItemDefinition.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this WorkItemDefinition.


        :return: The name of this WorkItemDefinition.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this WorkItemDefinition.


        :param name: The name of this WorkItemDefinition.
        :type: str
        """
        
        self._name = name

    @property
    def command_categories(self):
        """
        Gets the command_categories of this WorkItemDefinition.
        The commands that can be performed on this work item

        :return: The command_categories of this WorkItemDefinition.
        :rtype: list[WorkItemCommandGroup]
        """
        return self._command_categories

    @command_categories.setter
    def command_categories(self, command_categories):
        """
        Sets the command_categories of this WorkItemDefinition.
        The commands that can be performed on this work item

        :param command_categories: The command_categories of this WorkItemDefinition.
        :type: list[WorkItemCommandGroup]
        """
        
        self._command_categories = command_categories

    @property
    def form(self):
        """
        Gets the form of this WorkItemDefinition.
        The simple work item form containging the control to present for this work item

        :return: The form of this WorkItemDefinition.
        :rtype: Form
        """
        return self._form

    @form.setter
    def form(self, form):
        """
        Sets the form of this WorkItemDefinition.
        The simple work item form containging the control to present for this work item

        :param form: The form of this WorkItemDefinition.
        :type: Form
        """
        
        self._form = form

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

