# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class WorkItemDetails(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        WorkItemDetails - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'work_item_definition': 'WorkItemDefinition',
            'flow_exec_id': 'FlowExecId',
            'flow_config_id': 'FlowConfigId',
            'flow_create_time': 'datetime',
            'create_time': 'datetime',
            'owner': 'User',
            'offered_to_users': 'list[User]',
            'offered_to_queues': 'list[Queue]',
            'title': 'str',
            'subtitle': 'str',
            'associated_documents': 'list[AssociatedDocument]',
            'available_actions': 'WorkItemActions',
            'data_value_info': 'DataValueInfo',
            'work_item_cache': 'WorkItemCache',
            'last_offered_time': 'datetime',
            'last_ownership_update_time': 'datetime',
            'current_task_start_time': 'datetime',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'work_item_definition': 'workItemDefinition',
            'flow_exec_id': 'flowExecId',
            'flow_config_id': 'flowConfigId',
            'flow_create_time': 'flowCreateTime',
            'create_time': 'createTime',
            'owner': 'owner',
            'offered_to_users': 'offeredToUsers',
            'offered_to_queues': 'offeredToQueues',
            'title': 'title',
            'subtitle': 'subtitle',
            'associated_documents': 'associatedDocuments',
            'available_actions': 'availableActions',
            'data_value_info': 'dataValueInfo',
            'work_item_cache': 'workItemCache',
            'last_offered_time': 'lastOfferedTime',
            'last_ownership_update_time': 'lastOwnershipUpdateTime',
            'current_task_start_time': 'currentTaskStartTime',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._work_item_definition = None
        self._flow_exec_id = None
        self._flow_config_id = None
        self._flow_create_time = None
        self._create_time = None
        self._owner = None
        self._offered_to_users = None
        self._offered_to_queues = None
        self._title = None
        self._subtitle = None
        self._associated_documents = None
        self._available_actions = None
        self._data_value_info = None
        self._work_item_cache = None
        self._last_offered_time = None
        self._last_ownership_update_time = None
        self._current_task_start_time = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this WorkItemDetails.
        The globally unique identifier for the object.

        :return: The id of this WorkItemDetails.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this WorkItemDetails.
        The globally unique identifier for the object.

        :param id: The id of this WorkItemDetails.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this WorkItemDetails.


        :return: The name of this WorkItemDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this WorkItemDetails.


        :param name: The name of this WorkItemDetails.
        :type: str
        """
        
        self._name = name

    @property
    def work_item_definition(self):
        """
        Gets the work_item_definition of this WorkItemDetails.


        :return: The work_item_definition of this WorkItemDetails.
        :rtype: WorkItemDefinition
        """
        return self._work_item_definition

    @work_item_definition.setter
    def work_item_definition(self, work_item_definition):
        """
        Sets the work_item_definition of this WorkItemDetails.


        :param work_item_definition: The work_item_definition of this WorkItemDetails.
        :type: WorkItemDefinition
        """
        
        self._work_item_definition = work_item_definition

    @property
    def flow_exec_id(self):
        """
        Gets the flow_exec_id of this WorkItemDetails.
        The flow instance ID that created this WorkItem

        :return: The flow_exec_id of this WorkItemDetails.
        :rtype: FlowExecId
        """
        return self._flow_exec_id

    @flow_exec_id.setter
    def flow_exec_id(self, flow_exec_id):
        """
        Sets the flow_exec_id of this WorkItemDetails.
        The flow instance ID that created this WorkItem

        :param flow_exec_id: The flow_exec_id of this WorkItemDetails.
        :type: FlowExecId
        """
        
        self._flow_exec_id = flow_exec_id

    @property
    def flow_config_id(self):
        """
        Gets the flow_config_id of this WorkItemDetails.
        The flow config ID that this workitem was created from.

        :return: The flow_config_id of this WorkItemDetails.
        :rtype: FlowConfigId
        """
        return self._flow_config_id

    @flow_config_id.setter
    def flow_config_id(self, flow_config_id):
        """
        Sets the flow_config_id of this WorkItemDetails.
        The flow config ID that this workitem was created from.

        :param flow_config_id: The flow_config_id of this WorkItemDetails.
        :type: FlowConfigId
        """
        
        self._flow_config_id = flow_config_id

    @property
    def flow_create_time(self):
        """
        Gets the flow_create_time of this WorkItemDetails.
        The time the flow was started. (that created this workitem). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The flow_create_time of this WorkItemDetails.
        :rtype: datetime
        """
        return self._flow_create_time

    @flow_create_time.setter
    def flow_create_time(self, flow_create_time):
        """
        Sets the flow_create_time of this WorkItemDetails.
        The time the flow was started. (that created this workitem). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param flow_create_time: The flow_create_time of this WorkItemDetails.
        :type: datetime
        """
        
        self._flow_create_time = flow_create_time

    @property
    def create_time(self):
        """
        Gets the create_time of this WorkItemDetails.
        The time this workitem was started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The create_time of this WorkItemDetails.
        :rtype: datetime
        """
        return self._create_time

    @create_time.setter
    def create_time(self, create_time):
        """
        Sets the create_time of this WorkItemDetails.
        The time this workitem was started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param create_time: The create_time of this WorkItemDetails.
        :type: datetime
        """
        
        self._create_time = create_time

    @property
    def owner(self):
        """
        Gets the owner of this WorkItemDetails.
        The user currently working on/has responsibility for this WorkItem.  May be null if no owner.

        :return: The owner of this WorkItemDetails.
        :rtype: User
        """
        return self._owner

    @owner.setter
    def owner(self, owner):
        """
        Sets the owner of this WorkItemDetails.
        The user currently working on/has responsibility for this WorkItem.  May be null if no owner.

        :param owner: The owner of this WorkItemDetails.
        :type: User
        """
        
        self._owner = owner

    @property
    def offered_to_users(self):
        """
        Gets the offered_to_users of this WorkItemDetails.
        List of users that this workItem is offered to.  May be null if only offered to queues.

        :return: The offered_to_users of this WorkItemDetails.
        :rtype: list[User]
        """
        return self._offered_to_users

    @offered_to_users.setter
    def offered_to_users(self, offered_to_users):
        """
        Sets the offered_to_users of this WorkItemDetails.
        List of users that this workItem is offered to.  May be null if only offered to queues.

        :param offered_to_users: The offered_to_users of this WorkItemDetails.
        :type: list[User]
        """
        
        self._offered_to_users = offered_to_users

    @property
    def offered_to_queues(self):
        """
        Gets the offered_to_queues of this WorkItemDetails.
        List of queues that this workItem is offered to.  May be null if only offered to users.

        :return: The offered_to_queues of this WorkItemDetails.
        :rtype: list[Queue]
        """
        return self._offered_to_queues

    @offered_to_queues.setter
    def offered_to_queues(self, offered_to_queues):
        """
        Sets the offered_to_queues of this WorkItemDetails.
        List of queues that this workItem is offered to.  May be null if only offered to users.

        :param offered_to_queues: The offered_to_queues of this WorkItemDetails.
        :type: list[Queue]
        """
        
        self._offered_to_queues = offered_to_queues

    @property
    def title(self):
        """
        Gets the title of this WorkItemDetails.
        The work item title

        :return: The title of this WorkItemDetails.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this WorkItemDetails.
        The work item title

        :param title: The title of this WorkItemDetails.
        :type: str
        """
        
        self._title = title

    @property
    def subtitle(self):
        """
        Gets the subtitle of this WorkItemDetails.
        The work item's subtitle - 2nd line/description

        :return: The subtitle of this WorkItemDetails.
        :rtype: str
        """
        return self._subtitle

    @subtitle.setter
    def subtitle(self, subtitle):
        """
        Sets the subtitle of this WorkItemDetails.
        The work item's subtitle - 2nd line/description

        :param subtitle: The subtitle of this WorkItemDetails.
        :type: str
        """
        
        self._subtitle = subtitle

    @property
    def associated_documents(self):
        """
        Gets the associated_documents of this WorkItemDetails.
        The documents associated with this workitem

        :return: The associated_documents of this WorkItemDetails.
        :rtype: list[AssociatedDocument]
        """
        return self._associated_documents

    @associated_documents.setter
    def associated_documents(self, associated_documents):
        """
        Sets the associated_documents of this WorkItemDetails.
        The documents associated with this workitem

        :param associated_documents: The associated_documents of this WorkItemDetails.
        :type: list[AssociatedDocument]
        """
        
        self._associated_documents = associated_documents

    @property
    def available_actions(self):
        """
        Gets the available_actions of this WorkItemDetails.
        The actions that the user can take on this workitem (submit, transfer, etc).

        :return: The available_actions of this WorkItemDetails.
        :rtype: WorkItemActions
        """
        return self._available_actions

    @available_actions.setter
    def available_actions(self, available_actions):
        """
        Sets the available_actions of this WorkItemDetails.
        The actions that the user can take on this workitem (submit, transfer, etc).

        :param available_actions: The available_actions of this WorkItemDetails.
        :type: WorkItemActions
        """
        
        self._available_actions = available_actions

    @property
    def data_value_info(self):
        """
        Gets the data_value_info of this WorkItemDetails.
        The data items that provide values for any work item form elements, if applicable.

        :return: The data_value_info of this WorkItemDetails.
        :rtype: DataValueInfo
        """
        return self._data_value_info

    @data_value_info.setter
    def data_value_info(self, data_value_info):
        """
        Sets the data_value_info of this WorkItemDetails.
        The data items that provide values for any work item form elements, if applicable.

        :param data_value_info: The data_value_info of this WorkItemDetails.
        :type: DataValueInfo
        """
        
        self._data_value_info = data_value_info

    @property
    def work_item_cache(self):
        """
        Gets the work_item_cache of this WorkItemDetails.
        The data items in the current work item cache, if one exists.

        :return: The work_item_cache of this WorkItemDetails.
        :rtype: WorkItemCache
        """
        return self._work_item_cache

    @work_item_cache.setter
    def work_item_cache(self, work_item_cache):
        """
        Sets the work_item_cache of this WorkItemDetails.
        The data items in the current work item cache, if one exists.

        :param work_item_cache: The work_item_cache of this WorkItemDetails.
        :type: WorkItemCache
        """
        
        self._work_item_cache = work_item_cache

    @property
    def last_offered_time(self):
        """
        Gets the last_offered_time of this WorkItemDetails.
        The time this work item was last offered to a user or queue. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The last_offered_time of this WorkItemDetails.
        :rtype: datetime
        """
        return self._last_offered_time

    @last_offered_time.setter
    def last_offered_time(self, last_offered_time):
        """
        Sets the last_offered_time of this WorkItemDetails.
        The time this work item was last offered to a user or queue. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param last_offered_time: The last_offered_time of this WorkItemDetails.
        :type: datetime
        """
        
        self._last_offered_time = last_offered_time

    @property
    def last_ownership_update_time(self):
        """
        Gets the last_ownership_update_time of this WorkItemDetails.
        The most recent time a user assumed ownership of a work item. This may be blank if the work item has no owner. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The last_ownership_update_time of this WorkItemDetails.
        :rtype: datetime
        """
        return self._last_ownership_update_time

    @last_ownership_update_time.setter
    def last_ownership_update_time(self, last_ownership_update_time):
        """
        Sets the last_ownership_update_time of this WorkItemDetails.
        The most recent time a user assumed ownership of a work item. This may be blank if the work item has no owner. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param last_ownership_update_time: The last_ownership_update_time of this WorkItemDetails.
        :type: datetime
        """
        
        self._last_ownership_update_time = last_ownership_update_time

    @property
    def current_task_start_time(self):
        """
        Gets the current_task_start_time of this WorkItemDetails.
        This is the time when the current task that started the work item was started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The current_task_start_time of this WorkItemDetails.
        :rtype: datetime
        """
        return self._current_task_start_time

    @current_task_start_time.setter
    def current_task_start_time(self, current_task_start_time):
        """
        Sets the current_task_start_time of this WorkItemDetails.
        This is the time when the current task that started the work item was started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param current_task_start_time: The current_task_start_time of this WorkItemDetails.
        :type: datetime
        """
        
        self._current_task_start_time = current_task_start_time

    @property
    def self_uri(self):
        """
        Gets the self_uri of this WorkItemDetails.
        The URI for this object

        :return: The self_uri of this WorkItemDetails.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this WorkItemDetails.
        The URI for this object

        :param self_uri: The self_uri of this WorkItemDetails.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

