# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class WorkItemSubmitRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        WorkItemSubmitRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'command_id': 'str',
            'data_items': 'list[DataItem]'
        }

        self.attribute_map = {
            'command_id': 'commandId',
            'data_items': 'dataItems'
        }

        self._command_id = None
        self._data_items = None

    @property
    def command_id(self):
        """
        Gets the command_id of this WorkItemSubmitRequest.
        The command associated with the submit request. Often it is the button pressed on the user interface.

        :return: The command_id of this WorkItemSubmitRequest.
        :rtype: str
        """
        return self._command_id

    @command_id.setter
    def command_id(self, command_id):
        """
        Sets the command_id of this WorkItemSubmitRequest.
        The command associated with the submit request. Often it is the button pressed on the user interface.

        :param command_id: The command_id of this WorkItemSubmitRequest.
        :type: str
        """
        
        self._command_id = command_id

    @property
    def data_items(self):
        """
        Gets the data_items of this WorkItemSubmitRequest.
        The data items that should be a part of the submit request.

        :return: The data_items of this WorkItemSubmitRequest.
        :rtype: list[DataItem]
        """
        return self._data_items

    @data_items.setter
    def data_items(self, data_items):
        """
        Sets the data_items of this WorkItemSubmitRequest.
        The data items that should be a part of the submit request.

        :param data_items: The data_items of this WorkItemSubmitRequest.
        :type: list[DataItem]
        """
        
        self._data_items = data_items

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

