# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class WorkItemTransferRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        WorkItemTransferRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'transfer_target_type': 'str',
            'transfer_target': 'str'
        }

        self.attribute_map = {
            'transfer_target_type': 'transferTargetType',
            'transfer_target': 'transferTarget'
        }

        self._transfer_target_type = None
        self._transfer_target = None

    @property
    def transfer_target_type(self):
        """
        Gets the transfer_target_type of this WorkItemTransferRequest.
        The type of the transferTarget, indicating whether you want to transfer to a User, or a Queue, etc.

        :return: The transfer_target_type of this WorkItemTransferRequest.
        :rtype: str
        """
        return self._transfer_target_type

    @transfer_target_type.setter
    def transfer_target_type(self, transfer_target_type):
        """
        Sets the transfer_target_type of this WorkItemTransferRequest.
        The type of the transferTarget, indicating whether you want to transfer to a User, or a Queue, etc.

        :param transfer_target_type: The transfer_target_type of this WorkItemTransferRequest.
        :type: str
        """
        allowed_values = ["USER", "QUEUE"]
        if transfer_target_type not in allowed_values:
            raise ValueError(
                "Invalid value for `transfer_target_type`, must be one of {0}"
                .format(allowed_values)
            )

        self._transfer_target_type = transfer_target_type

    @property
    def transfer_target(self):
        """
        Gets the transfer_target of this WorkItemTransferRequest.
        The destination to where the work item should be transferred.

        :return: The transfer_target of this WorkItemTransferRequest.
        :rtype: str
        """
        return self._transfer_target

    @transfer_target.setter
    def transfer_target(self, transfer_target):
        """
        Sets the transfer_target of this WorkItemTransferRequest.
        The destination to where the work item should be transferred.

        :param transfer_target: The transfer_target of this WorkItemTransferRequest.
        :type: str
        """
        
        self._transfer_target = transfer_target

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

