# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class WorkspaceMember(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        WorkspaceMember - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'workspace': 'UriReference',
            'member_type': 'str',
            'member': 'UriReference',
            'user': 'User',
            'group': 'Group',
            'security_profile': 'SecurityProfile',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'workspace': 'workspace',
            'member_type': 'memberType',
            'member': 'member',
            'user': 'user',
            'group': 'group',
            'security_profile': 'securityProfile',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._workspace = None
        self._member_type = None
        self._member = None
        self._user = None
        self._group = None
        self._security_profile = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this WorkspaceMember.
        The globally unique identifier for the object.

        :return: The id of this WorkspaceMember.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this WorkspaceMember.
        The globally unique identifier for the object.

        :param id: The id of this WorkspaceMember.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this WorkspaceMember.


        :return: The name of this WorkspaceMember.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this WorkspaceMember.


        :param name: The name of this WorkspaceMember.
        :type: str
        """
        
        self._name = name

    @property
    def workspace(self):
        """
        Gets the workspace of this WorkspaceMember.


        :return: The workspace of this WorkspaceMember.
        :rtype: UriReference
        """
        return self._workspace

    @workspace.setter
    def workspace(self, workspace):
        """
        Sets the workspace of this WorkspaceMember.


        :param workspace: The workspace of this WorkspaceMember.
        :type: UriReference
        """
        
        self._workspace = workspace

    @property
    def member_type(self):
        """
        Gets the member_type of this WorkspaceMember.


        :return: The member_type of this WorkspaceMember.
        :rtype: str
        """
        return self._member_type

    @member_type.setter
    def member_type(self, member_type):
        """
        Sets the member_type of this WorkspaceMember.


        :param member_type: The member_type of this WorkspaceMember.
        :type: str
        """
        allowed_values = ["USER", "GROUP"]
        if member_type not in allowed_values:
            raise ValueError(
                "Invalid value for `member_type`, must be one of {0}"
                .format(allowed_values)
            )

        self._member_type = member_type

    @property
    def member(self):
        """
        Gets the member of this WorkspaceMember.


        :return: The member of this WorkspaceMember.
        :rtype: UriReference
        """
        return self._member

    @member.setter
    def member(self, member):
        """
        Sets the member of this WorkspaceMember.


        :param member: The member of this WorkspaceMember.
        :type: UriReference
        """
        
        self._member = member

    @property
    def user(self):
        """
        Gets the user of this WorkspaceMember.


        :return: The user of this WorkspaceMember.
        :rtype: User
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this WorkspaceMember.


        :param user: The user of this WorkspaceMember.
        :type: User
        """
        
        self._user = user

    @property
    def group(self):
        """
        Gets the group of this WorkspaceMember.


        :return: The group of this WorkspaceMember.
        :rtype: Group
        """
        return self._group

    @group.setter
    def group(self, group):
        """
        Sets the group of this WorkspaceMember.


        :param group: The group of this WorkspaceMember.
        :type: Group
        """
        
        self._group = group

    @property
    def security_profile(self):
        """
        Gets the security_profile of this WorkspaceMember.


        :return: The security_profile of this WorkspaceMember.
        :rtype: SecurityProfile
        """
        return self._security_profile

    @security_profile.setter
    def security_profile(self, security_profile):
        """
        Sets the security_profile of this WorkspaceMember.


        :param security_profile: The security_profile of this WorkspaceMember.
        :type: SecurityProfile
        """
        
        self._security_profile = security_profile

    @property
    def self_uri(self):
        """
        Gets the self_uri of this WorkspaceMember.
        The URI for this object

        :return: The self_uri of this WorkspaceMember.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this WorkspaceMember.
        The URI for this object

        :param self_uri: The self_uri of this WorkspaceMember.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

