# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class XlsxSchema(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        XlsxSchema - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'sheet_schemas': 'list[SheetSchema]',
            'name': 'str',
            'carrier_id': 'str'
        }

        self.attribute_map = {
            'sheet_schemas': 'SheetSchemas',
            'name': 'Name',
            'carrier_id': 'CarrierId'
        }

        self._sheet_schemas = None
        self._name = None
        self._carrier_id = None

    @property
    def sheet_schemas(self):
        """
        Gets the sheet_schemas of this XlsxSchema.
        A list of all the schemas for a XLSX file. Each schema represents a different sheet's schema.

        :return: The sheet_schemas of this XlsxSchema.
        :rtype: list[SheetSchema]
        """
        return self._sheet_schemas

    @sheet_schemas.setter
    def sheet_schemas(self, sheet_schemas):
        """
        Sets the sheet_schemas of this XlsxSchema.
        A list of all the schemas for a XLSX file. Each schema represents a different sheet's schema.

        :param sheet_schemas: The sheet_schemas of this XlsxSchema.
        :type: list[SheetSchema]
        """
        
        self._sheet_schemas = sheet_schemas

    @property
    def name(self):
        """
        Gets the name of this XlsxSchema.
        Human readable name for schema.

        :return: The name of this XlsxSchema.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this XlsxSchema.
        Human readable name for schema.

        :param name: The name of this XlsxSchema.
        :type: str
        """
        
        self._name = name

    @property
    def carrier_id(self):
        """
        Gets the carrier_id of this XlsxSchema.
        Carrier ID associated with this CSV schema.

        :return: The carrier_id of this XlsxSchema.
        :rtype: str
        """
        return self._carrier_id

    @carrier_id.setter
    def carrier_id(self, carrier_id):
        """
        Sets the carrier_id of this XlsxSchema.
        Carrier ID associated with this CSV schema.

        :param carrier_id: The carrier_id of this XlsxSchema.
        :type: str
        """
        
        self._carrier_id = carrier_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

