# Security Policy

## Supported Versions

We release patches and updates to ensure the security of our software. Below is a list of supported versions:

| Version | Supported          |
| ------- | ------------------ |
| 3.x.x   | ✅  |
| < 3.0   | ❌                 |

## Reporting a Vulnerability

If you discover a security vulnerability in this repository, please report it to us directly. We take security issues seriously and will respond promptly to address the issue.

To report a vulnerability:

1. **Email**: Please send the details to [engineers@safetycli.com](mailto:engineers@safetycli.com). Include as much information as possible to help us understand the nature of the vulnerability and how it can be reproduced.

2. **Bug Bounty Program**: We offer a bug bounty program for qualifying vulnerabilities. Detailed information about the program, including eligibility and rewards, can be found on our [Bug Bounty Program page](https://safetycli.com/resources/bug-bounty).

## Security Best Practices

We encourage our users to follow these best practices to ensure the security of their deployments:

- Always run the latest version of the software to benefit from security updates.
- Regularly review and update dependencies to avoid known vulnerabilities.
- Consider using containerization and sandboxing techniques to isolate the software from other parts of your system.

## Code of Conduct

Please note that all participants in our community are expected to adhere to our [Code of Conduct](./CODE_OF_CONDUCT.md). This includes those participating in our security bounty program.

Thank you for helping to keep our project secure!
