# textual-textarea CHANGELOG

All notable changes to this project will be documented in this file.

## [Unreleased]

## [0.16.0] - 2025-10-20

- **Breaking:** drops support for Python 3.9.
- **Breaking:** drops support for Textual &lt; 6.3.
- Adds support for Python 3.14.

### Development

- This project is now built using uv.

## [0.15.0] - 2024-12-19

- **Breaking:** changes function return signature `query_syntax_tree`.
- **Breaking:** drops support for Python 3.8.
- **Breaking:** drops support for Pygments themes.
- Adds support for Python 3.13.
- Adds support for Textual app themes, including syntax highlighting using the theme colors.
- Updates syntax highlighting language libraries.

## [0.14.4] - 2024-10-09

- Fixes a crash caused by copying or pasting with the system clipboard in some rare system configurations.

## [0.14.3] - 2024-10-09

- Fixes a crash caused by pressing `ctrl+g` twice ([tconbeer/harlequin#654](https://github.com/tconbeer/harlequin/issues/654)).

## [0.14.2] - 2024-08-16

- Fixes a TypeError raised by Textual >= v0.76 from the goto input validator.

## [0.14.1] - 2024-08-15

- Fixes a bug where uncommenting a line using the `toggle_comment` action would leave behind a space in languages with comment markers that are longer than one character ([tconbeer/harlequin#616](https://github.com/tconbeer/harlequin/issues/616)).

## [0.14.0] - 2024-07-09

- Updates dependencies and removes black in favor of the ruff formatter.

## [0.13.1] - 2024-06-28

- Bumps the pyperclip version for improved clipboard support on Wayland (Linux) ([tconbeer/harlequin#585](https://github.com/tconbeer/harlequin/issues/585)).

## [0.13.0] - 2024-04-19

- Adds a "find" action with <kbd>ctrl+f</kbd> and "find next" action with <kbd>F3</kbd>.
- Adds "go to line" action with <kbd>ctrl+g</kbd>.
- Adds bindings for `ctrl+shift+home` and `ctrl+shift+end` to select while moving to document start/end.
- Uses the new, native undo and redo functionality provided by the Textual TextArea widget. This has some subtly different behavior ([#240](https://github.com/tconbeer/textual-textarea/issues/240).

## [0.12.0] - 2024-04-17

- Show the computed filepath in the Save and Open widgets ([#232](https://github.com/tconbeer/textual-textarea/issues/232) - thank you [@bjornasm](https://github.com/bjornasm)!).
- Fixes a crash from initializing the Error Modal incorrectly.
- Fixes a crash from saving to a path in a non-existent directory.

## [0.11.3] - 2024-02-09

- No longer changes focus on `escape` (regression since 0.11.0)

## [0.11.2] - 2024-02-08

- Adds a `parser` property to the `CodeEditor` class to return the document's tree-sitter parser.

## [0.11.1] - 2024-02-08

- Adds a `syntax_tree` property to the `CodeEditor` class to return the document's tree-sitter syntax tree.

## [0.11.0] - 2024-02-06

- Bumps textual dependency to >=0.48.1
- Breaking change: Renames the main class from TextArea to TextEditor, to avoid naming conflicts with the built-in TextArea widget (which caused issues with selectors, CSS, etc.).
- Breaking change: Replaces the `cursor` and `selection_anchor` API with `selection`.
- Adds public APIs: `line_count`, `get_line`, `get_text_range`, `copy_to_clipboard`, `pause_blink`, `restart_blink`, `prepare_query`, and `query_syntax_tree`.

## [0.10.0] - 2024-01-30

- Adds a `text` argument when initializing TextArea.
- Improves time to first paint by finding the system clipboard in a thread, instead of blocking mounting. This has an especially large impact on Windows.

## [0.9.5] - 2023-12-18

- Ignore spurious `ctrl+@` keys generated by Windows. (See [textualize/textual#872](https://github.com/Textualize/textual/issues/872)).

## [0.9.4] - 2023-12-18

- No longer show bindings in the footer when the open or save inputs are focussed.

## [0.9.3] - 2023-12-15

- Fixes an issue where very long completions with short prefixes were truncated improperly.

## [0.9.2] - 2023-12-13

- Hides the cursor and autocomplete list when the TextArea widget is not focussed. ([#177](https://github.com/tconbeer/textual-textarea/issues/177)).

## [0.9.1] - 2023-12-13

- Fixes an issue where the autocomplete list was displayed in the wrong location after pressing backspace.

## [0.9.0] - 2023-12-12

- TextArea now provides auto-complete. By default, it will auto-complete paths; to auto-complete words or
  members of a namespace, set TextArea.word_completer, TextArea.member_completer, TextArea.path_completer
  to a Callable\[[str], list\[tuple[str, str]]]. The callables will receive the current word (or path, etc.) as their
  argument and should return a list of completions, where completions are (label, value) pairs.
- The TextArea is now focused when the Open or Save inputs are cancelled.

## [0.8.0] - 2023-12-06

- The TextArea has been completely overhauled. It now uses the built-in TextArea widget under the hood.
- This package now requires Textual >= 0.41.0, as it requires Textual's built-in TextArea widget.
- Double-click a word to select it; triple-click to select the row; quadruple-click to select the whole document.
- Fixes a bug with toggling comments.

## [0.7.3] - 2023-10-06

- The PathInput cursor no longer blinks if the app is run in headless mode (during tests). This only matters to prevent
  flaky tests for snapshot testing this widget and downstream apps.

## [0.7.2] - 2023-10-06

- The TextArea cursor no longer blinks if the app is run in headless mode (during tests). This only matters to prevent
  flaky tests for snapshot testing this widget and downstream apps.

## [0.7.1] - 2023-09-22

- TextArea now posts a `TextAreaSaved` message if it successfully saves a file.

## [0.7.0] - 2023-09-20

### Features

- TextArea now posts a `TextAreaClipboardError` message if it cannot access the system clipboard.

### Fixes

- TextArea now uses the contents of the system Paste message, instead of relying exclusively on the
  system clipboard. This should improve compatibility when Harlequin's host does not share its
  clipboard with the user's native system.
- When using the system clipboard, TextArea now initializes the clipboard on mount, resulting in
  better performance when copying and pasting.
- `textual_textarea.key_handlers.Cursor` is now exported from the main `textual_textarea` package.
- Cursor position is no longer updated on a right-click.

## [0.6.0] - 2023-09-08

### Features

- Adds a new public method, `TextArea.insert_text_at_selection(text)`.

## [0.5.4] - 2023-09-01

### Bug Fixes

- <kbd>up</kbd>, <kbd>down</kbd>, <kbd>pageup</kbd>, and <kbd>pagedown</kbd> now better maintain the cursor's x-position when starting with an x-position that is longer than adjacent lines ([#94](https://github.com/tconbeer/textual-textarea/issues/94)).

## [0.5.3] - 2023-09-01

### Bug Fixes

- Undo is smarter about cursor positions and selections; it no longer saves a new checkpoint for every cursor position. ([#86](https://github.com/tconbeer/textual-textarea/issues/86)).
- Clicks within the container but outside text will still update the cursor ([#93](https://github.com/tconbeer/textual-textarea/issues/93)).
- The cursor is now scrolled into position much faster.

## [0.5.2] - 2023-08-23

### Bug Fixes

- TextArea now uses the highlight color from the Pygments Style to highlight selected text.

## [0.5.1] - 2023-08-23

### Bug Fixes

- Fixes a crash caused by <kbd>shift+delete</kbd> on a buffer with only one line.

## [0.5.0] - 2023-08-22

### Features

- Undo any input with <kbd>ctrl+z</kbd>; redo with <kbd>ctrl+y</kbd> ([#12](https://github.com/tconbeer/textual-textarea/issues/12)).
- <kbd>shift+delete</kbd> now deletes the current line if there is no selection ([#77](https://github.com/tconbeer/textual-textarea/issues/77)). 

### Tests

- Adds basic fuzzing of text and keyboard inputs ([#50](https://github.com/tconbeer/textual-textarea/issues/50))

## [0.4.2] - 2023-08-03

### Bug Fixes

- No longer clears selection for more keystrokes (e.g,. <kbd>ctrl+j</kbd>)
- Better-maintains selection and cursor position when bulk commenting or uncommenting with <kbd>ctrl+/</kbd>

## [0.4.1] - 2023-08-03

### Features

- Adds a parameter to PathInput to allow <kbd>tab</kbd> to advance the focus.

## [0.4.0] - 2023-08-03

### Features

- Adds a suggester to autocomplete paths for the save and open file inputs.
- Adds a validator to validate paths for the save and open file inputs.
- `textual-textarea` now requires `textual` >=0.27.0
- Adds reactive properties to the textarea for `selection_anchor` position and 
  `selected_text`.

## [0.3.3] - 2023-07-28

### Features

- The open and save file inputs now expand the user home directory (`~`).

### Bug Fixes

- Selection should be better-maintained when pressing F-keys.

## [0.3.2] - 2023-07-14

### Bug Fixes

- Improves support for pasting text with `ctrl+v` on all platforms. ([#53](https://github.com/tconbeer/textual-textarea/issues/53)).

## [0.3.1] - 2023-06-26

### Bug Fixes

- Fixes issue where text area was aggressively capturing mouse events and not responding to mouse up events,
  which would cause issues if your App had widgets other than the TextArea ([#42](https://github.com/tconbeer/textual-textarea/issues/42)).
- Fixes an issue where <kbd>PageUp</kbd> could cause a crash ([#46](https://github.com/tconbeer/textual-textarea/issues/46)).

## [0.3.0] - 2023-06-19

- Select text using click and drag ([#8](https://github.com/tconbeer/textual-textarea/issues/8)).
- Comment characters inserted with <kbd>ctrl+/</kbd> are now based on the language that the
  TextArea is initialized with ([#24](https://github.com/tconbeer/textual-textarea/issues/24)).
- TextArea exposes a `language` property for the currently-configured language.

## [0.2.2] - 2023-06-15

### Features

- Adds a cursor attribute to TextArea to make it easier to get and set the TextInput's cursor position.
- Adds 3 attributes to TextArea to make it easier to access the child widgets: `text_input`, `text_container`, and `footer`.

### Bug Fixes

- Fixes a bug that was preventing the cursor from being scrolled into view.

## [0.2.1] - 2023-06-15

### Bug Fixes

- Fixes a bug where the TextArea did not update or have focus after opening a file ([#28](https://github.com/tconbeer/textual-textarea/issues/28))
- Fixes a bug where a missing space at the end of the buffer after opening a file could cause a crash

## [0.2.0] - 2023-06-14

### Features

- Uses the system clipboard (if it exists) for copy and paste operations, unless initialized
  with `use_system_clipboard=False`.
- Adds a sample app that can be run with `python -m textual_textarea`.

## [0.1.2] - 2023-06-01

- Makes top-level TextArea widget focusable
- Loosens textual dependency to >=0.21.0
- Adds py.typed file

## [0.1.1] - 2023-06-01

- Exports TextArea class under the main textual_textarea module.

## [0.1.0] - 2023-06-01

- Initial release: TextArea is a feature-rich text area (multiline) input, with
  support for syntax highlighting, themes, keyboard navigation, copy-paste, file
  opening and saving, and more!

[unreleased]: https://github.com/tconbeer/textual-textarea/compare/0.16.0...HEAD
[0.16.0]: https://github.com/tconbeer/textual-textarea/compare/0.15.0...0.16.0
[0.15.0]: https://github.com/tconbeer/textual-textarea/compare/0.14.4...0.15.0
[0.14.4]: https://github.com/tconbeer/textual-textarea/compare/0.14.3...0.14.4
[0.14.3]: https://github.com/tconbeer/textual-textarea/compare/0.14.2...0.14.3
[0.14.2]: https://github.com/tconbeer/textual-textarea/compare/0.14.1...0.14.2
[0.14.1]: https://github.com/tconbeer/textual-textarea/compare/0.14.0...0.14.1
[0.14.0]: https://github.com/tconbeer/textual-textarea/compare/0.13.1...0.14.0
[0.13.1]: https://github.com/tconbeer/textual-textarea/compare/0.13.0...0.13.1
[0.13.0]: https://github.com/tconbeer/textual-textarea/compare/0.12.0...0.13.0
[0.12.0]: https://github.com/tconbeer/textual-textarea/compare/0.11.3...0.12.0
[0.11.3]: https://github.com/tconbeer/textual-textarea/compare/0.11.2...0.11.3
[0.11.2]: https://github.com/tconbeer/textual-textarea/compare/0.11.1...0.11.2
[0.11.1]: https://github.com/tconbeer/textual-textarea/compare/0.11.0...0.11.1
[0.11.0]: https://github.com/tconbeer/textual-textarea/compare/0.10.0...0.11.0
[0.10.0]: https://github.com/tconbeer/textual-textarea/compare/0.9.5...0.10.0
[0.9.5]: https://github.com/tconbeer/textual-textarea/compare/0.9.4...0.9.5
[0.9.4]: https://github.com/tconbeer/textual-textarea/compare/0.9.3...0.9.4
[0.9.3]: https://github.com/tconbeer/textual-textarea/compare/0.9.2...0.9.3
[0.9.2]: https://github.com/tconbeer/textual-textarea/compare/0.9.1...0.9.2
[0.9.1]: https://github.com/tconbeer/textual-textarea/compare/0.9.0...0.9.1
[0.9.0]: https://github.com/tconbeer/textual-textarea/compare/0.8.0...0.9.0
[0.8.0]: https://github.com/tconbeer/textual-textarea/compare/0.7.3...0.8.0
[0.7.3]: https://github.com/tconbeer/textual-textarea/compare/0.7.2...0.7.3
[0.7.2]: https://github.com/tconbeer/textual-textarea/compare/0.7.1...0.7.2
[0.7.1]: https://github.com/tconbeer/textual-textarea/compare/0.7.0...0.7.1
[0.7.0]: https://github.com/tconbeer/textual-textarea/compare/0.6.0...0.7.0
[0.6.0]: https://github.com/tconbeer/textual-textarea/compare/0.5.4...0.6.0
[0.5.4]: https://github.com/tconbeer/textual-textarea/compare/0.5.3...0.5.4
[0.5.3]: https://github.com/tconbeer/textual-textarea/compare/0.5.2...0.5.3
[0.5.2]: https://github.com/tconbeer/textual-textarea/compare/0.5.1...0.5.2
[0.5.1]: https://github.com/tconbeer/textual-textarea/compare/0.5.0...0.5.1
[0.5.0]: https://github.com/tconbeer/textual-textarea/compare/0.4.2...0.5.0
[0.4.2]: https://github.com/tconbeer/textual-textarea/compare/0.4.1...0.4.2
[0.4.1]: https://github.com/tconbeer/textual-textarea/compare/0.4.0...0.4.1
[0.4.0]: https://github.com/tconbeer/textual-textarea/compare/0.3.3...0.4.0
[0.3.3]: https://github.com/tconbeer/textual-textarea/compare/0.3.2...0.3.3
[0.3.2]: https://github.com/tconbeer/textual-textarea/compare/0.3.1...0.3.2
[0.3.1]: https://github.com/tconbeer/textual-textarea/compare/0.3.0...0.3.1
[0.3.0]: https://github.com/tconbeer/textual-textarea/compare/0.2.2...0.3.0
[0.2.2]: https://github.com/tconbeer/textual-textarea/compare/0.2.1...0.2.2
[0.2.1]: https://github.com/tconbeer/textual-textarea/compare/0.2.0...0.2.1
[0.2.0]: https://github.com/tconbeer/textual-textarea/compare/0.1.2...0.2.0
[0.1.2]: https://github.com/tconbeer/textual-textarea/compare/0.1.1...0.1.2
[0.1.1]: https://github.com/tconbeer/textual-textarea/compare/0.1.0...0.1.1
[0.1.0]: https://github.com/tconbeer/textual-textarea/compare/9832e9bbe1cd7a2ce9a4f09746eb1c2ddc8df842...0.1.0
