# Generated by Django 4.1.8 on 2023-04-19 05:32

import datetime

import django.contrib.postgres.fields
import django.db.models.deletion
import django.utils.timezone
import django_fsm
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("directory", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="MailingList",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("title", models.CharField(max_length=255, verbose_name="Title")),
            ],
            options={
                "verbose_name": "Mailing List",
                "verbose_name_plural": "Mailing Lists",
            },
        ),
        migrations.CreateModel(
            name="MailingSettings",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("salutation", models.CharField(max_length=255, verbose_name="Salutation")),
            ],
            options={
                "verbose_name": "Mailing Settings",
                "verbose_name_plural": "Mailing Settings",
            },
        ),
        migrations.CreateModel(
            name="MailTemplate",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("title", models.CharField(max_length=255)),
                ("template", models.TextField()),
            ],
            options={
                "verbose_name": "Mail Template",
                "verbose_name_plural": "Mail Templates",
            },
        ),
        migrations.CreateModel(
            name="MassMail",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("subject", models.CharField(blank=True, max_length=255, null=True, verbose_name="Subject")),
                ("body", models.TextField(blank=True, null=True, verbose_name="Body")),
                (
                    "attachments_1",
                    models.FileField(blank=True, null=True, upload_to="mailing", verbose_name="Attachment (unique)"),
                ),
                ("created", models.DateTimeField(auto_now_add=True, verbose_name="Created")),
                (
                    "template",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="mass_mails",
                        to="wbmailing.mailtemplate",
                        verbose_name="Template",
                    ),
                ),
                ("from_email", models.EmailField(blank=True, max_length=254, null=True, verbose_name="From")),
                (
                    "mailing_lists",
                    models.ManyToManyField(
                        related_name="mails", to="wbmailing.mailinglist", verbose_name="Mailing Lists"
                    ),
                ),
                (
                    "status",
                    django_fsm.FSMField(
                        choices=[("DRAFT", "Draft"), ("PENDING", "Pending"), ("SENT", "Sent"), ("DENIED", "Denied")],
                        default="DRAFT",
                        max_length=50,
                        verbose_name="Status",
                    ),
                ),
                ("body_json", models.JSONField(blank=True, default=dict, null=True)),
            ],
            options={
                "verbose_name": "Mass Mail",
                "verbose_name_plural": "Mass Mails",
                "permissions": (("can_administrate_mail", "Can administrate mail"),),
            },
        ),
        migrations.CreateModel(
            name="Mail",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("from_email", models.EmailField(max_length=254, verbose_name="From")),
                ("subject", models.CharField(blank=True, max_length=255, null=True, verbose_name="Subject")),
                ("body", models.TextField(blank=True, null=True, verbose_name="body")),
                (
                    "mass_mail",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="mails",
                        to="wbmailing.massmail",
                        verbose_name="Mass Mail",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, verbose_name="Created")),
                (
                    "template",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="mails",
                        to="wbmailing.mailtemplate",
                        verbose_name="Template",
                    ),
                ),
                ("body_json", models.JSONField(blank=True, default=dict, null=True)),
                ("last_send", models.DateTimeField(default=django.utils.timezone.now, verbose_name="Last sent")),
                (
                    "message_ids",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.CharField(blank=True, max_length=255, null=True), default=list, size=None
                    ),
                ),
            ],
            options={
                "verbose_name": "Mail",
                "verbose_name_plural": "Mails",
            },
        ),
        migrations.CreateModel(
            name="MailingListSubscriberChangeRequest",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "type",
                    models.CharField(
                        choices=[("remove", "Remove"), ("add", "Add")],
                        default="add",
                        max_length=10,
                        verbose_name="Type",
                    ),
                ),
                (
                    "mailing_list",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="change_requests",
                        to="wbmailing.mailinglist",
                        verbose_name="Mailing List",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True, verbose_name="Created")),
                (
                    "status",
                    django_fsm.FSMField(
                        choices=[("PENDING", "Pending"), ("APPROVED", "Approved"), ("DENIED", "Denied")],
                        default="PENDING",
                        max_length=50,
                        verbose_name="Status",
                    ),
                ),
                (
                    "expiration_date",
                    models.DateField(
                        blank=True,
                        help_text="If set, this email will be removed automatically from the mailing list after the set expiration time",
                        null=True,
                        verbose_name="Expiration Date",
                    ),
                ),
            ],
            options={
                "verbose_name": "Mailing List Subscriber Change Request",
                "verbose_name_plural": "Mailing List Subscriber Change Requests",
                "permissions": (
                    (
                        "can_approve_mailing_list_subscriber_change_request",
                        "Can approve Mailing List Subscriber Change Requests",
                    ),
                ),
            },
        ),
        migrations.CreateModel(
            name="MailEvent",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("timestamp", models.DateTimeField(default=django.utils.timezone.now, verbose_name="Datetime")),
                ("description", models.CharField(blank=True, max_length=255, null=True, verbose_name="Description")),
                ("recipient", models.EmailField(blank=True, max_length=254, null=True, verbose_name="Recipient")),
                ("raw_data", models.JSONField(blank=True, default=dict, null=True, verbose_name="Raw Data")),
                (
                    "mail",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="events",
                        to="wbmailing.mail",
                        verbose_name="Mail",
                    ),
                ),
                ("click_url", models.CharField(blank=True, max_length=255, null=True, verbose_name="Clicked URL")),
                (
                    "event_type",
                    models.CharField(
                        choices=[
                            ("CREATED", "Created"),
                            ("QUEUED", "Queued"),
                            ("SENT", "Sent"),
                            ("RESENT", "Resent"),
                            ("REJECTED", "Rejected"),
                            ("FAILED", "Failed"),
                            ("BOUNCED", "Bounced"),
                            ("DEFERRED", "Deferred"),
                            ("DELIVERED", "Delivered"),
                            ("AUTORESPONDED", "Autoresponded"),
                            ("OPENED", "Opened"),
                            ("CLICKED", "Clicked"),
                            ("COMPLAINED", "Complained"),
                            ("UNSUBSCRIBED", "Unsubscribed"),
                            ("SUBSCRIBED", "Subscribed"),
                            ("INBOUND", "Inbound"),
                            ("INBOUND_FAILED", "Inbound Failed"),
                            ("UNKNOWN", "Unknown"),
                        ],
                        default="CREATED",
                        max_length=64,
                        verbose_name="Type",
                    ),
                ),
                (
                    "reject_reason",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("INVALID", "invalid"),
                            ("BOUNCED", "bounced"),
                            ("TIMED_OUT", "timed_out"),
                            ("BLOCKED", "blocked"),
                            ("SPAM", "spam"),
                            ("UNSUBSCRIBED", "unsubscribed"),
                            ("OTHER", "other"),
                        ],
                        max_length=64,
                        null=True,
                        verbose_name="Reject Reason",
                    ),
                ),
                (
                    "ip",
                    models.CharField(blank=True, max_length=126, null=True, verbose_name="IP used to send the mail"),
                ),
                ("user_agent", models.CharField(blank=True, max_length=512, null=True)),
            ],
            options={
                "verbose_name": "Mail Event",
                "verbose_name_plural": "Mail Events",
            },
        ),
        migrations.AlterModelTable(
            name="mail",
            table="mailing_mail",
        ),
        migrations.AlterModelTable(
            name="mailevent",
            table="mailing_mailevent",
        ),
        migrations.AlterModelTable(
            name="mailinglist",
            table="mailing_mailinglist",
        ),
        migrations.AlterModelTable(
            name="mailinglistsubscriberchangerequest",
            table="mailing_mailinglistsubscriberchangerequest",
        ),
        migrations.AlterModelTable(
            name="massmail",
            table="mailing_massmail",
        ),
        migrations.AddField(
            model_name="mailevent",
            name="metadata",
            field=models.JSONField(blank=True, default=dict, null=True, verbose_name="Metadata"),
        ),
        migrations.AddField(
            model_name="mailevent",
            name="tags",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.CharField(blank=True, max_length=64, null=True), default=list, size=None
            ),
        ),
        migrations.AlterField(
            model_name="mailevent",
            name="description",
            field=models.TextField(blank=True, null=True, verbose_name="Description"),
        ),
        migrations.AlterField(
            model_name="mailevent",
            name="user_agent",
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="mailinglist",
            name="is_public",
            field=models.BooleanField(
                default=False, help_text="If true, the factsheet is automatically subscribable", verbose_name="Public"
            ),
        ),
        migrations.AlterField(
            model_name="massmail",
            name="mailing_lists",
            field=models.ManyToManyField(
                help_text="The mailing lists to extract emails from. If duplicated is present, it will send only once.",
                related_name="mails",
                to="wbmailing.mailinglist",
                verbose_name="Mailing Lists",
            ),
        ),
        migrations.AlterField(
            model_name="massmail",
            name="status",
            field=django_fsm.FSMField(
                choices=[
                    ("DRAFT", "Draft"),
                    ("PENDING", "Pending"),
                    ("SENT", "Sent"),
                    ("SEND LATER", "Send later"),
                    ("DENIED", "Denied"),
                ],
                default="DRAFT",
                max_length=50,
                verbose_name="Status",
            ),
        ),
        migrations.AddField(
            model_name="massmail",
            name="attachment_url",
            field=models.URLField(blank=True, null=True, verbose_name="Attachment (URL)"),
        ),
        migrations.AlterField(
            model_name="mailevent",
            name="click_url",
            field=models.URLField(blank=True, max_length=2048, null=True, verbose_name="Clicked URL"),
        ),
        migrations.AlterField(
            model_name="massmail",
            name="body",
            field=models.TextField(default="", verbose_name="Body"),
        ),
        migrations.RemoveField(
            model_name="massmail",
            name="attachments_1",
        ),
        migrations.AlterField(
            model_name="mail",
            name="last_send",
            field=models.DateTimeField(default=django.utils.timezone.now, verbose_name="Last Sent"),
        ),
        migrations.AlterField(
            model_name="mailevent",
            name="ip",
            field=models.CharField(blank=True, max_length=126, null=True, verbose_name="IP Used To Send Mail"),
        ),
        migrations.AlterField(
            model_name="mailevent",
            name="reject_reason",
            field=models.CharField(
                blank=True,
                choices=[
                    ("INVALID", "invalid"),
                    ("BOUNCED", "bounced"),
                    ("TIMED_OUT", "timed_out"),
                    ("BLOCKED", "blocked"),
                    ("SPAM", "spam"),
                    ("UNSUBSCRIBED", "unsubscribed"),
                    ("OTHER", "other"),
                ],
                max_length=64,
                null=True,
                verbose_name="Rejection Reason",
            ),
        ),
        migrations.CreateModel(
            name="MailingListEmailContactThroughModel",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "status",
                    models.CharField(
                        choices=[("SUBSCRIBED", "Subscribed"), ("UNSUBSCRIBED", "Unsubscribed")],
                        default="UNSUBSCRIBED",
                        max_length=32,
                        verbose_name="Status",
                    ),
                ),
                (
                    "mailing_list",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="through_mailinglists",
                        to="wbmailing.mailinglist",
                    ),
                ),
                (
                    "email_contact",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="through_mailinglists",
                        to="directory.emailcontact",
                    ),
                ),
            ],
            options={
                "unique_together": {("mailing_list", "email_contact")},
            },
        ),
        migrations.AddField(
            model_name="mailinglistsubscriberchangerequest",
            name="reason",
            field=models.TextField(blank=True, null=True, verbose_name="Reason"),
        ),
        migrations.AddField(
            model_name="massmail",
            name="excluded_mailing_lists",
            field=models.ManyToManyField(
                blank=True,
                help_text="The mailing lists to exlude emails from. The resulting list of emails is equals to Mailing Lists - Excluded Mailing Lists ",
                related_name="excluded_mails",
                to="wbmailing.mailinglist",
                verbose_name="Excluded Mailing Lists",
            ),
        ),
        migrations.AlterField(
            model_name="massmail",
            name="mailing_lists",
            field=models.ManyToManyField(
                help_text="The mailing lists to extract emails from. Duplicates will be skipped.",
                related_name="mails",
                to="wbmailing.mailinglist",
                verbose_name="Mailing Lists",
            ),
        ),
        migrations.AddField(
            model_name="massmail",
            name="send_at",
            field=models.DateTimeField(blank=True, null=True, verbose_name="Send At"),
        ),
        migrations.RemoveField(
            model_name="mailinglistsubscriberchangerequest",
            name="type",
        ),
        migrations.AddField(
            model_name="mailinglistsubscriberchangerequest",
            name="relationship",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="requests",
                to="wbmailing.mailinglistemailcontactthroughmodel",
            ),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name="mailinglistsubscriberchangerequest",
            name="created",
            field=models.DateTimeField(
                auto_now_add=True,
                default=datetime.datetime(2023, 4, 19, 5, 32, 0, 392613, tzinfo=datetime.timezone.utc),
                verbose_name="Created",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="mailinglistsubscriberchangerequest",
            name="updated",
            field=models.DateTimeField(
                auto_now=True,
                default=datetime.datetime(2023, 4, 19, 5, 32, 0, 392625, tzinfo=datetime.timezone.utc),
                verbose_name="Updated",
            ),
        ),
        migrations.AlterModelTable(
            name="mail",
            table=None,
        ),
        migrations.AlterModelTable(
            name="mailevent",
            table=None,
        ),
        migrations.AlterModelTable(
            name="mailinglist",
            table=None,
        ),
        migrations.AlterModelTable(
            name="mailinglistsubscriberchangerequest",
            table=None,
        ),
        migrations.AlterModelTable(
            name="mailingsettings",
            table=None,
        ),
        migrations.AlterModelTable(
            name="mailtemplate",
            table=None,
        ),
        migrations.AlterModelTable(
            name="massmail",
            table=None,
        ),
        migrations.AlterField(
            model_name="mailinglistsubscriberchangerequest",
            name="relationship",
            field=models.ForeignKey(
                default=None,
                on_delete=django.db.models.deletion.CASCADE,
                to="wbmailing.mailinglistemailcontactthroughmodel",
            ),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name="mailinglistsubscriberchangerequest",
            name="relationship",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="requests",
                to="wbmailing.mailinglistemailcontactthroughmodel",
            ),
        ),
        migrations.AddField(
            model_name="mailinglistsubscriberchangerequest",
            name="type",
            field=models.CharField(
                choices=[("SUBSCRIBING", "Subscribing"), ("UNSUBSCRIBING", "Unsubscribing")],
                max_length=32,
                verbose_name="Type",
            ),
        ),
        migrations.AddField(
            model_name="mail",
            name="bcc_email",
            field=models.ManyToManyField(
                blank=True, related_name="mail_bcc", to="directory.emailcontact", verbose_name="BCC"
            ),
        ),
        migrations.AddField(
            model_name="mail",
            name="cc_email",
            field=models.ManyToManyField(
                blank=True, related_name="mail_cc", to="directory.emailcontact", verbose_name="CC"
            ),
        ),
        migrations.AddField(
            model_name="mail",
            name="to_email",
            field=models.ManyToManyField(related_name="mail_to", to="directory.emailcontact", verbose_name="To"),
        ),
        migrations.AddField(
            model_name="mailinglist",
            name="email_contacts",
            field=models.ManyToManyField(
                blank=True,
                related_name="mailing_lists",
                through="wbmailing.MailingListEmailContactThroughModel",
                to="directory.emailcontact",
                verbose_name="Subcribers",
            ),
        ),
        migrations.AddField(
            model_name="mailinglistsubscriberchangerequest",
            name="approver",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="approved_requests",
                to="directory.person",
                verbose_name="Approver",
            ),
        ),
        migrations.AddField(
            model_name="mailinglistsubscriberchangerequest",
            name="email_contact",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="change_requests",
                to="directory.emailcontact",
                verbose_name="Subscriber",
            ),
        ),
        migrations.AddField(
            model_name="mailinglistsubscriberchangerequest",
            name="requester",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="directory.person",
                verbose_name="Requester",
            ),
        ),
        migrations.AddField(
            model_name="mailingsettings",
            name="entry",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="mail_settings",
                to="directory.entry",
                verbose_name="Entry",
            ),
        ),
        migrations.AddField(
            model_name="massmail",
            name="creator",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="created_mails",
                to="directory.person",
                verbose_name="Creator",
            ),
        ),
        migrations.AddConstraint(
            model_name="mailinglistsubscriberchangerequest",
            constraint=models.UniqueConstraint(
                condition=models.Q(("status", "PENDING")),
                fields=("mailing_list", "email_contact"),
                name="unique_pending_request",
            ),
        ),
        migrations.AlterField(
            model_name="mailinglistsubscriberchangerequest",
            name="updated",
            field=models.DateTimeField(auto_now=True, verbose_name="Updated"),
        ),
    ]
