# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class Integration(pulumi.CustomResource):
    custom_cloudwatch_namespaces: pulumi.Output[list]
    """
    List of custom AWS CloudWatch namespaces to monitor. Custom namespaces contain custom metrics that you define in AWS; SignalFx imports the metrics so you can monitor them.
    """
    custom_namespace_sync_rules: pulumi.Output[list]
    """
    Each element controls the data collected by SignalFx for the specified namespace. Conflicts with the `custom_cloudwatch_namespaces` property.
    
      * `defaultAction` (`str`) - Controls the SignalFx default behavior for processing data from an AWS namespace. If you do specify a filter, use this property to control how SignalFx treats data that doesn't match the filter. The available actions are one of `"Include"` or `"Exclude"`.
      * `filterAction` (`str`) - Controls how SignalFx processes data from a custom AWS namespace. The available actions are one of `"Include"` or `"Exclude"`.
      * `filterSource` (`str`) - Expression that selects the data that SignalFx should sync for the custom namespace associated with this sync rule. The expression uses the syntax defined for the SignalFlow `filter()` function; it can be any valid SignalFlow filter expression.
      * `namespace` (`str`) - An AWS custom namespace having custom AWS metrics that you want to sync with SignalFx. See the AWS documentation on publishing metrics for more information.
    """
    enable_aws_usage: pulumi.Output[bool]
    """
    Flag that controls how SignalFx imports usage metrics from AWS to use with AWS Cost Optimizer. If `true`, SignalFx imports the metrics.
    """
    enabled: pulumi.Output[bool]
    """
    Whether the integration is enabled.
    """
    external_id: pulumi.Output[str]
    """
    The `external_id` property from one of a `aws.ExternalIntegration` or `aws.TokenIntegration`
    """
    import_cloud_watch: pulumi.Output[bool]
    """
    Flag that controls how SignalFx imports Cloud Watch metrics. If true, SignalFx imports Cloud Watch metrics from AWS.
    """
    integration_id: pulumi.Output[str]
    """
    The id of one of a `aws.ExternalIntegration` or `aws.TokenIntegration`.
    """
    key: pulumi.Output[str]
    """
    If you specify `auth_method = \"SecurityToken\"` in your request to create an AWS integration object, use this property to specify the key.
    """
    namespace_sync_rules: pulumi.Output[list]
    """
    Each element in the array is an object that contains an AWS namespace name and a filter that controls the data that SignalFx collects for the namespace. Conflicts with the `services` property. If you don't specify either property, SignalFx syncs all data in all AWS namespaces.
    
      * `defaultAction` (`str`) - Controls the SignalFx default behavior for processing data from an AWS namespace. If you do specify a filter, use this property to control how SignalFx treats data that doesn't match the filter. The available actions are one of `"Include"` or `"Exclude"`.
      * `filterAction` (`str`) - Controls how SignalFx processes data from a custom AWS namespace. The available actions are one of `"Include"` or `"Exclude"`.
      * `filterSource` (`str`) - Expression that selects the data that SignalFx should sync for the custom namespace associated with this sync rule. The expression uses the syntax defined for the SignalFlow `filter()` function; it can be any valid SignalFlow filter expression.
      * `namespace` (`str`) - An AWS custom namespace having custom AWS metrics that you want to sync with SignalFx. See the AWS documentation on publishing metrics for more information.
    """
    poll_rate: pulumi.Output[float]
    """
    AWS poll rate (in seconds). One of `60` or `300`.
    """
    regions: pulumi.Output[list]
    """
    List of AWS regions that SignalFx should monitor.
    """
    role_arn: pulumi.Output[str]
    """
    Role ARN that you add to an existing AWS integration object.
    """
    services: pulumi.Output[list]
    """
    List of AWS services that you want SignalFx to monitor. Each element is a string designating an AWS service. Conflicts with `namespace_sync_rule`.
    """
    token: pulumi.Output[str]
    def __init__(__self__, resource_name, opts=None, custom_cloudwatch_namespaces=None, custom_namespace_sync_rules=None, enable_aws_usage=None, enabled=None, external_id=None, import_cloud_watch=None, integration_id=None, key=None, namespace_sync_rules=None, poll_rate=None, regions=None, role_arn=None, services=None, token=None, __props__=None, __name__=None, __opts__=None):
        """
        SignalFx AWS CloudWatch integrations. For help with this integration see [Monitoring Amazon Web Services](https://docs.signalfx.com/en/latest/integrations/amazon-web-services.html#monitor-amazon-web-services).
        
        **Note:** When managing integrations you'll need to use an admin token to authenticate the SignalFx provider.
        
        > **WARNING** This resource implements a part of a workflow. You must use it with one of either `aws.ExternalIntegration` or `aws.TokenIntegration`.
        
        ## Service Names
        
        Fields that expect an AWS service/namespace will work with one of: "AWS/ApiGateway" "AWS/AppStream" "AWS/AutoScaling" "AWS/Billing" "AWS/CloudFront" "AWS/CloudSearch" "AWS/Events" "AWS/Logs" "AWS/Connect" "AWS/DMS" "AWS/DX" "AWS/DynamoDB" "AWS/EC2" "AWS/EC2Spot" "AWS/ECS" "AWS/ElasticBeanstalk" "AWS/EBS" "AWS/EFS" "AWS/ELB" "AWS/ApplicationELB" "AWS/NetworkELB" "AWS/ElasticTranscoder" "AWS/ElastiCache" "AWS/ES" "AWS/ElasticMapReduce" "AWS/GameLift" "AWS/Inspector" "AWS/IoT" "AWS/KMS" "AWS/KinesisAnalytics" "AWS/Firehose" "AWS/Kinesis" "AWS/KinesisVideo" "AWS/Lambda" "AWS/Lex" "AWS/ML" "AWS/OpsWorks" "AWS/Polly" "AWS/Redshift" "AWS/RDS" "AWS/Route53" "AWS/SageMaker" "AWS/DDoSProtection" "AWS/SES" "AWS/SNS" "AWS/SQS" "AWS/S3" "AWS/SWF" "AWS/States" "AWS/StorageGateway" "AWS/Translate" "AWS/NATGateway" "AWS/VPN (VPN)" "WAF" "AWS/WorkSpaces".
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] custom_cloudwatch_namespaces: List of custom AWS CloudWatch namespaces to monitor. Custom namespaces contain custom metrics that you define in AWS; SignalFx imports the metrics so you can monitor them.
        :param pulumi.Input[list] custom_namespace_sync_rules: Each element controls the data collected by SignalFx for the specified namespace. Conflicts with the `custom_cloudwatch_namespaces` property.
        :param pulumi.Input[bool] enable_aws_usage: Flag that controls how SignalFx imports usage metrics from AWS to use with AWS Cost Optimizer. If `true`, SignalFx imports the metrics.
        :param pulumi.Input[bool] enabled: Whether the integration is enabled.
        :param pulumi.Input[str] external_id: The `external_id` property from one of a `aws.ExternalIntegration` or `aws.TokenIntegration`
        :param pulumi.Input[bool] import_cloud_watch: Flag that controls how SignalFx imports Cloud Watch metrics. If true, SignalFx imports Cloud Watch metrics from AWS.
        :param pulumi.Input[str] integration_id: The id of one of a `aws.ExternalIntegration` or `aws.TokenIntegration`.
        :param pulumi.Input[str] key: If you specify `auth_method = \"SecurityToken\"` in your request to create an AWS integration object, use this property to specify the key.
        :param pulumi.Input[list] namespace_sync_rules: Each element in the array is an object that contains an AWS namespace name and a filter that controls the data that SignalFx collects for the namespace. Conflicts with the `services` property. If you don't specify either property, SignalFx syncs all data in all AWS namespaces.
        :param pulumi.Input[float] poll_rate: AWS poll rate (in seconds). One of `60` or `300`.
        :param pulumi.Input[list] regions: List of AWS regions that SignalFx should monitor.
        :param pulumi.Input[str] role_arn: Role ARN that you add to an existing AWS integration object.
        :param pulumi.Input[list] services: List of AWS services that you want SignalFx to monitor. Each element is a string designating an AWS service. Conflicts with `namespace_sync_rule`.
        
        The **custom_namespace_sync_rules** object supports the following:
        
          * `defaultAction` (`pulumi.Input[str]`) - Controls the SignalFx default behavior for processing data from an AWS namespace. If you do specify a filter, use this property to control how SignalFx treats data that doesn't match the filter. The available actions are one of `"Include"` or `"Exclude"`.
          * `filterAction` (`pulumi.Input[str]`) - Controls how SignalFx processes data from a custom AWS namespace. The available actions are one of `"Include"` or `"Exclude"`.
          * `filterSource` (`pulumi.Input[str]`) - Expression that selects the data that SignalFx should sync for the custom namespace associated with this sync rule. The expression uses the syntax defined for the SignalFlow `filter()` function; it can be any valid SignalFlow filter expression.
          * `namespace` (`pulumi.Input[str]`) - An AWS custom namespace having custom AWS metrics that you want to sync with SignalFx. See the AWS documentation on publishing metrics for more information.
        
        The **namespace_sync_rules** object supports the following:
        
          * `defaultAction` (`pulumi.Input[str]`) - Controls the SignalFx default behavior for processing data from an AWS namespace. If you do specify a filter, use this property to control how SignalFx treats data that doesn't match the filter. The available actions are one of `"Include"` or `"Exclude"`.
          * `filterAction` (`pulumi.Input[str]`) - Controls how SignalFx processes data from a custom AWS namespace. The available actions are one of `"Include"` or `"Exclude"`.
          * `filterSource` (`pulumi.Input[str]`) - Expression that selects the data that SignalFx should sync for the custom namespace associated with this sync rule. The expression uses the syntax defined for the SignalFlow `filter()` function; it can be any valid SignalFlow filter expression.
          * `namespace` (`pulumi.Input[str]`) - An AWS custom namespace having custom AWS metrics that you want to sync with SignalFx. See the AWS documentation on publishing metrics for more information.

        > This content is derived from https://github.com/terraform-providers/terraform-provider-signalfx/blob/master/website/docs/r/aws_integration.html.markdown.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['custom_cloudwatch_namespaces'] = custom_cloudwatch_namespaces
            __props__['custom_namespace_sync_rules'] = custom_namespace_sync_rules
            __props__['enable_aws_usage'] = enable_aws_usage
            if enabled is None:
                raise TypeError("Missing required property 'enabled'")
            __props__['enabled'] = enabled
            __props__['external_id'] = external_id
            __props__['import_cloud_watch'] = import_cloud_watch
            if integration_id is None:
                raise TypeError("Missing required property 'integration_id'")
            __props__['integration_id'] = integration_id
            __props__['key'] = key
            __props__['namespace_sync_rules'] = namespace_sync_rules
            __props__['poll_rate'] = poll_rate
            __props__['regions'] = regions
            __props__['role_arn'] = role_arn
            __props__['services'] = services
            __props__['token'] = token
        super(Integration, __self__).__init__(
            'signalfx:aws/integration:Integration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, custom_cloudwatch_namespaces=None, custom_namespace_sync_rules=None, enable_aws_usage=None, enabled=None, external_id=None, import_cloud_watch=None, integration_id=None, key=None, namespace_sync_rules=None, poll_rate=None, regions=None, role_arn=None, services=None, token=None):
        """
        Get an existing Integration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.
        
        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] custom_cloudwatch_namespaces: List of custom AWS CloudWatch namespaces to monitor. Custom namespaces contain custom metrics that you define in AWS; SignalFx imports the metrics so you can monitor them.
        :param pulumi.Input[list] custom_namespace_sync_rules: Each element controls the data collected by SignalFx for the specified namespace. Conflicts with the `custom_cloudwatch_namespaces` property.
        :param pulumi.Input[bool] enable_aws_usage: Flag that controls how SignalFx imports usage metrics from AWS to use with AWS Cost Optimizer. If `true`, SignalFx imports the metrics.
        :param pulumi.Input[bool] enabled: Whether the integration is enabled.
        :param pulumi.Input[str] external_id: The `external_id` property from one of a `aws.ExternalIntegration` or `aws.TokenIntegration`
        :param pulumi.Input[bool] import_cloud_watch: Flag that controls how SignalFx imports Cloud Watch metrics. If true, SignalFx imports Cloud Watch metrics from AWS.
        :param pulumi.Input[str] integration_id: The id of one of a `aws.ExternalIntegration` or `aws.TokenIntegration`.
        :param pulumi.Input[str] key: If you specify `auth_method = \"SecurityToken\"` in your request to create an AWS integration object, use this property to specify the key.
        :param pulumi.Input[list] namespace_sync_rules: Each element in the array is an object that contains an AWS namespace name and a filter that controls the data that SignalFx collects for the namespace. Conflicts with the `services` property. If you don't specify either property, SignalFx syncs all data in all AWS namespaces.
        :param pulumi.Input[float] poll_rate: AWS poll rate (in seconds). One of `60` or `300`.
        :param pulumi.Input[list] regions: List of AWS regions that SignalFx should monitor.
        :param pulumi.Input[str] role_arn: Role ARN that you add to an existing AWS integration object.
        :param pulumi.Input[list] services: List of AWS services that you want SignalFx to monitor. Each element is a string designating an AWS service. Conflicts with `namespace_sync_rule`.
        
        The **custom_namespace_sync_rules** object supports the following:
        
          * `defaultAction` (`pulumi.Input[str]`) - Controls the SignalFx default behavior for processing data from an AWS namespace. If you do specify a filter, use this property to control how SignalFx treats data that doesn't match the filter. The available actions are one of `"Include"` or `"Exclude"`.
          * `filterAction` (`pulumi.Input[str]`) - Controls how SignalFx processes data from a custom AWS namespace. The available actions are one of `"Include"` or `"Exclude"`.
          * `filterSource` (`pulumi.Input[str]`) - Expression that selects the data that SignalFx should sync for the custom namespace associated with this sync rule. The expression uses the syntax defined for the SignalFlow `filter()` function; it can be any valid SignalFlow filter expression.
          * `namespace` (`pulumi.Input[str]`) - An AWS custom namespace having custom AWS metrics that you want to sync with SignalFx. See the AWS documentation on publishing metrics for more information.
        
        The **namespace_sync_rules** object supports the following:
        
          * `defaultAction` (`pulumi.Input[str]`) - Controls the SignalFx default behavior for processing data from an AWS namespace. If you do specify a filter, use this property to control how SignalFx treats data that doesn't match the filter. The available actions are one of `"Include"` or `"Exclude"`.
          * `filterAction` (`pulumi.Input[str]`) - Controls how SignalFx processes data from a custom AWS namespace. The available actions are one of `"Include"` or `"Exclude"`.
          * `filterSource` (`pulumi.Input[str]`) - Expression that selects the data that SignalFx should sync for the custom namespace associated with this sync rule. The expression uses the syntax defined for the SignalFlow `filter()` function; it can be any valid SignalFlow filter expression.
          * `namespace` (`pulumi.Input[str]`) - An AWS custom namespace having custom AWS metrics that you want to sync with SignalFx. See the AWS documentation on publishing metrics for more information.

        > This content is derived from https://github.com/terraform-providers/terraform-provider-signalfx/blob/master/website/docs/r/aws_integration.html.markdown.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()
        __props__["custom_cloudwatch_namespaces"] = custom_cloudwatch_namespaces
        __props__["custom_namespace_sync_rules"] = custom_namespace_sync_rules
        __props__["enable_aws_usage"] = enable_aws_usage
        __props__["enabled"] = enabled
        __props__["external_id"] = external_id
        __props__["import_cloud_watch"] = import_cloud_watch
        __props__["integration_id"] = integration_id
        __props__["key"] = key
        __props__["namespace_sync_rules"] = namespace_sync_rules
        __props__["poll_rate"] = poll_rate
        __props__["regions"] = regions
        __props__["role_arn"] = role_arn
        __props__["services"] = services
        __props__["token"] = token
        return Integration(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

