# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class Detector(pulumi.CustomResource):
    description: pulumi.Output[str]
    """
    Description of the detector.
    """
    disable_sampling: pulumi.Output[bool]
    """
    When `false`, the visualization may sample the output timeseries rather than displaying them all. `false` by default.
    """
    end_time: pulumi.Output[float]
    """
    Seconds since epoch. Used for visualization. Conflicts with `time_range`.
    """
    max_delay: pulumi.Output[float]
    """
    How long (in seconds) to wait for late datapoints. See <https://signalfx-product-docs.readthedocs-hosted.com/en/latest/charts/chart-builder.html#delayed-datapoints> for more info. Max value is `900` seconds (15 minutes).
    """
    name: pulumi.Output[str]
    """
    Name of the detector.
    """
    program_text: pulumi.Output[str]
    """
    Signalflow program text for the detector. More info at <https://developers.signalfx.com/docs/signalflow-overview>.
    """
    rules: pulumi.Output[list]
    """
    Set of rules used for alerting.
    
      * `description` (`str`) - Description of the detector.
      * `detectLabel` (`str`) - A detect label which matches a detect label within `program_text`.
      * `disabled` (`bool`) - When true, notifications and events will not be generated for the detect label. `false` by default.
      * `notifications` (`list`) - List of strings specifying where notifications will be sent when an incident occurs. See <https://developers.signalfx.com/detectors_reference.html#operation/Create%20Single%20Detector> for more info.
      * `parameterizedBody` (`str`) - Custom notification message body when an alert is triggered. See <https://docs.signalfx.com/en/latest/detect-alert/set-up-detectors.html#about-detectors#alert-settings> for more info.
      * `parameterizedSubject` (`str`) - Custom notification message subject when an alert is triggered. See <https://docs.signalfx.com/en/latest/detect-alert/set-up-detectors.html#about-detectors#alert-settings> for more info.
      * `runbookUrl` (`str`) - URL of page to consult when an alert is triggered. This can be used with custom notification messages.
      * `severity` (`str`) - The severity of the rule, must be one of: `"Critical"`, `"Major"`, `"Minor"`, `"Warning"`, `"Info"`.
      * `tip` (`str`) - Plain text suggested first course of action, such as a command line to execute. This can be used with custom notification messages.
    """
    show_data_markers: pulumi.Output[bool]
    """
    When `true`, markers will be drawn for each datapoint within the visualization. `false` by default.
    """
    show_event_lines: pulumi.Output[bool]
    """
    When `true`, the visualization will display a vertical line for each event trigger. `false` by default.
    """
    start_time: pulumi.Output[float]
    """
    Seconds since epoch. Used for visualization. Conflicts with `time_range`.
    """
    teams: pulumi.Output[list]
    """
    Team IDs to associate the detector to.
    """
    time_range: pulumi.Output[float]
    """
    Seconds to display in the visualization. This is a rolling range from the current time. Example: 3600 = `-1h`. Defaults to 3600.
    """
    url: pulumi.Output[str]
    def __init__(__self__, resource_name, opts=None, description=None, disable_sampling=None, end_time=None, max_delay=None, name=None, program_text=None, rules=None, show_data_markers=None, show_event_lines=None, start_time=None, teams=None, time_range=None, __props__=None, __name__=None, __opts__=None):
        """
        Provides a SignalFx detector resource. This can be used to create and manage detectors.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the detector.
        :param pulumi.Input[bool] disable_sampling: When `false`, the visualization may sample the output timeseries rather than displaying them all. `false` by default.
        :param pulumi.Input[float] end_time: Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        :param pulumi.Input[float] max_delay: How long (in seconds) to wait for late datapoints. See <https://signalfx-product-docs.readthedocs-hosted.com/en/latest/charts/chart-builder.html#delayed-datapoints> for more info. Max value is `900` seconds (15 minutes).
        :param pulumi.Input[str] name: Name of the detector.
        :param pulumi.Input[str] program_text: Signalflow program text for the detector. More info at <https://developers.signalfx.com/docs/signalflow-overview>.
        :param pulumi.Input[list] rules: Set of rules used for alerting.
        :param pulumi.Input[bool] show_data_markers: When `true`, markers will be drawn for each datapoint within the visualization. `false` by default.
        :param pulumi.Input[bool] show_event_lines: When `true`, the visualization will display a vertical line for each event trigger. `false` by default.
        :param pulumi.Input[float] start_time: Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        :param pulumi.Input[list] teams: Team IDs to associate the detector to.
        :param pulumi.Input[float] time_range: Seconds to display in the visualization. This is a rolling range from the current time. Example: 3600 = `-1h`. Defaults to 3600.
        
        The **rules** object supports the following:
        
          * `description` (`pulumi.Input[str]`) - Description of the detector.
          * `detectLabel` (`pulumi.Input[str]`) - A detect label which matches a detect label within `program_text`.
          * `disabled` (`pulumi.Input[bool]`) - When true, notifications and events will not be generated for the detect label. `false` by default.
          * `notifications` (`pulumi.Input[list]`) - List of strings specifying where notifications will be sent when an incident occurs. See <https://developers.signalfx.com/detectors_reference.html#operation/Create%20Single%20Detector> for more info.
          * `parameterizedBody` (`pulumi.Input[str]`) - Custom notification message body when an alert is triggered. See <https://docs.signalfx.com/en/latest/detect-alert/set-up-detectors.html#about-detectors#alert-settings> for more info.
          * `parameterizedSubject` (`pulumi.Input[str]`) - Custom notification message subject when an alert is triggered. See <https://docs.signalfx.com/en/latest/detect-alert/set-up-detectors.html#about-detectors#alert-settings> for more info.
          * `runbookUrl` (`pulumi.Input[str]`) - URL of page to consult when an alert is triggered. This can be used with custom notification messages.
          * `severity` (`pulumi.Input[str]`) - The severity of the rule, must be one of: `"Critical"`, `"Major"`, `"Minor"`, `"Warning"`, `"Info"`.
          * `tip` (`pulumi.Input[str]`) - Plain text suggested first course of action, such as a command line to execute. This can be used with custom notification messages.

        > This content is derived from https://github.com/terraform-providers/terraform-provider-signalfx/blob/master/website/docs/r/detector.html.markdown.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['description'] = description
            __props__['disable_sampling'] = disable_sampling
            __props__['end_time'] = end_time
            __props__['max_delay'] = max_delay
            __props__['name'] = name
            if program_text is None:
                raise TypeError("Missing required property 'program_text'")
            __props__['program_text'] = program_text
            if rules is None:
                raise TypeError("Missing required property 'rules'")
            __props__['rules'] = rules
            __props__['show_data_markers'] = show_data_markers
            __props__['show_event_lines'] = show_event_lines
            __props__['start_time'] = start_time
            __props__['teams'] = teams
            __props__['time_range'] = time_range
            __props__['url'] = None
        super(Detector, __self__).__init__(
            'signalfx:index/detector:Detector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, description=None, disable_sampling=None, end_time=None, max_delay=None, name=None, program_text=None, rules=None, show_data_markers=None, show_event_lines=None, start_time=None, teams=None, time_range=None, url=None):
        """
        Get an existing Detector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.
        
        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the detector.
        :param pulumi.Input[bool] disable_sampling: When `false`, the visualization may sample the output timeseries rather than displaying them all. `false` by default.
        :param pulumi.Input[float] end_time: Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        :param pulumi.Input[float] max_delay: How long (in seconds) to wait for late datapoints. See <https://signalfx-product-docs.readthedocs-hosted.com/en/latest/charts/chart-builder.html#delayed-datapoints> for more info. Max value is `900` seconds (15 minutes).
        :param pulumi.Input[str] name: Name of the detector.
        :param pulumi.Input[str] program_text: Signalflow program text for the detector. More info at <https://developers.signalfx.com/docs/signalflow-overview>.
        :param pulumi.Input[list] rules: Set of rules used for alerting.
        :param pulumi.Input[bool] show_data_markers: When `true`, markers will be drawn for each datapoint within the visualization. `false` by default.
        :param pulumi.Input[bool] show_event_lines: When `true`, the visualization will display a vertical line for each event trigger. `false` by default.
        :param pulumi.Input[float] start_time: Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        :param pulumi.Input[list] teams: Team IDs to associate the detector to.
        :param pulumi.Input[float] time_range: Seconds to display in the visualization. This is a rolling range from the current time. Example: 3600 = `-1h`. Defaults to 3600.
        
        The **rules** object supports the following:
        
          * `description` (`pulumi.Input[str]`) - Description of the detector.
          * `detectLabel` (`pulumi.Input[str]`) - A detect label which matches a detect label within `program_text`.
          * `disabled` (`pulumi.Input[bool]`) - When true, notifications and events will not be generated for the detect label. `false` by default.
          * `notifications` (`pulumi.Input[list]`) - List of strings specifying where notifications will be sent when an incident occurs. See <https://developers.signalfx.com/detectors_reference.html#operation/Create%20Single%20Detector> for more info.
          * `parameterizedBody` (`pulumi.Input[str]`) - Custom notification message body when an alert is triggered. See <https://docs.signalfx.com/en/latest/detect-alert/set-up-detectors.html#about-detectors#alert-settings> for more info.
          * `parameterizedSubject` (`pulumi.Input[str]`) - Custom notification message subject when an alert is triggered. See <https://docs.signalfx.com/en/latest/detect-alert/set-up-detectors.html#about-detectors#alert-settings> for more info.
          * `runbookUrl` (`pulumi.Input[str]`) - URL of page to consult when an alert is triggered. This can be used with custom notification messages.
          * `severity` (`pulumi.Input[str]`) - The severity of the rule, must be one of: `"Critical"`, `"Major"`, `"Minor"`, `"Warning"`, `"Info"`.
          * `tip` (`pulumi.Input[str]`) - Plain text suggested first course of action, such as a command line to execute. This can be used with custom notification messages.

        > This content is derived from https://github.com/terraform-providers/terraform-provider-signalfx/blob/master/website/docs/r/detector.html.markdown.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()
        __props__["description"] = description
        __props__["disable_sampling"] = disable_sampling
        __props__["end_time"] = end_time
        __props__["max_delay"] = max_delay
        __props__["name"] = name
        __props__["program_text"] = program_text
        __props__["rules"] = rules
        __props__["show_data_markers"] = show_data_markers
        __props__["show_event_lines"] = show_event_lines
        __props__["start_time"] = start_time
        __props__["teams"] = teams
        __props__["time_range"] = time_range
        __props__["url"] = url
        return Detector(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

