# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class ListChart(pulumi.CustomResource):
    color_by: pulumi.Output[str]
    """
    Must be one of `"Scale"`, `"Dimension"` or `"Metric"`. `"Dimension"` by default.
    """
    color_scales: pulumi.Output[list]
    """
    Single color range including both the color to display for that range and the borders of the range. Example: `[{ gt = 60, color = "blue" }, { lte = 60, color = "yellow" }]`. Look at this [link](https://docs.signalfx.com/en/latest/charts/chart-options-tab.html).
    
      * `color` (`str`) - The color range to use. Must be either gray, blue, navy, orange, yellow, magenta, purple, violet, lilac, green, aquamarine.
      * `gt` (`float`) - Indicates the lower threshold non-inclusive value for this range.
      * `gte` (`float`) - Indicates the lower threshold inclusive value for this range.
      * `lt` (`float`) - Indicates the upper threshold non-inculsive value for this range.
      * `lte` (`float`) - Indicates the upper threshold inclusive value for this range.
    """
    description: pulumi.Output[str]
    """
    Description of the chart.
    """
    disable_sampling: pulumi.Output[bool]
    """
    If `false`, samples a subset of the output MTS, which improves UI performance. `false` by default.
    """
    last_updated: pulumi.Output[float]
    legend_fields_to_hides: pulumi.Output[list]
    """
    List of properties that should not be displayed in the chart legend (i.e. dimension names). All the properties are visible by default. Deprecated, please use `legend_options_fields`.
    """
    legend_options_fields: pulumi.Output[list]
    """
    List of property names and enabled flags that should be displayed in the data table for the chart, in the order provided. This option cannot be used with `legend_fields_to_hide`.
    * `property` The name of the property to display. Note the special values of `plot_label` (corresponding with the API's `sf_metric`) which shows the label of the time series `publish()` and `metric` (corresponding with the API's `sf_originatingMetric`) that shows the name of the metric for the time series being displayed.
    * `enabled` True or False depending on if you want the property to be shown or hidden.
    
      * `enabled` (`bool`)
      * `property` (`str`)
    """
    max_delay: pulumi.Output[float]
    """
    How long (in seconds) to wait for late datapoints.
    """
    max_precision: pulumi.Output[float]
    """
    Maximum number of digits to display when rounding values up or down.
    """
    name: pulumi.Output[str]
    """
    Name of the chart.
    """
    program_text: pulumi.Output[str]
    """
    Signalflow program text for the chart. More info at <https://developers.signalfx.com/docs/signalflow-overview>.
    """
    refresh_interval: pulumi.Output[float]
    """
    How often (in seconds) to refresh the values of the list.
    """
    secondary_visualization: pulumi.Output[str]
    """
    The type of secondary visualization. Can be `None`, `Radial`, `Linear`, or `Sparkline`. If unset, the SignalFx default is used (`Sparkline`).
    """
    sort_by: pulumi.Output[str]
    """
    The property to use when sorting the elements. Use `value` if you want to sort by value. Must be prepended with `+` for ascending or `-` for descending (e.g. `-foo`). Note there are some special values for some of the options provided in the UX: `"value"` for Value, `"sf_originatingMetric"` for Metric, and `"sf_metric"` for plot.
    """
    unit_prefix: pulumi.Output[str]
    """
    Must be `"Metric"` or `"Binary`". `"Metric"` by default.
    """
    url: pulumi.Output[str]
    viz_options: pulumi.Output[list]
    """
    Plot-level customization options, associated with a publish statement.
    
      * `color` (`str`) - The color range to use. Must be either gray, blue, navy, orange, yellow, magenta, purple, violet, lilac, green, aquamarine.
      * `displayName` (`str`) - Specifies an alternate value for the Plot Name column of the Data Table associated with the chart.
      * `label` (`str`) - Label used in the publish statement that displays the plot (metric time series data) you want to customize.
      * `valuePrefix` (`str`)
      * `valueSuffix` (`str`)
      * `valueUnit` (`str`) - A unit to attach to this plot. Units support automatic scaling (eg thousands of bytes will be displayed as kilobytes). Values values are `Bit, Kilobit, Megabit, Gigabit, Terabit, Petabit, Exabit, Zettabit, Yottabit, Byte, Kibibyte, Mebibyte, Gigibyte, Tebibyte, Pebibyte, Exbibyte, Zebibyte, Yobibyte, Nanosecond, Microsecond, Millisecond, Second, Minute, Hour, Day, Week`.
        * `value_prefix`, `value_suffix` - (Optional) Arbitrary prefix/suffix to display with the value of this plot.
    """
    def __init__(__self__, resource_name, opts=None, color_by=None, color_scales=None, description=None, disable_sampling=None, legend_fields_to_hides=None, legend_options_fields=None, max_delay=None, max_precision=None, name=None, program_text=None, refresh_interval=None, secondary_visualization=None, sort_by=None, unit_prefix=None, viz_options=None, __props__=None, __name__=None, __opts__=None):
        """
        This chart type displays current data values in a list format.
        
        The name of each value in the chart reflects the name of the plot and any associated dimensions. We recommend you click the Pencil icon and give the plot a meaningful name, as in plot B below. Otherwise, just the raw metric name will be displayed on the chart, as in plot A below.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] color_by: Must be one of `"Scale"`, `"Dimension"` or `"Metric"`. `"Dimension"` by default.
        :param pulumi.Input[list] color_scales: Single color range including both the color to display for that range and the borders of the range. Example: `[{ gt = 60, color = "blue" }, { lte = 60, color = "yellow" }]`. Look at this [link](https://docs.signalfx.com/en/latest/charts/chart-options-tab.html).
        :param pulumi.Input[str] description: Description of the chart.
        :param pulumi.Input[bool] disable_sampling: If `false`, samples a subset of the output MTS, which improves UI performance. `false` by default.
        :param pulumi.Input[list] legend_fields_to_hides: List of properties that should not be displayed in the chart legend (i.e. dimension names). All the properties are visible by default. Deprecated, please use `legend_options_fields`.
        :param pulumi.Input[list] legend_options_fields: List of property names and enabled flags that should be displayed in the data table for the chart, in the order provided. This option cannot be used with `legend_fields_to_hide`.
               * `property` The name of the property to display. Note the special values of `plot_label` (corresponding with the API's `sf_metric`) which shows the label of the time series `publish()` and `metric` (corresponding with the API's `sf_originatingMetric`) that shows the name of the metric for the time series being displayed.
               * `enabled` True or False depending on if you want the property to be shown or hidden.
        :param pulumi.Input[float] max_delay: How long (in seconds) to wait for late datapoints.
        :param pulumi.Input[float] max_precision: Maximum number of digits to display when rounding values up or down.
        :param pulumi.Input[str] name: Name of the chart.
        :param pulumi.Input[str] program_text: Signalflow program text for the chart. More info at <https://developers.signalfx.com/docs/signalflow-overview>.
        :param pulumi.Input[float] refresh_interval: How often (in seconds) to refresh the values of the list.
        :param pulumi.Input[str] secondary_visualization: The type of secondary visualization. Can be `None`, `Radial`, `Linear`, or `Sparkline`. If unset, the SignalFx default is used (`Sparkline`).
        :param pulumi.Input[str] sort_by: The property to use when sorting the elements. Use `value` if you want to sort by value. Must be prepended with `+` for ascending or `-` for descending (e.g. `-foo`). Note there are some special values for some of the options provided in the UX: `"value"` for Value, `"sf_originatingMetric"` for Metric, and `"sf_metric"` for plot.
        :param pulumi.Input[str] unit_prefix: Must be `"Metric"` or `"Binary`". `"Metric"` by default.
        :param pulumi.Input[list] viz_options: Plot-level customization options, associated with a publish statement.
        
        The **color_scales** object supports the following:
        
          * `color` (`pulumi.Input[str]`) - The color range to use. Must be either gray, blue, navy, orange, yellow, magenta, purple, violet, lilac, green, aquamarine.
          * `gt` (`pulumi.Input[float]`) - Indicates the lower threshold non-inclusive value for this range.
          * `gte` (`pulumi.Input[float]`) - Indicates the lower threshold inclusive value for this range.
          * `lt` (`pulumi.Input[float]`) - Indicates the upper threshold non-inculsive value for this range.
          * `lte` (`pulumi.Input[float]`) - Indicates the upper threshold inclusive value for this range.
        
        The **legend_options_fields** object supports the following:
        
          * `enabled` (`pulumi.Input[bool]`)
          * `property` (`pulumi.Input[str]`)
        
        The **viz_options** object supports the following:
        
          * `color` (`pulumi.Input[str]`) - The color range to use. Must be either gray, blue, navy, orange, yellow, magenta, purple, violet, lilac, green, aquamarine.
          * `displayName` (`pulumi.Input[str]`) - Specifies an alternate value for the Plot Name column of the Data Table associated with the chart.
          * `label` (`pulumi.Input[str]`) - Label used in the publish statement that displays the plot (metric time series data) you want to customize.
          * `valuePrefix` (`pulumi.Input[str]`)
          * `valueSuffix` (`pulumi.Input[str]`)
          * `valueUnit` (`pulumi.Input[str]`) - A unit to attach to this plot. Units support automatic scaling (eg thousands of bytes will be displayed as kilobytes). Values values are `Bit, Kilobit, Megabit, Gigabit, Terabit, Petabit, Exabit, Zettabit, Yottabit, Byte, Kibibyte, Mebibyte, Gigibyte, Tebibyte, Pebibyte, Exbibyte, Zebibyte, Yobibyte, Nanosecond, Microsecond, Millisecond, Second, Minute, Hour, Day, Week`.
            * `value_prefix`, `value_suffix` - (Optional) Arbitrary prefix/suffix to display with the value of this plot.

        > This content is derived from https://github.com/terraform-providers/terraform-provider-signalfx/blob/master/website/docs/r/list_chart.html.markdown.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['color_by'] = color_by
            __props__['color_scales'] = color_scales
            __props__['description'] = description
            __props__['disable_sampling'] = disable_sampling
            __props__['legend_fields_to_hides'] = legend_fields_to_hides
            __props__['legend_options_fields'] = legend_options_fields
            __props__['max_delay'] = max_delay
            __props__['max_precision'] = max_precision
            __props__['name'] = name
            if program_text is None:
                raise TypeError("Missing required property 'program_text'")
            __props__['program_text'] = program_text
            __props__['refresh_interval'] = refresh_interval
            __props__['secondary_visualization'] = secondary_visualization
            __props__['sort_by'] = sort_by
            __props__['unit_prefix'] = unit_prefix
            __props__['viz_options'] = viz_options
            __props__['last_updated'] = None
            __props__['url'] = None
        super(ListChart, __self__).__init__(
            'signalfx:index/listChart:ListChart',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, color_by=None, color_scales=None, description=None, disable_sampling=None, last_updated=None, legend_fields_to_hides=None, legend_options_fields=None, max_delay=None, max_precision=None, name=None, program_text=None, refresh_interval=None, secondary_visualization=None, sort_by=None, unit_prefix=None, url=None, viz_options=None):
        """
        Get an existing ListChart resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.
        
        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] color_by: Must be one of `"Scale"`, `"Dimension"` or `"Metric"`. `"Dimension"` by default.
        :param pulumi.Input[list] color_scales: Single color range including both the color to display for that range and the borders of the range. Example: `[{ gt = 60, color = "blue" }, { lte = 60, color = "yellow" }]`. Look at this [link](https://docs.signalfx.com/en/latest/charts/chart-options-tab.html).
        :param pulumi.Input[str] description: Description of the chart.
        :param pulumi.Input[bool] disable_sampling: If `false`, samples a subset of the output MTS, which improves UI performance. `false` by default.
        :param pulumi.Input[list] legend_fields_to_hides: List of properties that should not be displayed in the chart legend (i.e. dimension names). All the properties are visible by default. Deprecated, please use `legend_options_fields`.
        :param pulumi.Input[list] legend_options_fields: List of property names and enabled flags that should be displayed in the data table for the chart, in the order provided. This option cannot be used with `legend_fields_to_hide`.
               * `property` The name of the property to display. Note the special values of `plot_label` (corresponding with the API's `sf_metric`) which shows the label of the time series `publish()` and `metric` (corresponding with the API's `sf_originatingMetric`) that shows the name of the metric for the time series being displayed.
               * `enabled` True or False depending on if you want the property to be shown or hidden.
        :param pulumi.Input[float] max_delay: How long (in seconds) to wait for late datapoints.
        :param pulumi.Input[float] max_precision: Maximum number of digits to display when rounding values up or down.
        :param pulumi.Input[str] name: Name of the chart.
        :param pulumi.Input[str] program_text: Signalflow program text for the chart. More info at <https://developers.signalfx.com/docs/signalflow-overview>.
        :param pulumi.Input[float] refresh_interval: How often (in seconds) to refresh the values of the list.
        :param pulumi.Input[str] secondary_visualization: The type of secondary visualization. Can be `None`, `Radial`, `Linear`, or `Sparkline`. If unset, the SignalFx default is used (`Sparkline`).
        :param pulumi.Input[str] sort_by: The property to use when sorting the elements. Use `value` if you want to sort by value. Must be prepended with `+` for ascending or `-` for descending (e.g. `-foo`). Note there are some special values for some of the options provided in the UX: `"value"` for Value, `"sf_originatingMetric"` for Metric, and `"sf_metric"` for plot.
        :param pulumi.Input[str] unit_prefix: Must be `"Metric"` or `"Binary`". `"Metric"` by default.
        :param pulumi.Input[list] viz_options: Plot-level customization options, associated with a publish statement.
        
        The **color_scales** object supports the following:
        
          * `color` (`pulumi.Input[str]`) - The color range to use. Must be either gray, blue, navy, orange, yellow, magenta, purple, violet, lilac, green, aquamarine.
          * `gt` (`pulumi.Input[float]`) - Indicates the lower threshold non-inclusive value for this range.
          * `gte` (`pulumi.Input[float]`) - Indicates the lower threshold inclusive value for this range.
          * `lt` (`pulumi.Input[float]`) - Indicates the upper threshold non-inculsive value for this range.
          * `lte` (`pulumi.Input[float]`) - Indicates the upper threshold inclusive value for this range.
        
        The **legend_options_fields** object supports the following:
        
          * `enabled` (`pulumi.Input[bool]`)
          * `property` (`pulumi.Input[str]`)
        
        The **viz_options** object supports the following:
        
          * `color` (`pulumi.Input[str]`) - The color range to use. Must be either gray, blue, navy, orange, yellow, magenta, purple, violet, lilac, green, aquamarine.
          * `displayName` (`pulumi.Input[str]`) - Specifies an alternate value for the Plot Name column of the Data Table associated with the chart.
          * `label` (`pulumi.Input[str]`) - Label used in the publish statement that displays the plot (metric time series data) you want to customize.
          * `valuePrefix` (`pulumi.Input[str]`)
          * `valueSuffix` (`pulumi.Input[str]`)
          * `valueUnit` (`pulumi.Input[str]`) - A unit to attach to this plot. Units support automatic scaling (eg thousands of bytes will be displayed as kilobytes). Values values are `Bit, Kilobit, Megabit, Gigabit, Terabit, Petabit, Exabit, Zettabit, Yottabit, Byte, Kibibyte, Mebibyte, Gigibyte, Tebibyte, Pebibyte, Exbibyte, Zebibyte, Yobibyte, Nanosecond, Microsecond, Millisecond, Second, Minute, Hour, Day, Week`.
            * `value_prefix`, `value_suffix` - (Optional) Arbitrary prefix/suffix to display with the value of this plot.

        > This content is derived from https://github.com/terraform-providers/terraform-provider-signalfx/blob/master/website/docs/r/list_chart.html.markdown.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()
        __props__["color_by"] = color_by
        __props__["color_scales"] = color_scales
        __props__["description"] = description
        __props__["disable_sampling"] = disable_sampling
        __props__["last_updated"] = last_updated
        __props__["legend_fields_to_hides"] = legend_fields_to_hides
        __props__["legend_options_fields"] = legend_options_fields
        __props__["max_delay"] = max_delay
        __props__["max_precision"] = max_precision
        __props__["name"] = name
        __props__["program_text"] = program_text
        __props__["refresh_interval"] = refresh_interval
        __props__["secondary_visualization"] = secondary_visualization
        __props__["sort_by"] = sort_by
        __props__["unit_prefix"] = unit_prefix
        __props__["url"] = url
        __props__["viz_options"] = viz_options
        return ListChart(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

