/*
 * Decompiled with CFR 0.152.
 */
package sklearn.ensemble.hist_gradient_boosting;

import java.util.ArrayList;
import java.util.function.Predicate;
import org.dmg.pmml.DataType;
import org.dmg.pmml.False;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.True;
import org.dmg.pmml.tree.BranchNode;
import org.dmg.pmml.tree.LeafNode;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.CategoryManager;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PredicateManager;
import org.jpmml.converter.Schema;
import sklearn.ensemble.hist_gradient_boosting.BinMapper;
import sklearn.ensemble.hist_gradient_boosting.TreePredictor;

public class TreePredictorUtil {
    private TreePredictorUtil() {
    }

    public static TreeModel encodeTreeModel(TreePredictor treePredictor, BinMapper binMapper, Schema schema) {
        PredicateManager predicateManager = new PredicateManager();
        return TreePredictorUtil.encodeTreeModel(treePredictor, binMapper, predicateManager, schema);
    }

    public static TreeModel encodeTreeModel(TreePredictor treePredictor, BinMapper binMapper, PredicateManager predicateManager, Schema schema) {
        int[] leaf = treePredictor.isLeaf();
        int[] leftChildren = treePredictor.getLeft();
        int[] rightChildren = treePredictor.getRight();
        int[] featureIdx = treePredictor.getFeatureIdx();
        int[] isCategorical = treePredictor.isCategorical();
        double[] thresholds = treePredictor.getThreshold();
        int[] bitsetIdx = treePredictor.getBitsetIdx();
        int[] missingGoToLeft = treePredictor.getMissingGoToLeft();
        double[] values = treePredictor.getValues();
        int[] rawLeftCatBitsets = treePredictor.getRawLeftCatBitsets();
        Node root = TreePredictorUtil.encodeNode(0, (org.dmg.pmml.Predicate)True.INSTANCE, leaf, leftChildren, rightChildren, featureIdx, isCategorical, thresholds, bitsetIdx, missingGoToLeft, values, binMapper, rawLeftCatBitsets, new CategoryManager(), predicateManager, schema);
        TreeModel treeModel = new TreeModel(MiningFunction.REGRESSION, ModelUtil.createMiningSchema((Label)schema.getLabel()), root).setSplitCharacteristic(TreeModel.SplitCharacteristic.BINARY_SPLIT).setMissingValueStrategy(TreeModel.MissingValueStrategy.DEFAULT_CHILD);
        return treeModel;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Node encodeNode(int index, org.dmg.pmml.Predicate predicate, int[] leaf, int[] leftChildren, int[] rightChildren, int[] featureIdx, int[] isCategorical, double[] thresholds, int[] bitsetIdx, int[] missingGoToLeft, double[] values, BinMapper binMapper, int[] rawLeftCatBitsets, CategoryManager categoryManager, PredicateManager predicateManager, Schema schema) {
        Integer id = index;
        if (leaf[index] == 0) {
            void var21_45;
            void var20_39;
            boolean defaultLeft;
            boolean categorical;
            Feature feature = schema.getFeature(featureIdx[index]);
            CategoryManager leftCategoryManager = categoryManager;
            CategoryManager rightCategoryManager = categoryManager;
            boolean bl = categorical = isCategorical != null && isCategorical[index] == 1;
            if (categorical) {
                if (!(feature instanceof CategoricalFeature)) throw new IllegalArgumentException();
                CategoricalFeature categoricalFeature = (CategoricalFeature)feature;
                FieldName name = categoricalFeature.getName();
                Predicate valueFilter = categoryManager.getValueFilter(name);
                int row = bitsetIdx[index];
                int rawLeftCatBitset = rawLeftCatBitsets[row * 8];
                ArrayList<Object> leftValues = new ArrayList<Object>();
                ArrayList<Object> rightValues = new ArrayList<Object>();
                for (int i = 0; i < categoricalFeature.size(); ++i) {
                    Object value = categoricalFeature.getValue(i);
                    if (!valueFilter.test(value)) continue;
                    if ((rawLeftCatBitset >> i & 1) == 1) {
                        leftValues.add(value);
                        continue;
                    }
                    rightValues.add(value);
                }
                leftCategoryManager = categoryManager.fork(name, leftValues);
                rightCategoryManager = categoryManager.fork(name, rightValues);
                if (!leftValues.isEmpty()) {
                    org.dmg.pmml.Predicate predicate2 = predicateManager.createPredicate((Feature)categoricalFeature, leftValues);
                } else {
                    False false_ = False.INSTANCE;
                }
                if (!rightValues.isEmpty()) {
                    org.dmg.pmml.Predicate predicate3 = predicateManager.createPredicate((Feature)categoricalFeature, rightValues);
                } else {
                    False false_ = False.INSTANCE;
                }
                defaultLeft = missingGoToLeft[index] == 1;
            } else {
                double threshold = thresholds[index];
                if (feature instanceof BinaryFeature) {
                    BinaryFeature binaryFeature = (BinaryFeature)feature;
                    if (threshold != 0.5) {
                        throw new IllegalArgumentException();
                    }
                    Object value = binaryFeature.getValue();
                    org.dmg.pmml.Predicate predicate4 = predicateManager.createSimplePredicate((Feature)binaryFeature, SimplePredicate.Operator.NOT_EQUAL, value);
                    org.dmg.pmml.Predicate predicate5 = predicateManager.createSimplePredicate((Feature)binaryFeature, SimplePredicate.Operator.EQUAL, value);
                    defaultLeft = true;
                } else {
                    ContinuousFeature continuousFeature = feature.toContinuousFeature(DataType.DOUBLE);
                    Double value = threshold;
                    org.dmg.pmml.Predicate predicate6 = predicateManager.createSimplePredicate((Feature)continuousFeature, SimplePredicate.Operator.LESS_OR_EQUAL, (Object)value);
                    org.dmg.pmml.Predicate predicate7 = predicateManager.createSimplePredicate((Feature)continuousFeature, SimplePredicate.Operator.GREATER_THAN, (Object)value);
                    defaultLeft = missingGoToLeft[index] == 1;
                }
            }
            Node leftChild = TreePredictorUtil.encodeNode(leftChildren[index], (org.dmg.pmml.Predicate)var20_39, leaf, leftChildren, rightChildren, featureIdx, isCategorical, thresholds, bitsetIdx, missingGoToLeft, values, binMapper, rawLeftCatBitsets, leftCategoryManager, predicateManager, schema);
            Node rightChild = TreePredictorUtil.encodeNode(rightChildren[index], (org.dmg.pmml.Predicate)var21_45, leaf, leftChildren, rightChildren, featureIdx, isCategorical, thresholds, bitsetIdx, missingGoToLeft, values, binMapper, rawLeftCatBitsets, rightCategoryManager, predicateManager, schema);
            return new BranchNode(null, predicate).setId((Object)id).setDefaultChild(defaultLeft ? leftChild.getId() : rightChild.getId()).addNodes(leftChild, rightChild);
        }
        if (leaf[index] != 1) throw new IllegalArgumentException();
        return new LeafNode((Object)values[index], predicate).setId((Object)id);
    }
}

