/*
 * Decompiled with CFR 0.152.
 */
package sklearn.ensemble.stacking;

import java.util.Collections;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.mining.MiningModel;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.DerivedOutputField;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.Schema;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.HasEstimatorEnsemble;
import sklearn.Regressor;
import sklearn.ensemble.stacking.StackingUtil;

public class StackingRegressor
extends Regressor
implements HasEstimatorEnsemble<Regressor> {
    public StackingRegressor(String module, String name) {
        super(module, name);
    }

    public MiningModel encodeModel(Schema schema) {
        List<? extends Regressor> estimators = this.getEstimators();
        Regressor finalEstimator = this.getFinalEstimator();
        Boolean passthrough = this.getPassthrough();
        List<String> stackMethod = this.getStackMethod();
        final ContinuousLabel continuousLabel = (ContinuousLabel)schema.getLabel();
        StackingUtil.PredictFunction predictFunction = new StackingUtil.PredictFunction(){

            @Override
            public List<Feature> apply(int index, Model model, String stackMethod, SkLearnEncoder encoder) {
                if (!"predict".equals(stackMethod)) {
                    throw new IllegalArgumentException(stackMethod);
                }
                OutputField predictedOutputField = ModelUtil.createPredictedField((FieldName)FieldNameUtil.create((String)stackMethod, (Object[])new Object[]{index}), (OpType)OpType.CONTINUOUS, (DataType)continuousLabel.getDataType());
                DerivedOutputField predictedField = encoder.createDerivedField(model, predictedOutputField, false);
                return Collections.singletonList(new ContinuousFeature((PMMLEncoder)encoder, (Field)predictedField));
            }
        };
        return StackingUtil.encodeStacking(estimators, stackMethod, predictFunction, finalEstimator, passthrough, schema);
    }

    @Override
    public List<? extends Regressor> getEstimators() {
        return this.getList("estimators_", Regressor.class);
    }

    public Regressor getFinalEstimator() {
        return (Regressor)this.get("final_estimator_", Regressor.class);
    }

    public Boolean getPassthrough() {
        return this.getBoolean("passthrough");
    }

    public List<String> getStackMethod() {
        return this.getList("stack_method_", String.class);
    }
}

