/*
 * Decompiled with CFR 0.152.
 */
package sklearn.linear_model.logistic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.razorvine.pickle.objects.ClassDict;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.regression.RegressionModel;
import org.dmg.pmml.regression.RegressionTable;
import org.jpmml.converter.CMatrixUtil;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.Schema;
import org.jpmml.converter.SchemaUtil;
import org.jpmml.converter.Transformation;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.converter.regression.RegressionModelUtil;
import org.jpmml.python.ClassDictUtil;
import sklearn.SkLearnUtil;
import sklearn.linear_model.LinearClassifier;

public class LogisticRegression
extends LinearClassifier {
    public LogisticRegression(String module, String name) {
        super(module, name);
    }

    @Override
    public Model encodeModel(Schema schema) {
        String multiClass = this.getMultiClass();
        if ("auto".equals(multiClass)) {
            throw new IllegalArgumentException("Attribute '" + ClassDictUtil.formatMember((ClassDict)this, (String)"multi_class") + "' must be explicitly set to the 'ovr' or 'multinomial' value");
        }
        if ("multinomial".equals(multiClass)) {
            return this.encodeMultinomialModel(schema);
        }
        if ("ovr".equals(multiClass)) {
            return this.encodeOvRModel(schema);
        }
        throw new IllegalArgumentException(multiClass);
    }

    private Model encodeMultinomialModel(Schema schema) {
        String sklearnVersion = this.getSkLearnVersion();
        int[] shape = this.getCoefShape();
        int numberOfClasses = shape[0];
        int numberOfFeatures = shape[1];
        List<? extends Number> coef = this.getCoef();
        List<? extends Number> intercept = this.getIntercept();
        PMMLEncoder encoder = schema.getEncoder();
        CategoricalLabel categoricalLabel = (CategoricalLabel)schema.getLabel();
        List features = schema.getFeatures();
        if (numberOfClasses == 1) {
            boolean corrected;
            SchemaUtil.checkSize((int)2, (CategoricalLabel)categoricalLabel);
            boolean bl = corrected = sklearnVersion != null && SkLearnUtil.compareVersion(sklearnVersion, "0.20") >= 0;
            if (!corrected) {
                return this.encodeOvRModel(schema);
            }
            Schema segmentSchema = schema.toRelabeledSchema(null);
            RegressionModel firstRegressionModel = RegressionModelUtil.createRegression((List)features, (List)CMatrixUtil.getRow(coef, (int)1, (int)numberOfFeatures, (int)0), (Number)intercept.get(0), null, (Schema)segmentSchema).setOutput(ModelUtil.createPredictedOutput((FieldName)FieldName.create((String)"decisionFunction"), (OpType)OpType.CONTINUOUS, (DataType)DataType.DOUBLE, (Transformation[])new Transformation[0]));
            ContinuousFeature feature = new ContinuousFeature(encoder, FieldName.create((String)"decisionFunction"), DataType.DOUBLE);
            RegressionTable passiveRegressionTable = RegressionModelUtil.createRegressionTable(Collections.singletonList(feature), Collections.singletonList(-1.0), (Number)0.0).setTargetCategory(categoricalLabel.getValue(0));
            RegressionTable activeRegressionTable = RegressionModelUtil.createRegressionTable(Collections.singletonList(feature), Collections.singletonList(1.0), (Number)0.0).setTargetCategory(categoricalLabel.getValue(1));
            ArrayList<RegressionTable> regressionTables = new ArrayList<RegressionTable>();
            regressionTables.add(passiveRegressionTable);
            regressionTables.add(activeRegressionTable);
            RegressionModel secondRegressionModel = new RegressionModel(MiningFunction.CLASSIFICATION, ModelUtil.createMiningSchema((Label)categoricalLabel), regressionTables).setNormalizationMethod(RegressionModel.NormalizationMethod.SOFTMAX).setOutput(ModelUtil.createProbabilityOutput((DataType)DataType.DOUBLE, (CategoricalLabel)categoricalLabel));
            return MiningModelUtil.createModelChain(Arrays.asList(firstRegressionModel, secondRegressionModel));
        }
        if (numberOfClasses >= 3) {
            SchemaUtil.checkSize((int)numberOfClasses, (CategoricalLabel)categoricalLabel);
            ArrayList<RegressionTable> regressionTables = new ArrayList<RegressionTable>();
            for (int i = 0; i < categoricalLabel.size(); ++i) {
                RegressionTable regressionTable = RegressionModelUtil.createRegressionTable((List)features, (List)CMatrixUtil.getRow(coef, (int)numberOfClasses, (int)numberOfFeatures, (int)i), (Number)intercept.get(i)).setTargetCategory(categoricalLabel.getValue(i));
                regressionTables.add(regressionTable);
            }
            RegressionModel regressionModel = new RegressionModel(MiningFunction.CLASSIFICATION, ModelUtil.createMiningSchema((Label)categoricalLabel), regressionTables).setNormalizationMethod(RegressionModel.NormalizationMethod.SOFTMAX).setOutput(ModelUtil.createProbabilityOutput((DataType)DataType.DOUBLE, (CategoricalLabel)categoricalLabel));
            return regressionModel;
        }
        throw new IllegalArgumentException();
    }

    private Model encodeOvRModel(Schema schema) {
        return super.encodeModel(schema);
    }

    public String getMultiClass() {
        String multiClass = this.getString("multi_class");
        if ("warn".equals(multiClass)) {
            return "ovr";
        }
        return multiClass;
    }
}

