/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.h2o;

import com.google.common.primitives.Doubles;
import hex.genmodel.MojoModel;
import hex.genmodel.algos.glm.GlmMultinomialMojoModel;
import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.regression.RegressionModel;
import org.dmg.pmml.regression.RegressionTable;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.SchemaUtil;
import org.jpmml.converter.regression.RegressionModelUtil;
import org.jpmml.h2o.GlmMojoModelBaseConverter;

public class GlmMultinomialMojoModelConverter
extends GlmMojoModelBaseConverter<GlmMultinomialMojoModel> {
    public GlmMultinomialMojoModelConverter(GlmMultinomialMojoModel model) {
        super(model);
    }

    public RegressionModel encodeModel(Schema schema) {
        GlmMultinomialMojoModel model = (GlmMultinomialMojoModel)this.getModel();
        CategoricalLabel categoricalLabel = (CategoricalLabel)schema.getLabel();
        List features = schema.getFeatures();
        List beta = Doubles.asList((double[])GlmMultinomialMojoModelConverter.getBeta((MojoModel)model));
        SchemaUtil.checkSize((int)(beta.size() - categoricalLabel.size()), (CategoricalLabel)categoricalLabel, (List)features);
        ArrayList<RegressionTable> regressionTables = new ArrayList<RegressionTable>();
        int offset = 0;
        for (int i = 0; i < categoricalLabel.size(); ++i) {
            List coefficients = beta.subList(offset, offset + features.size());
            Double intercept = (Double)beta.get(offset + features.size());
            RegressionTable regressionTable = RegressionModelUtil.createRegressionTable((List)features, coefficients, (Number)intercept).setTargetCategory(categoricalLabel.getValue(i));
            regressionTables.add(regressionTable);
            offset += features.size() + 1;
        }
        RegressionModel regressionModel = new RegressionModel(MiningFunction.CLASSIFICATION, ModelUtil.createMiningSchema((Label)categoricalLabel), regressionTables).setNormalizationMethod(RegressionModel.NormalizationMethod.SOFTMAX).setOutput(ModelUtil.createProbabilityOutput((DataType)DataType.DOUBLE, (CategoricalLabel)categoricalLabel));
        return regressionModel;
    }
}

