/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.coxph;

import hex.genmodel.MojoModel;
import java.util.Map;

public class CoxPHMojoModel
extends MojoModel {
    double[] _coef;
    Map<Strata, Integer> _strata;
    int _strata_len;
    double[][] _x_mean_cat;
    double[][] _x_mean_num;
    int[] _cat_offsets;
    int _cats;
    double[] _lpBase;
    boolean _useAllFactorLevels;

    CoxPHMojoModel(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    @Override
    public double[] score0(double[] row, double[] predictions) {
        predictions[0] = this.forCategories(row) + this.forOtherColumns(row) - this.forStrata(row);
        return predictions;
    }

    private double forOtherColumns(double[] row) {
        double result = 0.0;
        int catOffsetDiff = this._cat_offsets[this._cats] - this._cats;
        int i = this._cats;
        while (i + catOffsetDiff < this._coef.length) {
            result += this._coef[catOffsetDiff + i] * row[i + this._strata_len];
            ++i;
        }
        return result;
    }

    private double forStrata(double[] row) {
        int strata = this.strataForRow(row);
        return this._lpBase[strata];
    }

    private double forCategories(double[] row) {
        double result = 0.0;
        if (!this._useAllFactorLevels) {
            for (int category = 0; category < this._cat_offsets.length - 1; ++category) {
                if (row[category] == 0.0) continue;
                result += this.forOneCategory(row, category, 1);
            }
        } else {
            for (int category = 0; category < this._cat_offsets.length - 1; ++category) {
                result += this.forOneCategory(row, category, 0);
            }
        }
        return result;
    }

    private double forOneCategory(double[] row, int category, int lowestFactorValue) {
        int value = (int)row[category] - lowestFactorValue;
        if ((double)value != row[category] - (double)lowestFactorValue) {
            throw new IllegalArgumentException("categorical value out of range");
        }
        int x = value + this._cat_offsets[category];
        if (x < this._cat_offsets[category + 1]) {
            return this._coef[x];
        }
        return 0.0;
    }

    double[] computeLpBase() {
        int _numStart = this._x_mean_cat.length >= 1 ? this._x_mean_cat[0].length : 0;
        int size = 0 < this._strata.size() ? this._strata.size() : 1;
        double[] lpBase = new double[size];
        for (int s = 0; s < size; ++s) {
            int i;
            for (i = 0; i < this._x_mean_cat[s].length; ++i) {
                int n = s;
                lpBase[n] = lpBase[n] + this._x_mean_cat[s][i] * this._coef[i];
            }
            for (i = 0; i < this._x_mean_num[s].length; ++i) {
                int n = s;
                lpBase[n] = lpBase[n] + this._x_mean_num[s][i] * this._coef[i + _numStart];
            }
        }
        return lpBase;
    }

    private int strataForRow(double[] row) {
        if (0 == this._strata.size()) {
            return 0;
        }
        Strata o = new Strata(row, this._strata_len);
        return this._strata.get(o);
    }

    static class Strata {
        final double[] strata;
        final int strataLen;
        final int hashCode;

        public Strata(double[] strata, int strataLen) {
            this.strata = strata;
            int hash = 11;
            for (int i = 0; i < strataLen; ++i) {
                hash *= 13;
                hash += 17 * (int)strata[i];
            }
            this.hashCode = hash;
            this.strataLen = strataLen;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Strata that = (Strata)o;
            if (this.hashCode != that.hashCode) {
                return false;
            }
            if (this.strataLen != that.strataLen) {
                return false;
            }
            for (int i = 0; i < this.strataLen; ++i) {
                if ((int)this.strata[i] == (int)that.strata[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

