/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.gam;

import hex.genmodel.ModelMojoReader;
import hex.genmodel.algos.gam.GamMojoModel;
import hex.genmodel.algos.gam.GamMojoModelBase;
import hex.genmodel.algos.gam.GamMojoMultinomialModel;
import hex.genmodel.utils.DistributionFamily;
import java.io.IOException;
import java.nio.ByteBuffer;

public class GamMojoReader
extends ModelMojoReader<GamMojoModelBase> {
    @Override
    public String getModelName() {
        return "Generalized Additive Model";
    }

    @Override
    protected void readModelData() throws IOException {
        ((GamMojoModelBase)this._model)._useAllFactorLevels = this.readkv("use_all_factor_levels", false);
        ((GamMojoModelBase)this._model)._numExpandedGamCols = this.readkv("num_expanded_gam_columns", 0);
        ((GamMojoModelBase)this._model)._family = DistributionFamily.valueOf((String)this.readkv("family"));
        ((GamMojoModelBase)this._model)._cats = this.readkv("cats", -1);
        ((GamMojoModelBase)this._model)._nums = (Integer)this.readkv("num");
        ((GamMojoModelBase)this._model)._numsCenter = (Integer)this.readkv("numsCenter");
        ((GamMojoModelBase)this._model)._catNAFills = this.readkv("catNAFills", new int[0]);
        ((GamMojoModelBase)this._model)._numNAFills = this.readkv("numNAFills", new double[0]);
        ((GamMojoModelBase)this._model)._numNAFillsCenter = this.readkv("numNAFillsCenter", new double[0]);
        ((GamMojoModelBase)this._model)._meanImputation = this.readkv("mean_imputation", false);
        ((GamMojoModelBase)this._model)._betaSizePerClass = this.readkv("beta length per class", 0);
        ((GamMojoModelBase)this._model)._catOffsets = this.readkv("cat_offsets", new int[0]);
        if (!((GamMojoModelBase)this._model)._family.equals((Object)DistributionFamily.multinomial)) {
            ((GamMojoModelBase)this._model)._link_function = GamMojoReader.readLinkFunction((String)this.readkv("link"), ((GamMojoModelBase)this._model)._family);
        }
        ((GamMojoModelBase)this._model)._tweedieLinkPower = this.readkv("tweedie_link_power", 0.0);
        ((GamMojoModelBase)this._model)._betaCenterSizePerClass = this.readkv("beta center length per class", 0);
        if (((GamMojoModelBase)this._model)._family.equals((Object)DistributionFamily.multinomial) || ((GamMojoModelBase)this._model)._family.equals((Object)DistributionFamily.ordinal)) {
            ((GamMojoModelBase)this._model)._beta_multinomial_no_center = this.readRectangularDoubleArray("beta_multinomial", ((GamMojoModelBase)this._model)._nclasses, ((GamMojoModelBase)this._model)._betaSizePerClass);
            ((GamMojoModelBase)this._model)._beta_multinomial_center = this.readRectangularDoubleArray("beta_multinomial_centering", ((GamMojoModelBase)this._model)._nclasses, ((GamMojoModelBase)this._model)._betaCenterSizePerClass);
        } else {
            ((GamMojoModelBase)this._model)._beta_no_center = (double[])this.readkv("beta");
            ((GamMojoModelBase)this._model)._beta_center = (double[])this.readkv("beta_center");
        }
        ((GamMojoModelBase)this._model)._num_knots = (int[])this.readkv("num_knots");
        int num_gam_columns = ((GamMojoModelBase)this._model)._num_knots.length;
        ((GamMojoModelBase)this._model)._gam_columns = this.readStringArrays(num_gam_columns, "gam_columns");
        ((GamMojoModelBase)this._model)._num_gam_columns = ((GamMojoModelBase)this._model)._gam_columns.length;
        ((GamMojoModelBase)this._model)._totFeatureSize = (Integer)this.readkv("total feature size");
        ((GamMojoModelBase)this._model)._names_no_centering = this.readStringArrays(((GamMojoModelBase)this._model)._totFeatureSize, "_names_no_centering");
        ((GamMojoModelBase)this._model)._bs = (int[])this.readkv("bs");
        ((GamMojoModelBase)this._model)._knots = new double[num_gam_columns][];
        ((GamMojoModelBase)this._model)._binvD = new double[num_gam_columns][][];
        ((GamMojoModelBase)this._model)._zTranspose = new double[num_gam_columns][][];
        ((GamMojoModelBase)this._model)._knots = this.read2DArrayDiffLength("knots", ((GamMojoModelBase)this._model)._knots, ((GamMojoModelBase)this._model)._num_knots);
        ((GamMojoModelBase)this._model)._gamColNames = new String[num_gam_columns][];
        ((GamMojoModelBase)this._model)._gamColNamesCenter = new String[num_gam_columns][];
        for (int gInd = 0; gInd < num_gam_columns; ++gInd) {
            int num_knots = ((GamMojoModelBase)this._model)._num_knots[gInd];
            ((GamMojoModelBase)this._model)._binvD[gInd] = new double[num_knots - 2][num_knots];
            ((GamMojoModelBase)this._model)._binvD[gInd] = this.readRectangularDoubleArray(((GamMojoModelBase)this._model)._gam_columns[gInd] + "_binvD", ((GamMojoModelBase)this._model)._binvD[gInd].length, ((GamMojoModelBase)this._model)._binvD[gInd][0].length);
            ((GamMojoModelBase)this._model)._zTranspose[gInd] = new double[num_knots - 1][num_knots];
            ((GamMojoModelBase)this._model)._zTranspose[gInd] = this.readRectangularDoubleArray(((GamMojoModelBase)this._model)._gam_columns[gInd] + "_zTranspose", ((GamMojoModelBase)this._model)._zTranspose[gInd].length, ((GamMojoModelBase)this._model)._zTranspose[gInd][0].length);
            ((GamMojoModelBase)this._model)._gamColNames[gInd] = this.readStringArrays(num_knots, "gamColNames_" + ((GamMojoModelBase)this._model)._gam_columns[gInd]);
            ((GamMojoModelBase)this._model)._gamColNamesCenter[gInd] = this.readStringArrays(num_knots - 1, "gamColNamesCenter_" + ((GamMojoModelBase)this._model)._gam_columns[gInd]);
        }
        ((GamMojoModelBase)this._model).init();
    }

    String[] readStringArrays(int aSize, String title) throws IOException {
        String[] stringArrays = new String[aSize];
        int counter = 0;
        for (String line : this.readtext(title)) {
            stringArrays[counter++] = line;
        }
        return stringArrays;
    }

    double[][] read2DArrayDiffLength(String title, double[][] row, int[] num_knots) throws IOException {
        int numGamColumns = num_knots.length;
        ByteBuffer bb = ByteBuffer.wrap(this.readblob(title));
        for (int i = 0; i < numGamColumns; ++i) {
            row[i] = new double[num_knots[i]];
            for (int j = 0; j < row[i].length; ++j) {
                row[i][j] = bb.getDouble();
            }
        }
        return row;
    }

    @Override
    protected GamMojoModelBase makeModel(String[] columns, String[][] domains, String responseColumn) {
        String family = (String)this.readkv("family");
        if ("multinomial".equals(family) || "ordinal".equals(family)) {
            return new GamMojoMultinomialModel(columns, domains, responseColumn);
        }
        return new GamMojoModel(columns, domains, responseColumn);
    }

    @Override
    public String mojoVersion() {
        return "1.00";
    }
}

