/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.easy.error;

import hex.genmodel.GenModel;
import hex.genmodel.easy.EasyPredictModelWrapper;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class CountingErrorConsumer
extends EasyPredictModelWrapper.ErrorConsumer {
    private Map<String, AtomicLong> dataTransformationErrorsCountPerColumn;
    private Map<String, AtomicLong> unknownCategoricalsPerColumn;
    private Map<String, ConcurrentMap<Object, AtomicLong>> unseenCategoricalsCollector;
    private final boolean collectUnseenCategoricals;
    private static final Config DEFAULT_CONFIG = new Config();

    public CountingErrorConsumer(GenModel model) {
        this(model, DEFAULT_CONFIG);
    }

    public CountingErrorConsumer(GenModel model, Config config) {
        this.collectUnseenCategoricals = config.isCollectUnseenCategoricals();
        this.initializeDataTransformationErrorsCount(model);
        this.initializeUnknownCategoricals(model);
    }

    private void initializeDataTransformationErrorsCount(GenModel model) {
        String responseColumnName = model.isSupervised() ? model.getResponseName() : null;
        this.dataTransformationErrorsCountPerColumn = new ConcurrentHashMap<String, AtomicLong>();
        for (String column : model.getNames()) {
            if (model.isSupervised() && column.equals(responseColumnName)) continue;
            this.dataTransformationErrorsCountPerColumn.put(column, new AtomicLong());
        }
        this.dataTransformationErrorsCountPerColumn = Collections.unmodifiableMap(this.dataTransformationErrorsCountPerColumn);
    }

    private void initializeUnknownCategoricals(GenModel model) {
        this.unknownCategoricalsPerColumn = new ConcurrentHashMap<String, AtomicLong>();
        this.unseenCategoricalsCollector = new ConcurrentHashMap<String, ConcurrentMap<Object, AtomicLong>>();
        for (int i = 0; i < model.getNumCols(); ++i) {
            String[] domainValues = model.getDomainValues(i);
            if (domainValues == null) continue;
            this.unknownCategoricalsPerColumn.put(model.getNames()[i], new AtomicLong());
            if (!this.collectUnseenCategoricals) continue;
            this.unseenCategoricalsCollector.put(model.getNames()[i], new ConcurrentHashMap());
        }
        this.unknownCategoricalsPerColumn = Collections.unmodifiableMap(this.unknownCategoricalsPerColumn);
    }

    @Override
    public void dataTransformError(String columnName, Object value, String message) {
        this.dataTransformationErrorsCountPerColumn.get(columnName).incrementAndGet();
    }

    @Override
    public void unseenCategorical(String columnName, Object value, String message) {
        this.unknownCategoricalsPerColumn.get(columnName).incrementAndGet();
        if (this.collectUnseenCategoricals) {
            ConcurrentMap<Object, AtomicLong> columnCollector = this.unseenCategoricalsCollector.get(columnName);
            assert (columnCollector != null);
            AtomicLong counter = (AtomicLong)columnCollector.get(value);
            if (counter != null) {
                counter.incrementAndGet();
            } else {
                counter = columnCollector.putIfAbsent(value, new AtomicLong(1L));
                if (counter != null) {
                    counter.incrementAndGet();
                }
            }
        }
    }

    public long getTotalUnknownCategoricalLevelsSeen() {
        long total = 0L;
        for (AtomicLong l : this.unknownCategoricalsPerColumn.values()) {
            total += l.get();
        }
        return total;
    }

    public Map<String, AtomicLong> getUnknownCategoricalsPerColumn() {
        return this.unknownCategoricalsPerColumn;
    }

    public Map<Object, AtomicLong> getUnseenCategoricals(String column) {
        if (!this.collectUnseenCategoricals) {
            throw new IllegalStateException("Unseen categorical values collection was not enabled.");
        }
        return this.unseenCategoricalsCollector.get(column);
    }

    public Map<String, AtomicLong> getDataTransformationErrorsCountPerColumn() {
        return this.dataTransformationErrorsCountPerColumn;
    }

    public long getDataTransformationErrorsCount() {
        long total = 0L;
        for (AtomicLong l : this.dataTransformationErrorsCountPerColumn.values()) {
            total += l.get();
        }
        return total;
    }

    public static class Config {
        private boolean collectUnseenCategoricals;

        public boolean isCollectUnseenCategoricals() {
            return this.collectUnseenCategoricals;
        }

        public void setCollectUnseenCategoricals(boolean collectUnseenCategoricals) {
            this.collectUnseenCategoricals = collectUnseenCategoricals;
        }
    }
}

