/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.utils;

public class ParseUtils {
    public static double[] parseArrayOfDoubles(String input) {
        if (!input.startsWith("[") || !input.endsWith("]")) {
            throw new NumberFormatException("Array should be enclosed in square brackets");
        }
        String[] parts = input.substring(1, input.length() - 1).split(",");
        double[] res = new double[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            res[i] = Double.parseDouble(parts[i].trim());
        }
        return res;
    }

    public static long[] parseArrayOfLongs(String input) {
        if (!input.startsWith("[") || !input.endsWith("]")) {
            throw new NumberFormatException("Array should be enclosed in square brackets");
        }
        String[] parts = input.substring(1, input.length() - 1).split(",");
        long[] res = new long[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            res[i] = Long.parseLong(parts[i].trim());
        }
        return res;
    }

    public static int[] parseArrayOfInts(String input) {
        if (!input.startsWith("[") || !input.endsWith("]")) {
            throw new NumberFormatException("Array should be enclosed in square brackets");
        }
        String[] parts = input.substring(1, input.length() - 1).split(",");
        int[] res = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            res[i] = Integer.parseInt(parts[i].trim());
        }
        return res;
    }

    public static Object tryParse(String input, Object defVal) {
        if (input.equals("null")) {
            return defVal;
        }
        if (input.equals("true")) {
            return true;
        }
        if (input.equals("false")) {
            return false;
        }
        if (defVal != null && !defVal.getClass().isArray()) {
            if (defVal instanceof Boolean) {
                return Boolean.valueOf(input);
            }
            if (defVal instanceof Long) {
                return Long.valueOf(input);
            }
            if (defVal instanceof Integer) {
                return Integer.valueOf(input);
            }
            if (defVal instanceof Float) {
                return Float.valueOf(input);
            }
            if (defVal instanceof Double) {
                return Double.valueOf(input);
            }
        }
        if (defVal != null && defVal.getClass().isArray()) {
            if (defVal instanceof Long[]) {
                return ParseUtils.parseArrayOfLongs(input);
            }
            if (defVal instanceof Integer[]) {
                return ParseUtils.parseArrayOfInts(input);
            }
            if (defVal instanceof Double[]) {
                return ParseUtils.parseArrayOfDoubles(input);
            }
        }
        if ("[]".equals(input) && defVal != null && defVal.getClass().isArray()) {
            return defVal;
        }
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException e) {
            if (defVal instanceof Number && !(defVal instanceof Double) && !(defVal instanceof Float) && !(defVal instanceof Long)) {
                throw e;
            }
            try {
                return Long.parseLong(input);
            }
            catch (NumberFormatException e2) {
                if (defVal instanceof Number && !(defVal instanceof Double)) {
                    throw e2;
                }
                try {
                    return Double.parseDouble(input);
                }
                catch (NumberFormatException e3) {
                    if (defVal instanceof Number) {
                        throw e3;
                    }
                    try {
                        return ParseUtils.parseArrayOfInts(input);
                    }
                    catch (NumberFormatException e4) {
                        if (defVal instanceof int[]) {
                            throw e4;
                        }
                        try {
                            return ParseUtils.parseArrayOfLongs(input);
                        }
                        catch (NumberFormatException e5) {
                            if (defVal instanceof long[]) {
                                throw e5;
                            }
                            try {
                                return ParseUtils.parseArrayOfDoubles(input);
                            }
                            catch (NumberFormatException e6) {
                                if (defVal instanceof double[]) {
                                    throw e6;
                                }
                                return input;
                            }
                        }
                    }
                }
            }
        }
    }
}

