/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import hex.genmodel.GenModel;
import hex.genmodel.MojoModel;
import hex.genmodel.easy.EasyPredictModelWrapper;
import hex.genmodel.easy.RowData;
import hex.genmodel.easy.exception.PredictException;
import hex.genmodel.easy.prediction.AbstractPrediction;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class H2OPredictor {
    private static final boolean DEBUG = false;
    private static boolean useLabels = false;
    private String[] labels = null;
    private EasyPredictModelWrapper model = null;
    private static final Gson gson = new Gson();
    private final Type MapType = new TypeToken<Map<String, Object>>(){}.getType();

    public H2OPredictor(String ojoFileName, String modelName) {
        try {
            if (ojoFileName == null) {
                throw new Exception("file name can't be null");
            }
            if (ojoFileName.endsWith(".jar")) {
                this.loadPojo(ojoFileName, modelName);
            } else if (ojoFileName.endsWith(".zip")) {
                this.loadMojo(ojoFileName);
            } else {
                throw new Exception("unknown model archive type");
            }
            if (useLabels) {
                this.labels = this.model.getResponseDomainValues();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private GenModel loadClassFromJar(String jarFileName, String modelName) throws Exception {
        if (!new File(jarFileName).isFile()) {
            throw new FileNotFoundException("Can't read " + jarFileName);
        }
        try {
            URL url = new File(jarFileName).toURI().toURL();
            URLClassLoader loader = URLClassLoader.newInstance(new URL[]{url}, this.getClass().getClassLoader());
            String packagePrefix = "";
            String className = packagePrefix + modelName;
            Class<?> clazz = loader.loadClass(className);
            Class<GenModel> modelClass = clazz.asSubclass(GenModel.class);
            return modelClass.newInstance();
        }
        catch (MalformedURLException e) {
            throw new Exception("Can't use Jar file" + jarFileName);
        }
        catch (ClassNotFoundException e) {
            throw new Exception("Can't find model " + modelName + " in jar file " + jarFileName);
        }
        catch (InstantiationException e) {
            throw new Exception("Can't find model " + modelName + " in jar file " + jarFileName);
        }
        catch (IllegalAccessException e) {
            throw new Exception("Can't find model " + modelName + " in jar file " + jarFileName);
        }
    }

    private void loadPojo(String jarFileName, String modelName) throws Exception {
        GenModel rawModel = this.loadClassFromJar(jarFileName, modelName);
        this.model = new EasyPredictModelWrapper(rawModel);
    }

    private void loadMojo(String zipFileName) throws Exception {
        MojoModel rawModel = MojoModel.load(zipFileName);
        this.model = new EasyPredictModelWrapper(rawModel);
    }

    private RowData jsonToRowData(String json) {
        try {
            return (RowData)gson.fromJson(json, RowData.class);
        }
        catch (JsonSyntaxException e) {
            throw new JsonSyntaxException("Malformed JSON");
        }
    }

    private RowData[] jsonToRowDataArray(String json) {
        try {
            return (RowData[])gson.fromJson(json, RowData[].class);
        }
        catch (JsonSyntaxException e) {
            throw new JsonSyntaxException("Malformed JSON Array");
        }
    }

    private String predictRow(RowData row) throws PredictException {
        if (this.model == null) {
            throw new PredictException("No model loaded");
        }
        if (gson == null) {
            throw new PredictException("Gson not available");
        }
        if (row == null) {
            throw new PredictException("No row data");
        }
        AbstractPrediction pr = this.model.predict(row);
        String json = gson.toJson((Object)pr);
        if (useLabels) {
            Map map = (Map)gson.fromJson(json, this.MapType);
            map.put("responseDomainValues", this.labels);
            json = gson.toJson((Object)map);
        }
        return json;
    }

    public static String predict3(String ojoFileName, String modelName, String jsonArgs) {
        try {
            boolean isJson;
            H2OPredictor p = new H2OPredictor(ojoFileName, modelName);
            if (ojoFileName == null) {
                throw new Exception("file name can't be null");
            }
            if (ojoFileName.endsWith(".jar")) {
                p.loadPojo(ojoFileName, modelName);
            } else if (ojoFileName.endsWith(".zip")) {
                p.loadMojo(ojoFileName);
            } else {
                throw new Exception("unknown model archive type");
            }
            if (jsonArgs == null || jsonArgs.length() == 0) {
                throw new Exception("empty json argument");
            }
            char first = jsonArgs.trim().charAt(0);
            boolean bl = isJson = first == '{' || first == '[';
            if (!isJson) {
                byte[] bytes = H2OPredictor.readFile(jsonArgs);
                first = (jsonArgs = new String(bytes)).trim().charAt(0);
                isJson = first == '{' || first == '[';
            }
            String result = "";
            if (first == '[') {
                RowData[] rows = p.jsonToRowDataArray(jsonArgs);
                result = result + "[ ";
                for (RowData row : rows) {
                    if (!result.trim().endsWith("[")) {
                        result = result + ", ";
                    }
                    result = result + p.predictRow(row);
                }
                result = result + " ]";
            } else {
                RowData row = p.jsonToRowData(jsonArgs);
                result = p.predictRow(row);
            }
            return result;
        }
        catch (Exception e) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("error", H2OPredictor.stackTraceToString(e));
            String s = gson.toJson(map);
            return s;
        }
    }

    public String pred(String jsonArgs) {
        try {
            return this.predictRow(this.jsonToRowData(jsonArgs));
        }
        catch (Exception e) {
            return "{ \"error\": \"" + H2OPredictor.stackTraceToString(e) + "\" }";
        }
    }

    public static String predict2(String ojoFileName, String jsonArgs) {
        String modelName = ojoFileName.replace(".zip", "").replace(".jar", "");
        int index = modelName.lastIndexOf(File.separatorChar);
        if (index != -1) {
            modelName = modelName.substring(index + 1);
        }
        return H2OPredictor.predict3(ojoFileName, modelName, jsonArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readFile(String filePath) throws IOException {
        StringBuffer fileData = new StringBuffer();
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new FileReader(filePath));
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
            }
        }
        return fileData.toString().getBytes();
    }

    private static String stackTraceToString(Throwable e) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        e.printStackTrace(ps);
        String s = os.toString();
        try {
            ps.close();
            os.close();
        }
        catch (IOException e1) {
            return "Can't get stack trace from throwable " + e.getMessage();
        }
        return s;
    }

    public static void main(String[] args) {
        if (args.length > 0 && args[0].equals("-l")) {
            useLabels = true;
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        String result = "";
        result = args.length == 2 ? H2OPredictor.predict2(args[0], args[1].replaceAll("\\\\", "")) : (args.length == 3 ? H2OPredictor.predict3(args[0], args[1], args[2].replaceAll("\\\\", "")) : "{ \"error\": \"Neeed 2 or 3 args have " + args.length + ", \"usage\": \"mojoFile jsonString  or: jarFile modelName jsonString\" } ");
        System.out.println(result);
    }
}

