"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlbToFargate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const defaults = require("@aws-solutions-constructs/core");
const core_1 = require("@aws-solutions-constructs/core");
class AlbToFargate extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckAlbProps(props);
        defaults.CheckFargateProps(props);
        defaults.CheckVpcProps(props);
        // Obtain VPC for construct (existing or created)
        this.vpc = defaults.buildVpc(scope, {
            existingVpc: props.existingVpc,
            defaultVpcProps: props.publicApi ? defaults.DefaultPublicPrivateVpcProps() : defaults.DefaultIsolatedVpcProps(),
            userVpcProps: props.vpcProps,
            constructVpcProps: { enableDnsHostnames: true, enableDnsSupport: true }
        });
        // Set up the ALB
        this.loadBalancer = defaults.ObtainAlb(scope, `${id}-lb`, {
            vpc: this.vpc,
            publicApi: props.publicApi,
            existingLoadBalancerObj: props.existingLoadBalancerObj,
            loadBalancerProps: props.loadBalancerProps,
            logAccessLogs: props.logAlbAccessLogs,
            loggingBucketProps: props.albLoggingBucketProps
        });
        const newListener = this.loadBalancer.listeners.length === 0;
        // If there's no listener, then we add one here
        if (newListener) {
            this.listener = defaults.AddListener(this, id, this.loadBalancer, props.listenerProps);
        }
        else {
            this.listener = core_1.GetActiveListener(this.loadBalancer.listeners);
        }
        if (props.existingFargateServiceObject) {
            this.service = props.existingFargateServiceObject;
            // CheckFargateProps confirms that the container is provided
            this.container = props.existingContainerDefinitionObject;
        }
        else {
            const createFargateServiceResponse = defaults.CreateFargateService(scope, id, {
                constructVpc: this.vpc,
                clientClusterProps: props.clusterProps,
                ecrRepositoryArn: props.ecrRepositoryArn,
                ecrImageVersion: props.ecrImageVersion,
                clientFargateTaskDefinitionProps: props.fargateTaskDefinitionProps,
                clientContainerDefinitionProps: props.containerDefinitionProps,
                clientFargateServiceProps: props.fargateServiceProps
            });
            this.service = createFargateServiceResponse.service;
            this.container = createFargateServiceResponse.containerDefinition;
        }
        // Add the Fargate Service to the
        // to the ALB Listener we set up earlier
        const applicationTargetGroupProps = defaults.consolidateProps(defaults.DefaultApplicationTargetGroupProps(this.vpc), props.targetGroupProps);
        const newTargetGroup = defaults.AddFargateTarget(scope, `${id}-target`, this.listener, this.service, props.ruleProps, applicationTargetGroupProps);
        if (newListener && this.listener) {
            const levelOneListener = this.listener.node.defaultChild;
            const cfnTargetGroup = newTargetGroup.node.defaultChild;
            levelOneListener.addDependency(cfnTargetGroup);
        }
    }
}
exports.AlbToFargate = AlbToFargate;
_a = JSII_RTTI_SYMBOL_1;
AlbToFargate[_a] = { fqn: "@aws-solutions-constructs/aws-alb-fargate.AlbToFargate", version: "2.61.0" };
//# sourceMappingURL=data:application/json;base64,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