# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RegisteredDomainArgs', 'RegisteredDomain']

@pulumi.input_type
class RegisteredDomainArgs:
    def __init__(__self__, *,
                 contact_id: pulumi.Input[_builtins.int],
                 name: pulumi.Input[_builtins.str],
                 auto_renew_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dnssec_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 extended_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 premium_price: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['RegisteredDomainTimeoutsArgs']] = None,
                 transfer_lock_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 whois_privacy_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a RegisteredDomain resource.
        :param pulumi.Input[_builtins.int] contact_id: The ID of the contact to be used for the domain registration. The contact ID can be changed after the domain has been registered. The change will result in a new registrant change this may result in a [60-day lock](https://support.dnsimple.com/articles/icann-60-day-lock-registrant-change/).
        :param pulumi.Input[_builtins.str] name: The domain name to be registered
        :param pulumi.Input[_builtins.bool] auto_renew_enabled: Whether the domain should be set to auto-renew (default: `false`)
        :param pulumi.Input[_builtins.bool] dnssec_enabled: Whether the domain should have DNSSEC enabled (default: `false`)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] extended_attributes: A map of extended attributes to be set for the domain registration. To see if there are any required extended attributes for any TLD use our [Lists the TLD Extended Attributes API](https://developer.dnsimple.com/v2/tlds/#getTldExtendedAttributes). The values provided in the `extended_attributes` will also be sent when a registrant change is initiated as part of changing the `contact_id`.
        :param pulumi.Input[_builtins.str] premium_price: The premium price for the domain registration. This is only required if the domain is a premium domain. You can use our [Check domain API](https://developer.dnsimple.com/v2/registrar/#checkDomain) to check if a domain is premium. And [Retrieve domain prices API](https://developer.dnsimple.com/v2/registrar/#getDomainPrices) to retrieve the premium price for a domain.
        :param pulumi.Input['RegisteredDomainTimeoutsArgs'] timeouts: (see below for nested schema)
               
               # Attributes Reference
        :param pulumi.Input[_builtins.bool] transfer_lock_enabled: Whether the domain transfer lock protection is enabled (default: `true`)
        :param pulumi.Input[_builtins.bool] whois_privacy_enabled: Whether the domain should have WhoIs privacy enabled (default: `false`)
        """
        pulumi.set(__self__, "contact_id", contact_id)
        pulumi.set(__self__, "name", name)
        if auto_renew_enabled is not None:
            pulumi.set(__self__, "auto_renew_enabled", auto_renew_enabled)
        if dnssec_enabled is not None:
            pulumi.set(__self__, "dnssec_enabled", dnssec_enabled)
        if extended_attributes is not None:
            pulumi.set(__self__, "extended_attributes", extended_attributes)
        if premium_price is not None:
            pulumi.set(__self__, "premium_price", premium_price)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if transfer_lock_enabled is not None:
            pulumi.set(__self__, "transfer_lock_enabled", transfer_lock_enabled)
        if whois_privacy_enabled is not None:
            pulumi.set(__self__, "whois_privacy_enabled", whois_privacy_enabled)

    @_builtins.property
    @pulumi.getter(name="contactId")
    def contact_id(self) -> pulumi.Input[_builtins.int]:
        """
        The ID of the contact to be used for the domain registration. The contact ID can be changed after the domain has been registered. The change will result in a new registrant change this may result in a [60-day lock](https://support.dnsimple.com/articles/icann-60-day-lock-registrant-change/).
        """
        return pulumi.get(self, "contact_id")

    @contact_id.setter
    def contact_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "contact_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The domain name to be registered
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewEnabled")
    def auto_renew_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the domain should be set to auto-renew (default: `false`)
        """
        return pulumi.get(self, "auto_renew_enabled")

    @auto_renew_enabled.setter
    def auto_renew_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew_enabled", value)

    @_builtins.property
    @pulumi.getter(name="dnssecEnabled")
    def dnssec_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the domain should have DNSSEC enabled (default: `false`)
        """
        return pulumi.get(self, "dnssec_enabled")

    @dnssec_enabled.setter
    def dnssec_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dnssec_enabled", value)

    @_builtins.property
    @pulumi.getter(name="extendedAttributes")
    def extended_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of extended attributes to be set for the domain registration. To see if there are any required extended attributes for any TLD use our [Lists the TLD Extended Attributes API](https://developer.dnsimple.com/v2/tlds/#getTldExtendedAttributes). The values provided in the `extended_attributes` will also be sent when a registrant change is initiated as part of changing the `contact_id`.
        """
        return pulumi.get(self, "extended_attributes")

    @extended_attributes.setter
    def extended_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "extended_attributes", value)

    @_builtins.property
    @pulumi.getter(name="premiumPrice")
    def premium_price(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The premium price for the domain registration. This is only required if the domain is a premium domain. You can use our [Check domain API](https://developer.dnsimple.com/v2/registrar/#checkDomain) to check if a domain is premium. And [Retrieve domain prices API](https://developer.dnsimple.com/v2/registrar/#getDomainPrices) to retrieve the premium price for a domain.
        """
        return pulumi.get(self, "premium_price")

    @premium_price.setter
    def premium_price(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "premium_price", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['RegisteredDomainTimeoutsArgs']]:
        """
        (see below for nested schema)

        # Attributes Reference
        """
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['RegisteredDomainTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="transferLockEnabled")
    def transfer_lock_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the domain transfer lock protection is enabled (default: `true`)
        """
        return pulumi.get(self, "transfer_lock_enabled")

    @transfer_lock_enabled.setter
    def transfer_lock_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "transfer_lock_enabled", value)

    @_builtins.property
    @pulumi.getter(name="whoisPrivacyEnabled")
    def whois_privacy_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the domain should have WhoIs privacy enabled (default: `false`)
        """
        return pulumi.get(self, "whois_privacy_enabled")

    @whois_privacy_enabled.setter
    def whois_privacy_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "whois_privacy_enabled", value)


@pulumi.input_type
class _RegisteredDomainState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_renew_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 contact_id: Optional[pulumi.Input[_builtins.int]] = None,
                 dnssec_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 domain_registration: Optional[pulumi.Input['RegisteredDomainDomainRegistrationArgs']] = None,
                 expires_at: Optional[pulumi.Input[_builtins.str]] = None,
                 extended_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 premium_price: Optional[pulumi.Input[_builtins.str]] = None,
                 registrant_change: Optional[pulumi.Input['RegisteredDomainRegistrantChangeArgs']] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['RegisteredDomainTimeoutsArgs']] = None,
                 transfer_lock_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 unicode_name: Optional[pulumi.Input[_builtins.str]] = None,
                 whois_privacy_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering RegisteredDomain resources.
        :param pulumi.Input[_builtins.bool] auto_renew_enabled: Whether the domain should be set to auto-renew (default: `false`)
        :param pulumi.Input[_builtins.int] contact_id: The ID of the contact to be used for the domain registration. The contact ID can be changed after the domain has been registered. The change will result in a new registrant change this may result in a [60-day lock](https://support.dnsimple.com/articles/icann-60-day-lock-registrant-change/).
        :param pulumi.Input[_builtins.bool] dnssec_enabled: Whether the domain should have DNSSEC enabled (default: `false`)
        :param pulumi.Input['RegisteredDomainDomainRegistrationArgs'] domain_registration: The domain registration details. (see below for nested schema)
               
               <a id="nestedblock--timeouts"></a>
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] extended_attributes: A map of extended attributes to be set for the domain registration. To see if there are any required extended attributes for any TLD use our [Lists the TLD Extended Attributes API](https://developer.dnsimple.com/v2/tlds/#getTldExtendedAttributes). The values provided in the `extended_attributes` will also be sent when a registrant change is initiated as part of changing the `contact_id`.
        :param pulumi.Input[_builtins.str] name: The domain name to be registered
        :param pulumi.Input[_builtins.str] premium_price: The premium price for the domain registration. This is only required if the domain is a premium domain. You can use our [Check domain API](https://developer.dnsimple.com/v2/registrar/#checkDomain) to check if a domain is premium. And [Retrieve domain prices API](https://developer.dnsimple.com/v2/registrar/#getDomainPrices) to retrieve the premium price for a domain.
        :param pulumi.Input['RegisteredDomainRegistrantChangeArgs'] registrant_change: The registrant change details.
        :param pulumi.Input[_builtins.str] state: The state of the domain.
        :param pulumi.Input['RegisteredDomainTimeoutsArgs'] timeouts: (see below for nested schema)
               
               # Attributes Reference
        :param pulumi.Input[_builtins.bool] transfer_lock_enabled: Whether the domain transfer lock protection is enabled (default: `true`)
        :param pulumi.Input[_builtins.str] unicode_name: The domain name in Unicode format.
        :param pulumi.Input[_builtins.bool] whois_privacy_enabled: Whether the domain should have WhoIs privacy enabled (default: `false`)
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if auto_renew_enabled is not None:
            pulumi.set(__self__, "auto_renew_enabled", auto_renew_enabled)
        if contact_id is not None:
            pulumi.set(__self__, "contact_id", contact_id)
        if dnssec_enabled is not None:
            pulumi.set(__self__, "dnssec_enabled", dnssec_enabled)
        if domain_registration is not None:
            pulumi.set(__self__, "domain_registration", domain_registration)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if extended_attributes is not None:
            pulumi.set(__self__, "extended_attributes", extended_attributes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if premium_price is not None:
            pulumi.set(__self__, "premium_price", premium_price)
        if registrant_change is not None:
            pulumi.set(__self__, "registrant_change", registrant_change)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if transfer_lock_enabled is not None:
            pulumi.set(__self__, "transfer_lock_enabled", transfer_lock_enabled)
        if unicode_name is not None:
            pulumi.set(__self__, "unicode_name", unicode_name)
        if whois_privacy_enabled is not None:
            pulumi.set(__self__, "whois_privacy_enabled", whois_privacy_enabled)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewEnabled")
    def auto_renew_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the domain should be set to auto-renew (default: `false`)
        """
        return pulumi.get(self, "auto_renew_enabled")

    @auto_renew_enabled.setter
    def auto_renew_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew_enabled", value)

    @_builtins.property
    @pulumi.getter(name="contactId")
    def contact_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the contact to be used for the domain registration. The contact ID can be changed after the domain has been registered. The change will result in a new registrant change this may result in a [60-day lock](https://support.dnsimple.com/articles/icann-60-day-lock-registrant-change/).
        """
        return pulumi.get(self, "contact_id")

    @contact_id.setter
    def contact_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "contact_id", value)

    @_builtins.property
    @pulumi.getter(name="dnssecEnabled")
    def dnssec_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the domain should have DNSSEC enabled (default: `false`)
        """
        return pulumi.get(self, "dnssec_enabled")

    @dnssec_enabled.setter
    def dnssec_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dnssec_enabled", value)

    @_builtins.property
    @pulumi.getter(name="domainRegistration")
    def domain_registration(self) -> Optional[pulumi.Input['RegisteredDomainDomainRegistrationArgs']]:
        """
        The domain registration details. (see below for nested schema)

        <a id="nestedblock--timeouts"></a>
        """
        return pulumi.get(self, "domain_registration")

    @domain_registration.setter
    def domain_registration(self, value: Optional[pulumi.Input['RegisteredDomainDomainRegistrationArgs']]):
        pulumi.set(self, "domain_registration", value)

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "expires_at")

    @expires_at.setter
    def expires_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expires_at", value)

    @_builtins.property
    @pulumi.getter(name="extendedAttributes")
    def extended_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of extended attributes to be set for the domain registration. To see if there are any required extended attributes for any TLD use our [Lists the TLD Extended Attributes API](https://developer.dnsimple.com/v2/tlds/#getTldExtendedAttributes). The values provided in the `extended_attributes` will also be sent when a registrant change is initiated as part of changing the `contact_id`.
        """
        return pulumi.get(self, "extended_attributes")

    @extended_attributes.setter
    def extended_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "extended_attributes", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name to be registered
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="premiumPrice")
    def premium_price(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The premium price for the domain registration. This is only required if the domain is a premium domain. You can use our [Check domain API](https://developer.dnsimple.com/v2/registrar/#checkDomain) to check if a domain is premium. And [Retrieve domain prices API](https://developer.dnsimple.com/v2/registrar/#getDomainPrices) to retrieve the premium price for a domain.
        """
        return pulumi.get(self, "premium_price")

    @premium_price.setter
    def premium_price(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "premium_price", value)

    @_builtins.property
    @pulumi.getter(name="registrantChange")
    def registrant_change(self) -> Optional[pulumi.Input['RegisteredDomainRegistrantChangeArgs']]:
        """
        The registrant change details.
        """
        return pulumi.get(self, "registrant_change")

    @registrant_change.setter
    def registrant_change(self, value: Optional[pulumi.Input['RegisteredDomainRegistrantChangeArgs']]):
        pulumi.set(self, "registrant_change", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of the domain.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['RegisteredDomainTimeoutsArgs']]:
        """
        (see below for nested schema)

        # Attributes Reference
        """
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['RegisteredDomainTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="transferLockEnabled")
    def transfer_lock_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the domain transfer lock protection is enabled (default: `true`)
        """
        return pulumi.get(self, "transfer_lock_enabled")

    @transfer_lock_enabled.setter
    def transfer_lock_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "transfer_lock_enabled", value)

    @_builtins.property
    @pulumi.getter(name="unicodeName")
    def unicode_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name in Unicode format.
        """
        return pulumi.get(self, "unicode_name")

    @unicode_name.setter
    def unicode_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unicode_name", value)

    @_builtins.property
    @pulumi.getter(name="whoisPrivacyEnabled")
    def whois_privacy_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the domain should have WhoIs privacy enabled (default: `false`)
        """
        return pulumi.get(self, "whois_privacy_enabled")

    @whois_privacy_enabled.setter
    def whois_privacy_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "whois_privacy_enabled", value)


@pulumi.type_token("dnsimple:index/registeredDomain:RegisteredDomain")
class RegisteredDomain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 contact_id: Optional[pulumi.Input[_builtins.int]] = None,
                 dnssec_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 extended_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 premium_price: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['RegisteredDomainTimeoutsArgs', 'RegisteredDomainTimeoutsArgsDict']]] = None,
                 transfer_lock_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 whois_privacy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Provides a DNSimple registered domain resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dnsimple as dnsimple

        alice_main = dnsimple.Contact("alice_main",
            label="Alice Appleseed",
            first_name="Alice Main",
            last_name="Appleseed",
            organization_name="Contoso",
            job_title="Manager",
            address1="Level 1, 2 Main St",
            address2="Marsfield",
            city="San Francisco",
            state_province="California",
            postal_code="90210",
            country="US",
            phone="+1401239523",
            fax="+1849491024",
            email="apple@contoso.com")
        appleseed_bio = dnsimple.RegisteredDomain("appleseed_bio",
            name="appleseed.bio",
            contact_id=alice_main.id,
            auto_renew_enabled=True,
            transfer_lock_enabled=True,
            whois_privacy_enabled=True,
            dnssec_enabled=False,
            extended_attributes={
                "bio_agree": "I Agree",
            })
        ```

        ## Import

        DNSimple registered domains can be imported using their domain name and **optionally** with domain registration ID.

        **Importing registered domain example.com**

        bash

        ```sh
        $ pulumi import dnsimple:index/registeredDomain:RegisteredDomain resource_name example.com
        ```

        **Importing registered domain example.com with domain registration ID 1234**

        bash

        ```sh
        $ pulumi import dnsimple:index/registeredDomain:RegisteredDomain resource_name example.com_1234
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_renew_enabled: Whether the domain should be set to auto-renew (default: `false`)
        :param pulumi.Input[_builtins.int] contact_id: The ID of the contact to be used for the domain registration. The contact ID can be changed after the domain has been registered. The change will result in a new registrant change this may result in a [60-day lock](https://support.dnsimple.com/articles/icann-60-day-lock-registrant-change/).
        :param pulumi.Input[_builtins.bool] dnssec_enabled: Whether the domain should have DNSSEC enabled (default: `false`)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] extended_attributes: A map of extended attributes to be set for the domain registration. To see if there are any required extended attributes for any TLD use our [Lists the TLD Extended Attributes API](https://developer.dnsimple.com/v2/tlds/#getTldExtendedAttributes). The values provided in the `extended_attributes` will also be sent when a registrant change is initiated as part of changing the `contact_id`.
        :param pulumi.Input[_builtins.str] name: The domain name to be registered
        :param pulumi.Input[_builtins.str] premium_price: The premium price for the domain registration. This is only required if the domain is a premium domain. You can use our [Check domain API](https://developer.dnsimple.com/v2/registrar/#checkDomain) to check if a domain is premium. And [Retrieve domain prices API](https://developer.dnsimple.com/v2/registrar/#getDomainPrices) to retrieve the premium price for a domain.
        :param pulumi.Input[Union['RegisteredDomainTimeoutsArgs', 'RegisteredDomainTimeoutsArgsDict']] timeouts: (see below for nested schema)
               
               # Attributes Reference
        :param pulumi.Input[_builtins.bool] transfer_lock_enabled: Whether the domain transfer lock protection is enabled (default: `true`)
        :param pulumi.Input[_builtins.bool] whois_privacy_enabled: Whether the domain should have WhoIs privacy enabled (default: `false`)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegisteredDomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DNSimple registered domain resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dnsimple as dnsimple

        alice_main = dnsimple.Contact("alice_main",
            label="Alice Appleseed",
            first_name="Alice Main",
            last_name="Appleseed",
            organization_name="Contoso",
            job_title="Manager",
            address1="Level 1, 2 Main St",
            address2="Marsfield",
            city="San Francisco",
            state_province="California",
            postal_code="90210",
            country="US",
            phone="+1401239523",
            fax="+1849491024",
            email="apple@contoso.com")
        appleseed_bio = dnsimple.RegisteredDomain("appleseed_bio",
            name="appleseed.bio",
            contact_id=alice_main.id,
            auto_renew_enabled=True,
            transfer_lock_enabled=True,
            whois_privacy_enabled=True,
            dnssec_enabled=False,
            extended_attributes={
                "bio_agree": "I Agree",
            })
        ```

        ## Import

        DNSimple registered domains can be imported using their domain name and **optionally** with domain registration ID.

        **Importing registered domain example.com**

        bash

        ```sh
        $ pulumi import dnsimple:index/registeredDomain:RegisteredDomain resource_name example.com
        ```

        **Importing registered domain example.com with domain registration ID 1234**

        bash

        ```sh
        $ pulumi import dnsimple:index/registeredDomain:RegisteredDomain resource_name example.com_1234
        ```

        :param str resource_name: The name of the resource.
        :param RegisteredDomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegisteredDomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 contact_id: Optional[pulumi.Input[_builtins.int]] = None,
                 dnssec_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 extended_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 premium_price: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['RegisteredDomainTimeoutsArgs', 'RegisteredDomainTimeoutsArgsDict']]] = None,
                 transfer_lock_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 whois_privacy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegisteredDomainArgs.__new__(RegisteredDomainArgs)

            __props__.__dict__["auto_renew_enabled"] = auto_renew_enabled
            if contact_id is None and not opts.urn:
                raise TypeError("Missing required property 'contact_id'")
            __props__.__dict__["contact_id"] = contact_id
            __props__.__dict__["dnssec_enabled"] = dnssec_enabled
            __props__.__dict__["extended_attributes"] = extended_attributes
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["premium_price"] = premium_price
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["transfer_lock_enabled"] = transfer_lock_enabled
            __props__.__dict__["whois_privacy_enabled"] = whois_privacy_enabled
            __props__.__dict__["account_id"] = None
            __props__.__dict__["domain_registration"] = None
            __props__.__dict__["expires_at"] = None
            __props__.__dict__["registrant_change"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["unicode_name"] = None
        super(RegisteredDomain, __self__).__init__(
            'dnsimple:index/registeredDomain:RegisteredDomain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.int]] = None,
            auto_renew_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            contact_id: Optional[pulumi.Input[_builtins.int]] = None,
            dnssec_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            domain_registration: Optional[pulumi.Input[Union['RegisteredDomainDomainRegistrationArgs', 'RegisteredDomainDomainRegistrationArgsDict']]] = None,
            expires_at: Optional[pulumi.Input[_builtins.str]] = None,
            extended_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            premium_price: Optional[pulumi.Input[_builtins.str]] = None,
            registrant_change: Optional[pulumi.Input[Union['RegisteredDomainRegistrantChangeArgs', 'RegisteredDomainRegistrantChangeArgsDict']]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['RegisteredDomainTimeoutsArgs', 'RegisteredDomainTimeoutsArgsDict']]] = None,
            transfer_lock_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            unicode_name: Optional[pulumi.Input[_builtins.str]] = None,
            whois_privacy_enabled: Optional[pulumi.Input[_builtins.bool]] = None) -> 'RegisteredDomain':
        """
        Get an existing RegisteredDomain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_renew_enabled: Whether the domain should be set to auto-renew (default: `false`)
        :param pulumi.Input[_builtins.int] contact_id: The ID of the contact to be used for the domain registration. The contact ID can be changed after the domain has been registered. The change will result in a new registrant change this may result in a [60-day lock](https://support.dnsimple.com/articles/icann-60-day-lock-registrant-change/).
        :param pulumi.Input[_builtins.bool] dnssec_enabled: Whether the domain should have DNSSEC enabled (default: `false`)
        :param pulumi.Input[Union['RegisteredDomainDomainRegistrationArgs', 'RegisteredDomainDomainRegistrationArgsDict']] domain_registration: The domain registration details. (see below for nested schema)
               
               <a id="nestedblock--timeouts"></a>
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] extended_attributes: A map of extended attributes to be set for the domain registration. To see if there are any required extended attributes for any TLD use our [Lists the TLD Extended Attributes API](https://developer.dnsimple.com/v2/tlds/#getTldExtendedAttributes). The values provided in the `extended_attributes` will also be sent when a registrant change is initiated as part of changing the `contact_id`.
        :param pulumi.Input[_builtins.str] name: The domain name to be registered
        :param pulumi.Input[_builtins.str] premium_price: The premium price for the domain registration. This is only required if the domain is a premium domain. You can use our [Check domain API](https://developer.dnsimple.com/v2/registrar/#checkDomain) to check if a domain is premium. And [Retrieve domain prices API](https://developer.dnsimple.com/v2/registrar/#getDomainPrices) to retrieve the premium price for a domain.
        :param pulumi.Input[Union['RegisteredDomainRegistrantChangeArgs', 'RegisteredDomainRegistrantChangeArgsDict']] registrant_change: The registrant change details.
        :param pulumi.Input[_builtins.str] state: The state of the domain.
        :param pulumi.Input[Union['RegisteredDomainTimeoutsArgs', 'RegisteredDomainTimeoutsArgsDict']] timeouts: (see below for nested schema)
               
               # Attributes Reference
        :param pulumi.Input[_builtins.bool] transfer_lock_enabled: Whether the domain transfer lock protection is enabled (default: `true`)
        :param pulumi.Input[_builtins.str] unicode_name: The domain name in Unicode format.
        :param pulumi.Input[_builtins.bool] whois_privacy_enabled: Whether the domain should have WhoIs privacy enabled (default: `false`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegisteredDomainState.__new__(_RegisteredDomainState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["auto_renew_enabled"] = auto_renew_enabled
        __props__.__dict__["contact_id"] = contact_id
        __props__.__dict__["dnssec_enabled"] = dnssec_enabled
        __props__.__dict__["domain_registration"] = domain_registration
        __props__.__dict__["expires_at"] = expires_at
        __props__.__dict__["extended_attributes"] = extended_attributes
        __props__.__dict__["name"] = name
        __props__.__dict__["premium_price"] = premium_price
        __props__.__dict__["registrant_change"] = registrant_change
        __props__.__dict__["state"] = state
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["transfer_lock_enabled"] = transfer_lock_enabled
        __props__.__dict__["unicode_name"] = unicode_name
        __props__.__dict__["whois_privacy_enabled"] = whois_privacy_enabled
        return RegisteredDomain(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="autoRenewEnabled")
    def auto_renew_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the domain should be set to auto-renew (default: `false`)
        """
        return pulumi.get(self, "auto_renew_enabled")

    @_builtins.property
    @pulumi.getter(name="contactId")
    def contact_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the contact to be used for the domain registration. The contact ID can be changed after the domain has been registered. The change will result in a new registrant change this may result in a [60-day lock](https://support.dnsimple.com/articles/icann-60-day-lock-registrant-change/).
        """
        return pulumi.get(self, "contact_id")

    @_builtins.property
    @pulumi.getter(name="dnssecEnabled")
    def dnssec_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the domain should have DNSSEC enabled (default: `false`)
        """
        return pulumi.get(self, "dnssec_enabled")

    @_builtins.property
    @pulumi.getter(name="domainRegistration")
    def domain_registration(self) -> pulumi.Output['outputs.RegisteredDomainDomainRegistration']:
        """
        The domain registration details. (see below for nested schema)

        <a id="nestedblock--timeouts"></a>
        """
        return pulumi.get(self, "domain_registration")

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "expires_at")

    @_builtins.property
    @pulumi.getter(name="extendedAttributes")
    def extended_attributes(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of extended attributes to be set for the domain registration. To see if there are any required extended attributes for any TLD use our [Lists the TLD Extended Attributes API](https://developer.dnsimple.com/v2/tlds/#getTldExtendedAttributes). The values provided in the `extended_attributes` will also be sent when a registrant change is initiated as part of changing the `contact_id`.
        """
        return pulumi.get(self, "extended_attributes")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The domain name to be registered
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="premiumPrice")
    def premium_price(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The premium price for the domain registration. This is only required if the domain is a premium domain. You can use our [Check domain API](https://developer.dnsimple.com/v2/registrar/#checkDomain) to check if a domain is premium. And [Retrieve domain prices API](https://developer.dnsimple.com/v2/registrar/#getDomainPrices) to retrieve the premium price for a domain.
        """
        return pulumi.get(self, "premium_price")

    @_builtins.property
    @pulumi.getter(name="registrantChange")
    def registrant_change(self) -> pulumi.Output['outputs.RegisteredDomainRegistrantChange']:
        """
        The registrant change details.
        """
        return pulumi.get(self, "registrant_change")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The state of the domain.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.RegisteredDomainTimeouts']]:
        """
        (see below for nested schema)

        # Attributes Reference
        """
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter(name="transferLockEnabled")
    def transfer_lock_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the domain transfer lock protection is enabled (default: `true`)
        """
        return pulumi.get(self, "transfer_lock_enabled")

    @_builtins.property
    @pulumi.getter(name="unicodeName")
    def unicode_name(self) -> pulumi.Output[_builtins.str]:
        """
        The domain name in Unicode format.
        """
        return pulumi.get(self, "unicode_name")

    @_builtins.property
    @pulumi.getter(name="whoisPrivacyEnabled")
    def whois_privacy_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the domain should have WhoIs privacy enabled (default: `false`)
        """
        return pulumi.get(self, "whois_privacy_enabled")

