# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ZoneArgs', 'Zone']

@pulumi.input_type
class ZoneArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 active: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Zone resource.
        :param pulumi.Input[_builtins.str] name: The zone name
               
               # Attributes Reference
        :param pulumi.Input[_builtins.bool] active: Whether the zone is active.
        """
        pulumi.set(__self__, "name", name)
        if active is not None:
            pulumi.set(__self__, "active", active)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The zone name

        # Attributes Reference
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the zone is active.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "active", value)


@pulumi.input_type
class _ZoneState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.int]] = None,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 last_transferred_at: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 reverse: Optional[pulumi.Input[_builtins.bool]] = None,
                 secondary: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Zone resources.
        :param pulumi.Input[_builtins.int] account_id: The account ID for the zone.
        :param pulumi.Input[_builtins.bool] active: Whether the zone is active.
        :param pulumi.Input[_builtins.str] last_transferred_at: The last time the zone was transferred only applicable for **secondary** zones.
        :param pulumi.Input[_builtins.str] name: The zone name
               
               # Attributes Reference
        :param pulumi.Input[_builtins.bool] reverse: Whether the zone is a reverse zone.
        :param pulumi.Input[_builtins.bool] secondary: Whether the zone is a secondary zone.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if last_transferred_at is not None:
            pulumi.set(__self__, "last_transferred_at", last_transferred_at)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if reverse is not None:
            pulumi.set(__self__, "reverse", reverse)
        if secondary is not None:
            pulumi.set(__self__, "secondary", secondary)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The account ID for the zone.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the zone is active.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "active", value)

    @_builtins.property
    @pulumi.getter(name="lastTransferredAt")
    def last_transferred_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The last time the zone was transferred only applicable for **secondary** zones.
        """
        return pulumi.get(self, "last_transferred_at")

    @last_transferred_at.setter
    def last_transferred_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_transferred_at", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone name

        # Attributes Reference
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def reverse(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the zone is a reverse zone.
        """
        return pulumi.get(self, "reverse")

    @reverse.setter
    def reverse(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reverse", value)

    @_builtins.property
    @pulumi.getter
    def secondary(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the zone is a secondary zone.
        """
        return pulumi.get(self, "secondary")

    @secondary.setter
    def secondary(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "secondary", value)


@pulumi.type_token("dnsimple:index/zone:Zone")
class Zone(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a DNSimple zone resource.

        > Currently the resource creation acts as an import, so the zone must already exist in DNSimple. The only attribute that will be modified during resource creation is the `active` state of the zone. This is because our API does not allow for the creation of zones. Creation of zones happens through the purchase or creation of domains. We expect this behavior to change in the future.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dnsimple as dnsimple

        # Create a zone
        foobar = dnsimple.Zone("foobar", name=dnsimple["zone"])
        ```

        ## Import

        DNSimple zones can be imported using their numeric record ID or the zone name.

        bash

        ```sh
        $ pulumi import dnsimple:index/zone:Zone resource_name foo.com
        ```

        The zone ID can be found within [DNSimple Zones API](https://developer.dnsimple.com/v2/zones/#getZone). Check out [Authentication](https://developer.dnsimple.com/v2/#authentication) in API Overview for available options.

        bash

        curl -H 'Authorization: Bearer <ACCESS_TOKEN>' https://api.dnsimple.com/v2/1234/zones/example.com | jq

        {

          "data": {

            "id": 1,
            
            "account_id": 1234,
            
            "name": "example.com",
            
            "reverse": false,
            
            "secondary": false,
            
            "last_transferred_at": null,
            
            "active": true,
            
            "created_at": "2023-04-18T04:58:01Z",
            
            "updated_at": "2024-01-16T15:53:18Z"

          }

        }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] active: Whether the zone is active.
        :param pulumi.Input[_builtins.str] name: The zone name
               
               # Attributes Reference
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZoneArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DNSimple zone resource.

        > Currently the resource creation acts as an import, so the zone must already exist in DNSimple. The only attribute that will be modified during resource creation is the `active` state of the zone. This is because our API does not allow for the creation of zones. Creation of zones happens through the purchase or creation of domains. We expect this behavior to change in the future.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dnsimple as dnsimple

        # Create a zone
        foobar = dnsimple.Zone("foobar", name=dnsimple["zone"])
        ```

        ## Import

        DNSimple zones can be imported using their numeric record ID or the zone name.

        bash

        ```sh
        $ pulumi import dnsimple:index/zone:Zone resource_name foo.com
        ```

        The zone ID can be found within [DNSimple Zones API](https://developer.dnsimple.com/v2/zones/#getZone). Check out [Authentication](https://developer.dnsimple.com/v2/#authentication) in API Overview for available options.

        bash

        curl -H 'Authorization: Bearer <ACCESS_TOKEN>' https://api.dnsimple.com/v2/1234/zones/example.com | jq

        {

          "data": {

            "id": 1,
            
            "account_id": 1234,
            
            "name": "example.com",
            
            "reverse": false,
            
            "secondary": false,
            
            "last_transferred_at": null,
            
            "active": true,
            
            "created_at": "2023-04-18T04:58:01Z",
            
            "updated_at": "2024-01-16T15:53:18Z"

          }

        }

        :param str resource_name: The name of the resource.
        :param ZoneArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZoneArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZoneArgs.__new__(ZoneArgs)

            __props__.__dict__["active"] = active
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["account_id"] = None
            __props__.__dict__["last_transferred_at"] = None
            __props__.__dict__["reverse"] = None
            __props__.__dict__["secondary"] = None
        super(Zone, __self__).__init__(
            'dnsimple:index/zone:Zone',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.int]] = None,
            active: Optional[pulumi.Input[_builtins.bool]] = None,
            last_transferred_at: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            reverse: Optional[pulumi.Input[_builtins.bool]] = None,
            secondary: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Zone':
        """
        Get an existing Zone resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] account_id: The account ID for the zone.
        :param pulumi.Input[_builtins.bool] active: Whether the zone is active.
        :param pulumi.Input[_builtins.str] last_transferred_at: The last time the zone was transferred only applicable for **secondary** zones.
        :param pulumi.Input[_builtins.str] name: The zone name
               
               # Attributes Reference
        :param pulumi.Input[_builtins.bool] reverse: Whether the zone is a reverse zone.
        :param pulumi.Input[_builtins.bool] secondary: Whether the zone is a secondary zone.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZoneState.__new__(_ZoneState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["active"] = active
        __props__.__dict__["last_transferred_at"] = last_transferred_at
        __props__.__dict__["name"] = name
        __props__.__dict__["reverse"] = reverse
        __props__.__dict__["secondary"] = secondary
        return Zone(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.int]:
        """
        The account ID for the zone.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def active(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the zone is active.
        """
        return pulumi.get(self, "active")

    @_builtins.property
    @pulumi.getter(name="lastTransferredAt")
    def last_transferred_at(self) -> pulumi.Output[_builtins.str]:
        """
        The last time the zone was transferred only applicable for **secondary** zones.
        """
        return pulumi.get(self, "last_transferred_at")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The zone name

        # Attributes Reference
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def reverse(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the zone is a reverse zone.
        """
        return pulumi.get(self, "reverse")

    @_builtins.property
    @pulumi.getter
    def secondary(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the zone is a secondary zone.
        """
        return pulumi.get(self, "secondary")

